/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.rmi.trace.TraceRmi;
import org.apache.commons.lang3.ArrayUtils;

public interface ValueDecoder {
    public static final ValueDecoder DEFAULT = new ValueDecoder(){};

    default public Address toAddress(TraceRmi.Addr addr, boolean required) {
        if (required) {
            throw new IllegalStateException("Address requires a trace for context");
        }
        return null;
    }

    default public AddressRange toRange(TraceRmi.AddrRange range, boolean required) throws AddressOverflowException {
        if (required) {
            throw new IllegalStateException("AddressRange requires a trace for context");
        }
        return null;
    }

    default public Object getObject(TraceRmi.ObjSpec spec, boolean required) {
        if (required) {
            throw new IllegalStateException("TraceObject requires a trace for context");
        }
        return null;
    }

    default public Object getObject(TraceRmi.ObjDesc desc, boolean required) {
        if (required) {
            throw new IllegalStateException("TraceObject requires a trace for context");
        }
        return null;
    }

    default public Object toValue(TraceRmi.Value value) throws AddressOverflowException {
        return switch (value.getValueCase()) {
            case TraceRmi.Value.ValueCase.NULL_VALUE -> null;
            case TraceRmi.Value.ValueCase.BOOL_VALUE -> value.getBoolValue();
            case TraceRmi.Value.ValueCase.BYTE_VALUE -> (byte)value.getByteValue();
            case TraceRmi.Value.ValueCase.CHAR_VALUE -> Character.valueOf((char)value.getCharValue());
            case TraceRmi.Value.ValueCase.SHORT_VALUE -> (short)value.getShortValue();
            case TraceRmi.Value.ValueCase.INT_VALUE -> value.getIntValue();
            case TraceRmi.Value.ValueCase.LONG_VALUE -> value.getLongValue();
            case TraceRmi.Value.ValueCase.STRING_VALUE -> value.getStringValue();
            case TraceRmi.Value.ValueCase.BOOL_ARR_VALUE -> (Object[])ArrayUtils.toPrimitive((Boolean[])((Boolean[])value.getBoolArrValue().getArrList().stream().toArray(Boolean[]::new)));
            case TraceRmi.Value.ValueCase.BYTES_VALUE -> (Object[])value.getBytesValue().toByteArray();
            case TraceRmi.Value.ValueCase.CHAR_ARR_VALUE -> (Object[])value.getCharArrValue().toCharArray();
            case TraceRmi.Value.ValueCase.SHORT_ARR_VALUE -> (Object[])ArrayUtils.toPrimitive((Short[])((Short[])value.getShortArrValue().getArrList().stream().map(Integer::shortValue).toArray(Short[]::new)));
            case TraceRmi.Value.ValueCase.INT_ARR_VALUE -> (Object[])value.getIntArrValue().getArrList().stream().mapToInt(Integer::intValue).toArray();
            case TraceRmi.Value.ValueCase.LONG_ARR_VALUE -> (Object[])value.getLongArrValue().getArrList().stream().mapToLong(Long::longValue).toArray();
            case TraceRmi.Value.ValueCase.STRING_ARR_VALUE -> (String[])value.getStringArrValue().getArrList().toArray(String[]::new);
            case TraceRmi.Value.ValueCase.ADDRESS_VALUE -> this.toAddress(value.getAddressValue(), true);
            case TraceRmi.Value.ValueCase.RANGE_VALUE -> this.toRange(value.getRangeValue(), true);
            case TraceRmi.Value.ValueCase.CHILD_SPEC -> this.getObject(value.getChildSpec(), true);
            case TraceRmi.Value.ValueCase.CHILD_DESC -> this.getObject(value.getChildDesc(), true);
            default -> throw new AssertionError((Object)("Unrecognized value: " + value));
        };
    }
}

