/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiTarget;
import ghidra.app.plugin.core.debug.service.tracermi.ValueDecoder;
import ghidra.debug.api.tracermi.TraceRmiError;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.time.TraceSnapshot;

class OpenTrace
implements ValueDecoder {
    final TraceRmiHandler.DoId doId;
    final Trace trace;
    final TraceRmiTarget target;
    TraceSnapshot lastSnapshot;

    OpenTrace(TraceRmiHandler.DoId doId, Trace trace, TraceRmiTarget target) {
        this.doId = doId;
        this.trace = trace;
        this.target = target;
    }

    public TraceSnapshot createSnapshot(TraceRmi.Snap snap, String description) {
        TraceSnapshot snapshot = this.trace.getTimeManager().getSnapshot(snap.getSnap(), true);
        snapshot.setDescription(description);
        this.lastSnapshot = snapshot;
        return this.lastSnapshot;
    }

    public TraceObject getObject(long id, boolean required) {
        TraceObject object = this.trace.getObjectManager().getObjectById(id);
        if (object == null) {
            throw new TraceRmiHandler.InvalidObjIdError();
        }
        return object;
    }

    public TraceObject getObject(TraceRmi.ObjPath path, boolean required) {
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(TraceRmiHandler.toKeyPath(path));
        if (required && object == null) {
            throw new TraceRmiHandler.InvalidObjPathError();
        }
        return object;
    }

    public TraceObject getObject(TraceRmi.ObjDesc desc, boolean required) {
        return this.getObject(desc.getId(), required);
    }

    public TraceObject getObject(TraceRmi.ObjSpec object, boolean required) {
        return switch (object.getKeyCase()) {
            case TraceRmi.ObjSpec.KeyCase.KEY_NOT_SET -> throw new TraceRmiError("Must set id or path");
            case TraceRmi.ObjSpec.KeyCase.ID -> this.getObject(object.getId(), required);
            case TraceRmi.ObjSpec.KeyCase.PATH -> this.getObject(object.getPath(), required);
            default -> throw new AssertionError();
        };
    }

    public AddressSpace getSpace(String name, boolean required) {
        AddressSpace space = this.trace.getBaseAddressFactory().getAddressSpace(name);
        if (required && space == null) {
            throw new TraceRmiHandler.NoSuchAddressSpaceError();
        }
        return space;
    }

    @Override
    public Address toAddress(TraceRmi.Addr addr, boolean required) {
        AddressSpace space = this.getSpace(addr.getSpace(), required);
        return space.getAddress(addr.getOffset());
    }

    @Override
    public AddressRange toRange(TraceRmi.AddrRange range, boolean required) throws AddressOverflowException {
        AddressSpace space = this.getSpace(range.getSpace(), required);
        if (space == null) {
            return null;
        }
        Address min = space.getAddress(range.getOffset());
        Address max = space.getAddress(range.getOffset() + range.getExtend());
        return new AddressRangeImpl(min, max);
    }

    public Register getRegister(String name, boolean required) {
        Register register = this.trace.getBaseLanguage().getRegister(name);
        if (required && register == null) {
            throw new TraceRmiHandler.InvalidRegisterError(name);
        }
        return register;
    }
}

