/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiPlugin;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public abstract class AbstractTraceRmiListener {
    protected final TraceRmiPlugin plugin;
    protected final SocketAddress address;
    protected ServerSocket socket;

    public AbstractTraceRmiListener(TraceRmiPlugin plugin, SocketAddress address) {
        this.plugin = plugin;
        this.address = address;
    }

    protected abstract void bind() throws IOException;

    public void start() throws IOException {
        this.socket = new ServerSocket();
        this.bind();
        this.startServiceLoop();
    }

    protected abstract void startServiceLoop();

    public void setTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    protected abstract TraceRmiServiceListener.ConnectMode getConnectMode();

    protected TraceRmiHandler doAccept(TraceRmiAcceptor acceptor) throws IOException {
        Socket client = this.socket.accept();
        TraceRmiHandler handler = new TraceRmiHandler(this.plugin, client);
        handler.start();
        ((TraceRmiServiceListener)this.plugin.listeners.invoke()).connected((TraceRmiConnection)handler, this.getConnectMode(), acceptor);
        return handler;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Msg.error((Object)"Error closing TraceRmi service", (Object)e);
        }
    }

    public SocketAddress getAddress() {
        return this.socket.getLocalSocketAddress();
    }
}

