/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.util.ShellUtils;
import ghidra.framework.Application;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;

public abstract class ScriptAttributesParser {
    public static final String AT_TITLE = "@title";
    public static final String AT_DESC = "@desc";
    public static final String AT_MENU_PATH = "@menu-path";
    public static final String AT_MENU_GROUP = "@menu-group";
    public static final String AT_MENU_ORDER = "@menu-order";
    public static final String AT_ICON = "@icon";
    public static final String AT_HELP = "@help";
    public static final String AT_ENUM = "@enum";
    public static final String AT_ENV = "@env";
    public static final String AT_ARG = "@arg";
    public static final String AT_ARGS = "@args";
    public static final String AT_TTY = "@tty";
    public static final String PREFIX_ENV = "env:";
    public static final String PREFIX_ARG = "arg:";
    public static final String KEY_ARGS = "args";
    public static final String MSGPAT_INVALID_HELP_SYNTAX = "%s: Invalid %s syntax. Use Topic#anchor";
    public static final String MSGPAT_INVALID_ENUM_SYNTAX = "%s: Invalid %s syntax. Use NAME:type Choice1 [ChoiceN...]";
    public static final String MSGPAT_INVALID_ENV_SYNTAX = "%s: Invalid %s syntax. Use NAME:type=default \"Display\" \"Tool Tip\"";
    public static final String MSGPAT_INVALID_ARG_SYNTAX = "%s: Invalid %s syntax. Use :type \"Display\" \"Tool Tip\"";
    public static final String MSGPAT_INVALID_ARGS_SYNTAX = "%s: Invalid %s syntax. Use \"Display\" \"Tool Tip\"";
    private int argc = 0;
    private String title;
    private StringBuilder description;
    private List<String> menuPath;
    private String menuGroup;
    private String menuOrder;
    private String iconId;
    private HelpLocation helpLocation;
    private final Map<String, UserType<?>> userTypes = new HashMap();
    private final Map<String, TargetMethod.ParameterDescription<?>> parameters = new LinkedHashMap();
    private final Set<String> extraTtys = new LinkedHashSet<String>();

    protected static String addrToString(InetAddress address) {
        if (address.isAnyLocalAddress()) {
            return "127.0.0.1";
        }
        return address.getHostAddress();
    }

    protected static String sockToString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress tcp = (InetSocketAddress)address;
            return ScriptAttributesParser.addrToString(tcp.getAddress()) + ":" + tcp.getPort();
        }
        throw new AssertionError((Object)("Unhandled address type " + address));
    }

    public static void processArguments(List<String> commandLine, Map<String, String> env, File script, Map<String, TargetMethod.ParameterDescription<?>> parameters, Map<String, ?> args, SocketAddress address) {
        TargetMethod.ParameterDescription<?> paramDesc;
        commandLine.add(script.getAbsolutePath());
        env.put("GHIDRA_HOME", Application.getInstallationDirectory().getAbsolutePath());
        if (address != null) {
            env.put("GHIDRA_TRACE_RMI_ADDR", ScriptAttributesParser.sockToString(address));
            if (address instanceof InetSocketAddress) {
                InetSocketAddress tcp = (InetSocketAddress)address;
                env.put("GHIDRA_TRACE_RMI_HOST", tcp.getAddress().toString());
                env.put("GHIDRA_TRACE_RMI_PORT", Integer.toString(tcp.getPort()));
            }
        }
        int i = 1;
        while ((paramDesc = parameters.get(PREFIX_ARG + i)) != null) {
            commandLine.add(Objects.toString(paramDesc.get(args)));
            ++i;
        }
        paramDesc = parameters.get(KEY_ARGS);
        if (paramDesc != null) {
            commandLine.addAll(ShellUtils.parseArgs((String)((String)paramDesc.get(args))));
        }
        for (Map.Entry<String, TargetMethod.ParameterDescription<?>> ent : parameters.entrySet()) {
            String key = ent.getKey();
            if (!key.startsWith(PREFIX_ENV)) continue;
            String varName = key.substring(PREFIX_ENV.length());
            env.put(varName, Objects.toString(ent.getValue().get(args)));
        }
    }

    protected abstract boolean ignoreLine(int var1, String var2);

    protected abstract String removeDelimiter(String var1);

    public ScriptAttributes parseFile(File script) throws FileNotFoundException {
        ScriptAttributes scriptAttributes;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(script)));
        try {
            String line;
            int lineNo = 1;
            while ((line = reader.readLine()) != null) {
                if (!this.ignoreLine(lineNo, line)) {
                    String comment = this.removeDelimiter(line);
                    if (comment == null) break;
                    this.parseComment(new Location(script.getName(), lineNo), comment);
                }
                ++lineNo;
            }
            scriptAttributes = this.validate(script.getName());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        reader.close();
        return scriptAttributes;
    }

    public void parseComment(Location loc, String comment) {
        if (comment.isBlank()) {
            return;
        }
        String[] parts = comment.split("\\s+", 2);
        if (!parts[0].startsWith("@")) {
            return;
        }
        if (parts.length < 2) {
            Msg.error((Object)this, (Object)"%s: Too few tokens: %s".formatted(loc, comment));
            return;
        }
        switch (parts[0].trim()) {
            case "@title": {
                this.parseTitle(loc, parts[1]);
                break;
            }
            case "@desc": {
                this.parseDesc(loc, parts[1]);
                break;
            }
            case "@menu-path": {
                this.parseMenuPath(loc, parts[1]);
                break;
            }
            case "@menu-group": {
                this.parseMenuGroup(loc, parts[1]);
                break;
            }
            case "@menu-order": {
                this.parseMenuOrder(loc, parts[1]);
                break;
            }
            case "@icon": {
                this.parseIcon(loc, parts[1]);
                break;
            }
            case "@help": {
                this.parseHelp(loc, parts[1]);
                break;
            }
            case "@enum": {
                this.parseEnum(loc, parts[1]);
                break;
            }
            case "@env": {
                this.parseEnv(loc, parts[1]);
                break;
            }
            case "@arg": {
                this.parseArg(loc, parts[1], ++this.argc);
                break;
            }
            case "@args": {
                this.parseArgs(loc, parts[1]);
                break;
            }
            case "@tty": {
                this.parseTty(loc, parts[1]);
                break;
            }
            default: {
                this.parseUnrecognized(loc, comment);
            }
        }
    }

    protected void parseTitle(Location loc, String str) {
        if (this.title != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate @title".formatted(loc));
        }
        this.title = str;
    }

    protected void parseDesc(Location loc, String str) {
        if (this.description == null) {
            this.description = new StringBuilder();
        }
        this.description.append(str);
        this.description.append("\n");
    }

    protected void parseMenuPath(Location loc, String str) {
        if (this.menuPath != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s".formatted(loc, AT_MENU_PATH));
        }
        this.menuPath = List.of(str.trim().split("\\."));
        if (this.menuPath.isEmpty()) {
            Msg.error((Object)this, (Object)"%s: Empty %s. Ignoring.".formatted(loc, AT_MENU_PATH));
        }
    }

    protected void parseMenuGroup(Location loc, String str) {
        if (this.menuGroup != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s".formatted(loc, AT_MENU_GROUP));
        }
        this.menuGroup = str;
    }

    protected void parseMenuOrder(Location loc, String str) {
        if (this.menuOrder != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s".formatted(loc, AT_MENU_ORDER));
        }
        this.menuOrder = str;
    }

    protected void parseIcon(Location loc, String str) {
        if (this.iconId != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s".formatted(loc, AT_ICON));
        }
        this.iconId = str.trim();
        if (!Gui.hasIcon((String)this.iconId)) {
            Msg.error((Object)this, (Object)"%s: Icon id %s not registered in the theme".formatted(loc, this.iconId));
        }
    }

    protected void parseHelp(Location loc, String str) {
        String[] parts;
        if (this.helpLocation != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s".formatted(loc, AT_HELP));
        }
        if ((parts = str.trim().split("#", 2)).length != 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_HELP_SYNTAX.formatted(loc, AT_HELP));
            return;
        }
        this.helpLocation = new HelpLocation(parts[0].trim(), parts[1].trim());
    }

    protected void parseEnum(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() < 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ENUM_SYNTAX.formatted(loc, AT_ENUM));
            return;
        }
        String[] nameParts = ((String)parts.get(0)).split(":", 2);
        if (nameParts.length != 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ENUM_SYNTAX.formatted(loc, AT_ENUM));
            return;
        }
        String name = nameParts[0].trim();
        BaseType<Object> baseType = BaseType.parse(loc, nameParts[1]);
        if (baseType == null) {
            return;
        }
        List<Object> choices = parts.stream().skip(1L).map(s -> baseType.decode(loc, (String)s)).toList();
        if (choices.contains(null)) {
            return;
        }
        UserType<?> userType = baseType.withCastChoices(choices);
        if (this.userTypes.put(name, userType) != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s %s. Replaced.".formatted(loc, AT_ENUM, name));
        }
    }

    protected void parseEnv(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 3) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        String[] nameParts = ((String)parts.get(0)).split(":", 2);
        if (nameParts.length != 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        String trimmed = nameParts[0].trim();
        String name = PREFIX_ENV + trimmed;
        String[] tadParts = nameParts[1].split("=", 2);
        if (tadParts.length != 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        TypeAndDefault<?> tad = TypeAndDefault.parse(loc, tadParts[0].trim(), tadParts[1].trim(), this.userTypes);
        TargetMethod.ParameterDescription<?> param = tad.createParameter(name, (String)parts.get(1), (String)parts.get(2));
        if (this.parameters.put(name, param) != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s %s. Replaced.".formatted(loc, AT_ENV, trimmed));
        }
    }

    protected void parseArg(Location loc, String str, int argNum) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 3) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ARG_SYNTAX.formatted(loc, AT_ARG));
            return;
        }
        String colonType = ((String)parts.get(0)).trim();
        if (!colonType.startsWith(":")) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ARG_SYNTAX.formatted(loc, AT_ARG));
            return;
        }
        OptType<?> type = OptType.parse(loc, colonType.substring(1), this.userTypes);
        if (type == null) {
            return;
        }
        String name = PREFIX_ARG + argNum;
        this.parameters.put(name, TargetMethod.ParameterDescription.create(type.cls(), (String)name, (boolean)true, null, (String)((String)parts.get(1)), (String)((String)parts.get(2))));
    }

    protected void parseArgs(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 2) {
            Msg.error((Object)this, (Object)MSGPAT_INVALID_ARGS_SYNTAX.formatted(loc, AT_ARGS));
            return;
        }
        TargetMethod.ParameterDescription parameter = TargetMethod.ParameterDescription.create(String.class, (String)KEY_ARGS, (boolean)false, (Object)"", (String)((String)parts.get(0)), (String)((String)parts.get(1)));
        if (this.parameters.put(KEY_ARGS, parameter) != null) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s. Replaced".formatted(loc, AT_ARGS));
        }
    }

    protected void parseTty(Location loc, String str) {
        if (!this.extraTtys.add(str)) {
            Msg.warn((Object)this, (Object)"%s: Duplicate %s. Ignored".formatted(loc, AT_TTY));
        }
    }

    protected void parseUnrecognized(Location loc, String line) {
        Msg.warn((Object)this, (Object)"%s: Unrecognized metadata: %s".formatted(loc, line));
    }

    protected ScriptAttributes validate(String fileName) {
        if (this.title == null) {
            Msg.error((Object)this, (Object)"%s is required. Using script file name.".formatted(AT_TITLE));
            this.title = fileName;
        }
        if (this.menuPath == null) {
            this.menuPath = List.of(this.title);
        }
        if (this.menuGroup == null) {
            this.menuGroup = "";
        }
        if (this.menuOrder == null) {
            this.menuOrder = "";
        }
        if (this.iconId == null) {
            this.iconId = "icon.debugger";
        }
        return new ScriptAttributes(this.title, this.getDescription(), List.copyOf(this.menuPath), this.menuGroup, this.menuOrder, (Icon)new GIcon(this.iconId), this.helpLocation, Collections.unmodifiableMap(new LinkedHashMap(this.parameters)), List.copyOf(this.extraTtys));
    }

    private String getDescription() {
        return this.description == null ? null : this.description.toString();
    }

    protected record Location(String fileName, int lineNo) {
        @Override
        public String toString() {
            return "%s:%d".formatted(this.fileName, this.lineNo);
        }
    }

    public record ScriptAttributes(String title, String description, List<String> menuPath, String menuGroup, String menuOrder, Icon icon, HelpLocation helpLocation, Map<String, TargetMethod.ParameterDescription<?>> parameters, Collection<String> extraTtys) {
    }

    protected static interface BaseType<T>
    extends OptType<T> {
        public static final BaseType<String> STRING = new BaseType<String>(){

            @Override
            public Class<String> cls() {
                return String.class;
            }

            @Override
            public String decode(Location loc, String str) {
                return str;
            }
        };
        public static final BaseType<BigInteger> INT = new BaseType<BigInteger>(){

            @Override
            public Class<BigInteger> cls() {
                return BigInteger.class;
            }

            @Override
            public BigInteger decode(Location loc, String str) {
                try {
                    if (str.startsWith("0x")) {
                        return new BigInteger(str.substring(2), 16);
                    }
                    return new BigInteger(str);
                }
                catch (NumberFormatException e) {
                    Msg.error(ScriptAttributesParser.class, (Object)"%s: Invalid int for %s: %s. You may prefix with 0x for hexadecimal. Otherwise, decimal is used.".formatted(loc, ScriptAttributesParser.AT_ENV, str));
                    return null;
                }
            }
        };
        public static final BaseType<Boolean> BOOL = new BaseType<Boolean>(){

            @Override
            public Class<Boolean> cls() {
                return Boolean.class;
            }

            @Override
            public Boolean decode(Location loc, String str) {
                Boolean result;
                switch (str) {
                    case "true": {
                        Boolean bl = true;
                        break;
                    }
                    case "false": {
                        Boolean bl = false;
                        break;
                    }
                    default: {
                        Boolean bl = result = null;
                    }
                }
                if (result == null) {
                    Msg.error(ScriptAttributesParser.class, (Object)"%s: Invalid bool for %s: %s. Only true or false (in lower case) is allowed.".formatted(loc, ScriptAttributesParser.AT_ENV, str));
                    return null;
                }
                return result;
            }
        };

        public static BaseType<?> parse(Location loc, String typeName) {
            BaseType<Object> type;
            switch (typeName) {
                case "str": {
                    BaseType<Object> baseType = STRING;
                    break;
                }
                case "int": {
                    BaseType<Object> baseType = INT;
                    break;
                }
                case "bool": {
                    BaseType<Object> baseType = BOOL;
                    break;
                }
                default: {
                    BaseType<Object> baseType = type = null;
                }
            }
            if (type == null) {
                Msg.error(ScriptAttributesParser.class, (Object)"%s: Invalid base type %s".formatted(loc, typeName));
                return null;
            }
            return type;
        }

        default public UserType<T> withCastChoices(List<?> choices) {
            return new UserType<Object>(this, choices.stream().map(this.cls()::cast).toList());
        }

        @Override
        default public TargetMethod.ParameterDescription<T> createParameter(String name, T defaultValue, String display, String description) {
            return TargetMethod.ParameterDescription.create(this.cls(), (String)name, (boolean)false, defaultValue, (String)display, (String)description);
        }
    }

    protected record UserType<T>(BaseType<T> base, List<T> choices) implements OptType<T>
    {
        @Override
        public Class<T> cls() {
            return this.base.cls();
        }

        @Override
        public T decode(Location loc, String str) {
            return this.base.decode(loc, str);
        }

        @Override
        public TargetMethod.ParameterDescription<T> createParameter(String name, T defaultValue, String display, String description) {
            return TargetMethod.ParameterDescription.choices(this.cls(), (String)name, this.choices, defaultValue, (String)display, (String)description);
        }
    }

    protected record TypeAndDefault<T>(OptType<T> type, T defaultValue) {
        public static TypeAndDefault<?> parse(Location loc, String typeName, String defaultString, Map<String, UserType<?>> userEnums) {
            OptType<?> tac = OptType.parse(loc, typeName, userEnums);
            if (tac == null) {
                return null;
            }
            Object value = tac.decode(loc, defaultString);
            if (value == null) {
                return null;
            }
            return tac.withCastDefault(value);
        }

        public TargetMethod.ParameterDescription<T> createParameter(String name, String display, String description) {
            return this.type.createParameter(name, this.defaultValue, display, description);
        }
    }

    protected static interface OptType<T> {
        public static OptType<?> parse(Location loc, String typeName, Map<String, UserType<?>> userEnums) {
            BaseType<Object> type;
            switch (typeName) {
                case "str": {
                    OptType<Object> optType = BaseType.STRING;
                    break;
                }
                case "int": {
                    OptType<Object> optType = BaseType.INT;
                    break;
                }
                case "bool": {
                    OptType<Object> optType = BaseType.BOOL;
                    break;
                }
                default: {
                    OptType<Object> optType = type = userEnums.get(typeName);
                }
            }
            if (type == null) {
                Msg.error(ScriptAttributesParser.class, (Object)"%s: Invalid type %s".formatted(loc, typeName));
                return null;
            }
            return type;
        }

        default public TypeAndDefault<T> withCastDefault(Object defaultValue) {
            return new TypeAndDefault<T>(this, this.cls().cast(defaultValue));
        }

        public Class<T> cls();

        public T decode(Location var1, String var2);

        public TargetMethod.ParameterDescription<T> createParameter(String var1, T var2, String var3, String var4);
    }
}

