/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GColorUIResource;
import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.JavaPropertyValue;
import generic.theme.laf.FontNonUiResource;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.apache.commons.collections4.IteratorUtils;

public class UiDefaultsMapper {
    public static final String LAF_COLOR_ID_PREFIX = "laf.color.";
    public static final String LAF_FONT_ID_PREFIX = "laf.font.";
    public static final String LAF_ICON_ID_PREFIX = "laf.icon.";
    public static final String LAF_PROPERTY_PREFIX = "laf.property.";
    private static final String LAF_COLOR_PALETTE_PREFIX = "laf.palette.color.";
    private static final String LAF_FONT_PALETTE_PREFIX = "laf.palette.font.";
    private static final String[] MENU_COMPONENTS = new String[]{"Menu", "MenuBar", "MenuItem", "PopupMenu", "RadioButtonMenuItem", "CheckBoxMenuItem"};
    private static final String[] VIEW_COMPONENTS = new String[]{"FileChooser", "ColorChooser", "ComboBox", "List", "Table", "Tree", "TextField", "FormattedTextField", "PasswordField", "TextArea", "TextPane", "EditorPane"};
    private static final String[] TOOLTIP_COMPONENTS = new String[]{"ToolTip"};
    protected UIDefaults defaults;
    private GThemeValueMap extractedValues;
    private GThemeValueMap normalizedValues = new GThemeValueMap();
    private Map<String, String> javaIdToNormalizedId = new HashMap<String, String>();
    protected Set<String> ignoredJavaIds = new HashSet<String>();
    private Map<String, ColorGrouper> componentToColorGrouper = new HashMap<String, ColorGrouper>();
    private Map<String, FontGrouper> componentToFontGrouper = new HashMap<String, FontGrouper>();
    protected ColorGrouper viewColorGrouper = new ColorGrouper("system.color.bg.view", "system.color.fg.view", "system.color.bg.selected.view", "system.color.fg.selected.view");
    protected ColorGrouper tooltipColorGrouper = new ColorGrouper("system.color.bg.tooltip", "system.color.fg.tooltip");
    protected ColorGrouper defaultColorMatcher = new ColorGrouper("system.color.bg.control", "system.color.fg.control", "system.color.bg.view", "system.color.fg.view", "system.color.fg.disabled", "system.color.bg.selected.view", "system.color.fg.selected.view", "system.color.bg.tooltip", "system.color.bg.border");
    protected FontGrouper menuFontGrouper = new FontGrouper("system.font.menu");
    protected FontGrouper viewFontGrouper = new FontGrouper("system.font.view");
    protected FontGrouper defaultFontMatcher = new FontGrouper("system.font.control", "system.font.view", "system.font.menu");
    private Map<Color, String> lafColorPaletteMap = new HashMap<Color, String>();
    private Map<Font, String> lafFontPaletteMap = new HashMap<Font, String>();
    private int nextColorPaletteId;
    private int nextFontPaletteId;

    protected UiDefaultsMapper(UIDefaults defaults) {
        this.defaults = defaults;
        this.extractedValues = this.extractColorFontAndIconValuesFromDefaults();
        this.pickRepresentativeValueForColorGroups();
        this.pickRepresentativeValueForFontGroups();
        this.registerIgnoredJavaIds();
        this.buildComponentToColorGrouperMap();
        this.buildComponentToFontGrouperMap();
        this.assignNormalizedColorValues();
        this.assignNormalizedFontValues();
        this.assignNormalizedIconValues();
    }

    public GThemeValueMap getNormalizedJavaDefaults() {
        return this.normalizedValues;
    }

    public void installValuesIntoUIDefaults(GThemeValueMap currentValues) {
        this.installGColorsIntoUIDefaults();
        this.installOverriddenFontsIntoUIDefaults(currentValues);
        this.installOverriddenIconsIntoUIDefaults(currentValues);
        this.installOverriddenPropertiesIntoUIDefaults(currentValues);
    }

    public Map<String, String> getNormalizedIdToLafIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.javaIdToNormalizedId.entrySet()) {
            String lafId = entry.getKey();
            String standardId = entry.getValue();
            map.put(standardId, lafId);
        }
        return map;
    }

    protected void registerIgnoredJavaIds() {
        this.ignoredJavaIds.add("desktop");
        this.ignoredJavaIds.add("activeCaption");
        this.ignoredJavaIds.add("activeCaptionText");
        this.ignoredJavaIds.add("activeCaptionBorder");
        this.ignoredJavaIds.add("inactiveCaption");
        this.ignoredJavaIds.add("inactiveCaptionText");
        this.ignoredJavaIds.add("inactiveCaptionBorder");
        this.ignoredJavaIds.add("window");
        this.ignoredJavaIds.add("windowBorder");
        this.ignoredJavaIds.add("windowText");
        this.ignoredJavaIds.add("menu");
        this.ignoredJavaIds.add("menuText");
        this.ignoredJavaIds.add("text");
        this.ignoredJavaIds.add("textText");
        this.ignoredJavaIds.add("textHighlight");
        this.ignoredJavaIds.add("textHighightText");
        this.ignoredJavaIds.add("textInactiveText");
        this.ignoredJavaIds.add("control");
        this.ignoredJavaIds.add("controlText");
        this.ignoredJavaIds.add("controlHighlight");
        this.ignoredJavaIds.add("controlLtHighlight");
        this.ignoredJavaIds.add("controlShadow");
        this.ignoredJavaIds.add("controlDkShadow");
        this.ignoredJavaIds.add("info");
        this.ignoredJavaIds.add("infoText");
        this.ignoredJavaIds.add("scrollbar");
    }

    protected void pickRepresentativeValueForColorGroups() {
        this.setGroupColorUsingJavaRepresentative("system.color.bg.control", "Button.background");
        this.setGroupColorUsingJavaRepresentative("system.color.fg.control", "Button.foreground");
        this.setGroupColorUsingJavaRepresentative("system.color.bg.border", "InternalFrame.borderColor");
        this.setGroupColorUsingJavaRepresentative("system.color.bg.view", "TextArea.background");
        this.setGroupColorUsingJavaRepresentative("system.color.fg.view", "TextArea.foreground");
        this.setGroupColorUsingJavaRepresentative("system.color.bg.selected.view", "TextArea.selectionBackground");
        this.setGroupColorUsingJavaRepresentative("system.color.fg.selected.view", "TextArea.selectionForeground");
        this.setGroupColorUsingJavaRepresentative("system.color.fg.disabled", "Label.disabledForeground");
        this.setGroupColorUsingJavaRepresentative("system.color.bg.tooltip", "ToolTip.background");
        this.setGroupColorUsingJavaRepresentative("system.color.fg.tooltip", "ToolTip.foreground");
    }

    protected void setGroupColorUsingJavaRepresentative(String group, String javaId) {
        Color javaColor = this.defaults.getColor(javaId);
        if (javaColor == null) {
            Msg.debug((Object)this, (Object)("Missing value for system color: \"" + group + "\". No value for java id: \"" + javaId + "\"."));
            return;
        }
        this.normalizedValues.addColor(new ColorValue(group, javaColor));
    }

    protected void setGroupColor(String group, Color color) {
        this.normalizedValues.addColor(new ColorValue(group, color));
    }

    protected void setGroupFont(String group, Font font) {
        this.normalizedValues.addFont(new FontValue(group, font));
    }

    protected void setComponentFont(String componentName, Font font) {
        this.normalizedValues.addFont(new FontValue(componentName, font));
    }

    protected void pickRepresentativeValueForFontGroups() {
        this.setGroupFontUsingRepresentative("system.font.control", "Button.font");
        this.setGroupFontUsingRepresentative("system.font.view", "Table.font");
        this.setGroupFontUsingRepresentative("system.font.menu", "Menu.font");
    }

    private void setGroupFontUsingRepresentative(String fontGroup, String javaId) {
        Font representativeFont = this.extractedValues.getResolvedFont(javaId);
        if (representativeFont == null) {
            Msg.debug((Object)this, (Object)("Missing value for system font: \"" + fontGroup + "\". No value for java id: \"" + javaId + "\"."));
            return;
        }
        this.normalizedValues.addFont(new FontValue(fontGroup, this.fromUiResource(representativeFont)));
    }

    protected void buildComponentToFontGrouperMap() {
        this.mapComponentsToFontGrouper(this.menuFontGrouper, MENU_COMPONENTS);
        this.mapComponentsToFontGrouper(this.viewFontGrouper, VIEW_COMPONENTS);
    }

    protected void buildComponentToColorGrouperMap() {
        this.mapComponentsToColorGrouper(this.viewColorGrouper, VIEW_COMPONENTS);
        this.mapComponentsToColorGrouper(this.tooltipColorGrouper, TOOLTIP_COMPONENTS);
    }

    private void mapComponentsToColorGrouper(ColorGrouper grouper, String ... componentGroup) {
        for (String name : componentGroup) {
            this.componentToColorGrouper.put(name, grouper);
        }
    }

    private void mapComponentsToFontGrouper(FontGrouper grouper, String ... componentGroup) {
        for (String name : componentGroup) {
            this.componentToFontGrouper.put(name, grouper);
        }
    }

    private void assignNormalizedFontValues() {
        ArrayList<String> list = new ArrayList<String>(this.extractedValues.getFontIds());
        Collections.sort(list);
        for (String lafId : list) {
            if (this.ignoredJavaIds.contains(lafId)) continue;
            String createdId = LAF_FONT_ID_PREFIX + lafId;
            this.javaIdToNormalizedId.put(lafId, createdId);
            Font lafFont = this.extractedValues.getResolvedFont(lafId);
            FontValue fontValue = this.getFontValue(createdId, lafId, lafFont);
            this.normalizedValues.addFont(fontValue);
        }
    }

    private void assignNormalizedIconValues() {
        for (String lafId : this.extractedValues.getIconIds()) {
            String createdId = LAF_ICON_ID_PREFIX + lafId;
            Icon icon = this.extractedValues.getResolvedIcon(lafId);
            if (icon == null) continue;
            this.normalizedValues.addIcon(new IconValue(createdId, icon));
            this.javaIdToNormalizedId.put(lafId, createdId);
        }
    }

    protected void assignNormalizedColorValues() {
        ArrayList<String> list = new ArrayList<String>(this.extractedValues.getColorIds());
        Collections.sort(list);
        for (String lafId : list) {
            if (this.ignoredJavaIds.contains(lafId)) continue;
            String createdId = LAF_COLOR_ID_PREFIX + lafId;
            this.javaIdToNormalizedId.put(lafId, createdId);
            Color lafColor = this.extractedValues.getResolvedColor(lafId);
            ColorValue colorValue = this.getColorValue(createdId, lafId, lafColor);
            this.normalizedValues.addColor(colorValue);
        }
    }

    private ColorValue getColorValue(String id, String lafId, Color lafColor) {
        String systemId = this.findSystemColorId(lafId, lafColor);
        if (systemId == null) {
            systemId = this.getColorPaletteId(lafColor);
        }
        return new ColorValue(id, systemId);
    }

    private FontValue getFontValue(String id, String lafId, Font lafFont) {
        String systemFontId = this.findSystemFontId(lafId, lafFont);
        if (systemFontId == null) {
            systemFontId = this.getFontPaletteId(lafFont);
        }
        return new FontValue(id, systemFontId);
    }

    private String getColorPaletteId(Color lafColor) {
        String paletteId = this.lafColorPaletteMap.get(lafColor);
        if (paletteId == null) {
            ++this.nextColorPaletteId;
            paletteId = String.format("%s%02d", LAF_COLOR_PALETTE_PREFIX, this.nextColorPaletteId);
            this.lafColorPaletteMap.put(lafColor, paletteId);
            this.normalizedValues.addColor(new ColorValue(paletteId, lafColor));
        }
        return paletteId;
    }

    private String getFontPaletteId(Font lafFont) {
        String paletteId = this.lafFontPaletteMap.get(lafFont);
        if (paletteId == null) {
            ++this.nextFontPaletteId;
            paletteId = String.format("%s%02d", LAF_FONT_PALETTE_PREFIX, this.nextFontPaletteId);
            this.lafFontPaletteMap.put(lafFont, paletteId);
            this.normalizedValues.addFont(new FontValue(paletteId, lafFont));
        }
        return paletteId;
    }

    private String findSystemColorId(String lafId, Color lafColor) {
        String systemId;
        String componentName = this.getComponentName(lafId);
        ColorGrouper colorMatcher = this.componentToColorGrouper.get(componentName);
        if (colorMatcher != null && (systemId = colorMatcher.getGroupId(lafColor)) != null) {
            return systemId;
        }
        return this.defaultColorMatcher.getGroupId(lafColor);
    }

    private String findSystemFontId(String lafId, Font lafFont) {
        String systemId;
        String componentName = this.getComponentName(lafId);
        FontGrouper fontMatcher = this.componentToFontGrouper.get(componentName);
        if (fontMatcher != null && (systemId = fontMatcher.getGroupId(lafFont)) != null) {
            return systemId;
        }
        return this.defaultFontMatcher.getGroupId(lafFont);
    }

    private String getComponentName(String lafId) {
        int dotIndex = lafId.indexOf(".");
        if (dotIndex < 0) {
            return lafId;
        }
        return lafId.substring(0, dotIndex);
    }

    protected void installGColorsIntoUIDefaults() {
        HashMap<String, GColorUIResource> cachedColors = new HashMap<String, GColorUIResource>();
        for (String lafId : this.extractedValues.getColorIds()) {
            String standardColorId = this.javaIdToNormalizedId.get(lafId);
            if (standardColorId == null) continue;
            GColorUIResource sharedGColor = this.getSharedGColor(cachedColors, standardColorId);
            this.defaults.put(lafId, sharedGColor);
        }
    }

    private void installOverriddenIconsIntoUIDefaults(GThemeValueMap currentValues) {
        for (String lafId : this.extractedValues.getIconIds()) {
            Icon currentIcon = this.extractedValues.getResolvedIcon(lafId);
            String standardId = this.javaIdToNormalizedId.get(lafId);
            Icon overriddenIcon = currentValues.getResolvedIcon(standardId);
            if (overriddenIcon == null || currentIcon == overriddenIcon) continue;
            this.defaults.put(lafId, overriddenIcon);
        }
    }

    private void installOverriddenFontsIntoUIDefaults(GThemeValueMap currentValues) {
        for (String lafId : this.extractedValues.getFontIds()) {
            Font currentFont = this.extractedValues.getResolvedFont(lafId);
            String standardId = this.javaIdToNormalizedId.get(lafId);
            Font overriddenFont = currentValues.getResolvedFont(standardId);
            if (overriddenFont == null || overriddenFont == currentFont) continue;
            this.defaults.put(lafId, new FontUIResource(overriddenFont));
        }
    }

    private void installOverriddenPropertiesIntoUIDefaults(GThemeValueMap currentValues) {
        for (JavaPropertyValue property : currentValues.getProperties()) {
            this.defaults.put(property.getId(), property.get(currentValues));
        }
    }

    private GColorUIResource getSharedGColor(Map<String, GColorUIResource> cache, String id) {
        GColorUIResource gColor = cache.get(id);
        if (gColor == null) {
            gColor = new GColorUIResource(id);
            cache.put(id, gColor);
        }
        return gColor;
    }

    protected void overrideColor(String lafId, String sytemId) {
        String normalizedId = this.javaIdToNormalizedId.get(lafId);
        if (normalizedId == null) {
            Msg.debug((Object)this, (Object)("Missing value for laf id: \"" + lafId));
            return;
        }
        this.normalizedValues.addColor(new ColorValue(normalizedId, sytemId));
    }

    protected GThemeValueMap extractColorFontAndIconValuesFromDefaults() {
        GThemeValueMap values = new GThemeValueMap();
        List<String> ids = this.getLookAndFeelIdsForType(Color.class);
        for (String id : ids) {
            values.addColor(new ColorValue(id, this.defaults.getColor(id)));
        }
        ids = this.getLookAndFeelIdsForType(Font.class);
        for (String id : ids) {
            values.addFont(new FontValue(id, this.defaults.getFont(id)));
        }
        ids = this.getLookAndFeelIdsForType(Icon.class);
        for (String id : ids) {
            Icon icon = this.defaults.getIcon(id);
            values.addIcon(new IconValue(id, icon));
        }
        return values;
    }

    private Font fromUiResource(Font font) {
        if (font instanceof UIResource) {
            return new FontNonUiResource(font);
        }
        return font;
    }

    private List<String> getLookAndFeelIdsForType(Class<?> clazz) {
        ArrayList<String> ids = new ArrayList<String>();
        List keyList = IteratorUtils.toList(this.defaults.keys().asIterator());
        for (Object key : keyList) {
            Object value;
            if (!(key instanceof String) || !clazz.isInstance(value = this.defaults.get(key))) continue;
            ids.add((String)key);
        }
        return ids;
    }

    private class ColorGrouper
    extends ValueGrouper<Color> {
        ColorGrouper(String ... systemIds) {
            super(systemIds);
        }

        @Override
        protected Color getValueFromJavaDefaults(String systemId) {
            return UiDefaultsMapper.this.normalizedValues.getResolvedColor(systemId);
        }
    }

    private class FontGrouper
    extends ValueGrouper<Font> {
        FontGrouper(String ... systemIds) {
            super(systemIds);
        }

        @Override
        protected Font getValueFromJavaDefaults(String systemId) {
            return UiDefaultsMapper.this.normalizedValues.getResolvedFont(systemId);
        }
    }

    private abstract class ValueGrouper<T> {
        private Map<T, String> idsByFont = new HashMap<T, String>();
        private List<String> groupIds;
        private boolean initialized;

        ValueGrouper(String ... ids) {
            this.groupIds = new ArrayList<String>(Arrays.asList(ids));
        }

        private void initialize() {
            this.initialized = true;
            for (int i = this.groupIds.size() - 1; i >= 0; --i) {
                String groupId = this.groupIds.get(i);
                T value = this.getValueFromJavaDefaults(groupId);
                if (value == null) continue;
                this.idsByFont.put(value, groupId);
            }
        }

        protected abstract T getValueFromJavaDefaults(String var1);

        String getGroupId(T value) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.idsByFont.get(value);
        }
    }
}

