/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ApplicationThemeManager;
import generic.theme.laf.FlatLookAndFeelManager;
import generic.theme.laf.GtkLookAndFeelManager;
import generic.theme.laf.LookAndFeelManager;
import generic.theme.laf.MacLookAndFeelManager;
import generic.theme.laf.MetalLookAndFeelManager;
import generic.theme.laf.MotifLookAndFeelManager;
import generic.theme.laf.NimbusLookAndFeelManager;
import generic.theme.laf.WindowsClassicLookAndFeelManager;
import generic.theme.laf.WindowsLookAndFeelManager;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.exception.AssertException;
import javax.swing.UIManager;

public enum LafType {
    METAL("Metal"),
    NIMBUS("Nimbus"),
    GTK("GTK+"),
    MOTIF("CDE/Motif"),
    FLAT_LIGHT("Flat Light"),
    FLAT_DARK("Flat Dark", true),
    WINDOWS("Windows"),
    WINDOWS_CLASSIC("Windows Classic"),
    MAC("Mac OS X");

    private String name;
    private boolean usesDarkDefaults;

    private LafType(String name) {
        this(name, false);
    }

    private LafType(String name, boolean usesDarkDefaults) {
        this.name = name;
        this.usesDarkDefaults = usesDarkDefaults;
    }

    public String getName() {
        return this.name;
    }

    public boolean usesDarkDefaults() {
        return this.usesDarkDefaults;
    }

    public static LafType fromName(String name) {
        for (LafType type : LafType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public boolean isSupported() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!this.name.equals(info.getName())) continue;
            return true;
        }
        return false;
    }

    public LookAndFeelManager getLookAndFeelManager(ApplicationThemeManager themeManager) {
        return LafType.createManager(this, themeManager);
    }

    private static LookAndFeelManager createManager(LafType type, ApplicationThemeManager themeManager) {
        switch (type) {
            case MAC: {
                return new MacLookAndFeelManager(themeManager);
            }
            case METAL: {
                return new MetalLookAndFeelManager(themeManager);
            }
            case WINDOWS: {
                return new WindowsLookAndFeelManager(themeManager);
            }
            case WINDOWS_CLASSIC: {
                return new WindowsClassicLookAndFeelManager(themeManager);
            }
            case GTK: {
                return new GtkLookAndFeelManager(themeManager);
            }
            case MOTIF: {
                return new MotifLookAndFeelManager(themeManager);
            }
            case NIMBUS: {
                return new NimbusLookAndFeelManager(themeManager);
            }
            case FLAT_DARK: 
            case FLAT_LIGHT: {
                return new FlatLookAndFeelManager(type, themeManager);
            }
        }
        throw new AssertException("No lookAndFeelManager defined for " + type);
    }

    public static LafType getDefaultLookAndFeel() {
        OperatingSystem OS = Platform.CURRENT_PLATFORM.getOperatingSystem();
        switch (OS) {
            case MAC_OS_X: {
                return MAC;
            }
            case WINDOWS: {
                return WINDOWS;
            }
        }
        return NIMBUS;
    }

    public String toString() {
        return this.getName();
    }
}

