/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugSessionRecord;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.impl.DbgModelTargetMemoryContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetRootImpl;
import agent.dbgeng.model.impl.DbgModelTargetSessionContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetSessionImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerObjectModelWithMemory;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.AnnotatedSchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DbgModelImpl
extends AbstractDbgModel
implements DebuggerObjectModelWithMemory {
    protected static final String SPACE_NAME = "ram";
    protected static final AnnotatedSchemaContext SCHEMA_CTX = new AnnotatedSchemaContext();
    protected static final TargetObjectSchema ROOT_SCHEMA = SCHEMA_CTX.getSchemaForClass(DbgModelTargetRootImpl.class);
    protected final AddressSpace space = new GenericAddressSpace("ram", 64, 1, 0);
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.space});
    protected final DbgManager dbg;
    protected final DbgModelTargetRootImpl root;
    protected final DbgModelTargetSessionImpl session;
    protected final CompletableFuture<DbgModelTargetRootImpl> completedRoot;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();
    private boolean suppressDescent = false;

    public DbgModelImpl() {
        this.dbg = DbgManager.newInstance();
        this.root = new DbgModelTargetRootImpl(this, ROOT_SCHEMA);
        this.completedRoot = CompletableFuture.completedFuture(this.root);
        DbgSession s = this.dbg.getSessionComputeIfAbsent(new DebugSessionRecord(0L), true);
        DbgModelTargetSessionContainerImpl sessions = this.root.sessions;
        this.session = (DbgModelTargetSessionImpl)sessions.getTargetSession(s);
        this.addModelRoot(this.root);
    }

    public String getBrief() {
        return "DBGENG@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    public AddressSpace getAddressSpace(String name) {
        if (!SPACE_NAME.equals(name)) {
            return null;
        }
        return this.space;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public CompletableFuture<Void> startDbgEng(String[] args) {
        return this.dbg.start(args).thenApplyAsync(__ -> null, (Executor)this.clientExecutor);
    }

    @Override
    public boolean isRunning() {
        return this.dbg.isRunning();
    }

    @Override
    public void terminate() throws IOException {
        this.broadcast().modelClosed(DebuggerModelClosedReason.NORMAL);
        this.root.invalidateSubtree((TargetObject)this.root, "Dbgeng is terminating");
        this.dbg.terminate();
    }

    public TargetObjectSchema getRootSchema() {
        return this.root.getSchema();
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    @Override
    public DbgManager getManager() {
        return this.dbg;
    }

    public CompletableFuture<Void> close() {
        try {
            this.terminate();
            return super.close();
        }
        catch (RejectedExecutionException e) {
            this.reportError((Object)this, "Model is already closing", e);
            return AsyncUtils.nil();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public DbgModelTargetSession getSession() {
        return this.session;
    }

    public TargetMemory getMemory(TargetObject target, Address address, int length) {
        if (target instanceof DbgModelTargetProcess) {
            DbgModelTargetProcess process = (DbgModelTargetProcess)target;
            return new DbgModelTargetMemoryContainerImpl(process);
        }
        return null;
    }

    @Override
    public void addModelObject(Object object, TargetObject targetObject) {
        this.objectMap.put(object, targetObject);
    }

    @Override
    public TargetObject getModelObject(Object object) {
        return this.objectMap.get(object);
    }

    @Override
    public void deleteModelObject(Object object) {
        this.objectMap.remove(object);
    }

    public <T> CompletableFuture<T> gateFuture(CompletableFuture<T> future) {
        return super.gateFuture(future).exceptionally(ex -> {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RejectedExecutionException)) continue;
                throw new DebuggerModelTerminatingException("dbgeng is terminating", ex);
            }
            return ExceptionUtils.rethrow((Throwable)ex);
        });
    }

    @Override
    public boolean isSuppressDescent() {
        return this.suppressDescent;
    }

    public void setSuppressDescent(boolean suppressDescent) {
        this.suppressDescent = suppressDescent;
    }
}

