/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface1;

import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import ghidra.dbg.target.TargetSteppable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetSteppable
extends DbgModelTargetObject,
TargetSteppable {
    default public DbgManager.ExecSuffix convertToDbg(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case FINISH: {
                return DbgManager.ExecSuffix.FINISH;
            }
            case INTO: {
                return DbgManager.ExecSuffix.STEP_INSTRUCTION;
            }
            case LINE: {
                return DbgManager.ExecSuffix.STEP;
            }
            case OVER: {
                return DbgManager.ExecSuffix.NEXT_INSTRUCTION;
            }
            case OVER_LINE: {
                return DbgManager.ExecSuffix.NEXT;
            }
            case RETURN: {
                return DbgManager.ExecSuffix.RETURN;
            }
            case UNTIL: {
                return DbgManager.ExecSuffix.UNTIL;
            }
            case EXTENDED: {
                return DbgManager.ExecSuffix.EXTENDED;
            }
        }
        throw new AssertionError();
    }

    default public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        DbgThreadImpl thread = this.getManager().getCurrentThread();
        switch (kind) {
            case SKIP: {
                throw new UnsupportedOperationException(kind.name());
            }
        }
        if (this instanceof DbgModelTargetThread) {
            DbgModelTargetThread targetThread = (DbgModelTargetThread)this;
            return this.getModel().gateFuture(targetThread.getThread().step(this.convertToDbg(kind)));
        }
        if (this instanceof DbgModelTargetProcess) {
            DbgModelTargetProcess targetProcess = (DbgModelTargetProcess)this;
            DbgProcess process = targetProcess.getProcess();
            if (process == null) {
                process = this.getManager().getCurrentProcess();
            }
            return this.getModel().gateFuture(process.step(this.convertToDbg(kind)));
        }
        return this.getModel().gateFuture(thread.step(this.convertToDbg(kind)));
    }

    default public CompletableFuture<Void> step(Map<String, ?> args) {
        DbgThreadImpl thread = this.getManager().getCurrentThread();
        return this.getModel().gateFuture(thread.step(args));
    }
}

