/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgSectionImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbgListMappingsCommand
extends AbstractDbgCommand<Map<Long, DbgSectionImpl>> {
    protected final DbgProcessImpl process;
    private List<DebugThreadId> updatedThreadIds;

    public DbgListMappingsCommand(DbgManagerImpl manager, DbgProcessImpl process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Map<Long, DbgSectionImpl> complete(DbgPendingCommand<?> pending) {
        Map<DebugThreadId, DbgThread> threads = this.process.getKnownThreads();
        Set<DebugThreadId> cur = threads.keySet();
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId previous = so.getCurrentThreadId();
        for (DebugThreadId id : this.updatedThreadIds) {
            if (cur.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Was missing thread: " + id));
            so.setCurrentThreadId(id);
            int tid = so.getCurrentThreadSystemId();
            this.manager.getThreadComputeIfAbsent(id, this.process, tid, false);
        }
        for (DebugThreadId id : new ArrayList<DebugThreadId>(cur)) {
            if (this.updatedThreadIds.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra thread: " + id));
            this.process.removeThread(id);
            this.manager.removeThread(id);
        }
        so.setCurrentThreadId(previous);
        return this.process.getKnownMappings();
    }

    @Override
    public void invoke() {
    }
}

