/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.Sym;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;

class SymPcodeArithmetic
implements PcodeArithmetic<Sym> {
    private final Language language;
    private final CompilerSpec cSpec;

    public SymPcodeArithmetic(CompilerSpec cSpec) {
        this.cSpec = cSpec;
        this.language = cSpec.getLanguage();
    }

    public Endian getEndian() {
        return this.language.isBigEndian() ? Endian.BIG : Endian.LITTLE;
    }

    public Sym unaryOp(int opcode, int sizeout, int sizein1, Sym in1) {
        switch (opcode) {
            case 1: {
                return in1;
            }
        }
        return Sym.opaque();
    }

    public Sym binaryOp(int opcode, int sizeout, int sizein1, Sym in1, int sizein2, Sym in2) {
        switch (opcode) {
            case 19: {
                return in1.add(this.cSpec, in2);
            }
            case 20: {
                return in1.sub(this.cSpec, in2);
            }
        }
        return Sym.opaque();
    }

    public Sym modBeforeStore(int sizeout, int sizeinAddress, Sym inAddress, int sizeinValue, Sym inValue) {
        return inValue;
    }

    public Sym modAfterLoad(int sizeout, int sizeinAddress, Sym inAddress, int sizeinValue, Sym inValue) {
        return inValue;
    }

    public Sym fromConst(byte[] value) {
        return new Sym.ConstSym(Utils.bytesToLong((byte[])value, (int)value.length, (boolean)this.language.isBigEndian()), value.length);
    }

    public byte[] toConcrete(Sym value, PcodeArithmetic.Purpose purpose) {
        if (value instanceof Sym.ConstSym) {
            Sym.ConstSym constVal = (Sym.ConstSym)value;
            return Utils.longToBytes((long)constVal.value(), (int)constVal.size(), (boolean)this.language.isBigEndian());
        }
        throw new ConcretionError("Not a constant: " + value, purpose);
    }

    public long sizeOf(Sym value) {
        return value.sizeOf(this.cSpec);
    }
}

