/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;

public class MapRegionsBackgroundCommand
extends BackgroundCommand {
    private final DebuggerStaticMappingService service;
    private final Collection<RegionMapProposal.RegionMapEntry> entries;

    public MapRegionsBackgroundCommand(DebuggerStaticMappingService service, Collection<RegionMapProposal.RegionMapEntry> entries) {
        super("Map regions", true, true, true);
        this.service = service;
        this.entries = entries;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        try {
            this.service.addRegionMappings(this.entries, monitor, true);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }
}

