/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.app.plugin.core.debug.service.modules.ModuleRegionMatcher;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class DefaultModuleMapProposal
extends AbstractMapProposal<TraceModule, Program, ModuleMapProposal.ModuleMapEntry>
implements ModuleMapProposal {
    protected final TraceModule module;
    protected final NavigableMap<Long, ModuleRegionMatcher> matchers = new TreeMap<Long, ModuleRegionMatcher>();
    protected Address imageBase;
    protected Address moduleBase;
    protected long imageSize;
    protected AddressRange moduleRange;

    protected DefaultModuleMapProposal(TraceModule module, Program program) {
        super(module.getTrace(), program);
        this.module = module;
        this.processProgram();
        this.processModule();
    }

    public TraceModule getModule() {
        return this.module;
    }

    private ModuleRegionMatcher getMatcher(long baseOffset) {
        return this.matchers.computeIfAbsent(baseOffset, ModuleRegionMatcher::new);
    }

    private void processProgram() {
        this.imageBase = this.program.getImageBase();
        this.imageSize = DefaultModuleMapEntry.computeImageSize(this.program);
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            if (!DefaultModuleMapEntry.includeBlock(this.program, block)) continue;
            this.getMatcher((long)block.getStart().subtract((Address)this.imageBase)).block = block;
        }
    }

    private void processModule() {
        this.moduleBase = this.module.getBase();
        try {
            this.moduleRange = new AddressRangeImpl(this.moduleBase, this.imageSize);
        }
        catch (AddressOverflowException e) {
            return;
        }
        Lifespan lifespan = this.module.getLifespan();
        for (TraceMemoryRegion region : this.module.getTrace().getMemoryManager().getRegionsIntersecting(lifespan, this.moduleRange)) {
            Address address;
            if (region instanceof TraceObjectMemoryRegion) {
                TraceObjectMemoryRegion objReg = (TraceObjectMemoryRegion)region;
                address = objReg.getMinAddress(lifespan.lmin());
            } else {
                address = region.getMinAddress();
            }
            Address min = address;
            this.getMatcher((long)min.subtract((Address)this.moduleBase)).region = region;
        }
    }

    public double computeScore() {
        return (double)this.matchers.values().stream().reduce(0, (s, m) -> s + m.score(), Integer::sum).intValue() / (double)this.matchers.size();
    }

    public Map<TraceModule, ModuleMapProposal.ModuleMapEntry> computeMap() {
        return Map.of(this.module, new DefaultModuleMapEntry(this.module, this.program, this.moduleRange));
    }

    public Program getToObject(TraceModule from) {
        if (from != this.module) {
            return null;
        }
        return this.program;
    }

    public static class DefaultModuleMapEntry
    extends AbstractMapEntry<TraceModule, Program>
    implements ModuleMapProposal.ModuleMapEntry {
        protected AddressRange moduleRange;
        protected boolean memorize = false;

        public static boolean includeBlock(Program program, MemoryBlock block) {
            if (program.getImageBase().getAddressSpace() != block.getStart().getAddressSpace()) {
                return false;
            }
            if (!block.isLoaded()) {
                return false;
            }
            if (block.isMapped()) {
                return false;
            }
            return !block.isExternalBlock();
        }

        public static long computeImageSize(Program program) {
            Address imageBase = program.getImageBase();
            long imageSize = 0L;
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!DefaultModuleMapEntry.includeBlock(program, block)) continue;
                imageSize = Math.max(imageSize, block.getEnd().subtract(imageBase) + 1L);
            }
            return imageSize;
        }

        protected DefaultModuleMapEntry(TraceModule module, Program program, AddressRange moduleRange) {
            super(module.getTrace(), module, program, program);
            this.moduleRange = moduleRange;
        }

        public TraceModule getModule() {
            return (TraceModule)this.getFromObject();
        }

        public Lifespan getFromLifespan() {
            return this.getModule().getLifespan();
        }

        public AddressRange getFromRange() {
            return this.moduleRange;
        }

        public AddressRange getModuleRange() {
            return this.moduleRange;
        }

        public void setProgram(Program program) {
            this.setToObject(program, program);
            try {
                this.moduleRange = new AddressRangeImpl(this.getModule().getBase(), DefaultModuleMapEntry.computeImageSize(program));
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException("Specified program is too large for module's memory space");
            }
        }

        public AddressRange getToRange() {
            try {
                return new AddressRangeImpl(this.getToProgram().getImageBase(), this.moduleRange.getLength());
            }
            catch (AddressOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        public boolean isMemorize() {
            return this.memorize;
        }

        public void setMemorize(boolean memorize) {
            this.memorize = memorize;
        }
    }
}

