/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.frida;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOpinion;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.model.DebuggerProgramLaunchOffer;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.Collection;
import java.util.List;

public class FridaDebuggerProgramLaunchOpinion
extends AbstractDebuggerProgramLaunchOpinion {
    protected static final List<Class<? extends DebuggerProgramLaunchOffer>> OFFER_CLASSES = List.of(InVmFridaDebuggerProgramLaunchOffer.class, GadpFridaDebuggerProgramLaunchOffer.class);

    @Override
    protected Collection<Class<? extends DebuggerProgramLaunchOffer>> getOfferClasses() {
        return OFFER_CLASSES;
    }

    @AbstractDebuggerProgramLaunchOpinion.FactoryClass(value="agent.frida.FridaInJvmDebuggerModelFactory")
    protected static class InVmFridaDebuggerProgramLaunchOffer
    extends AbstractFridaDebuggerProgramLaunchOffer {
        public InVmFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        public String getConfigName() {
            return "IN-VM Frida";
        }

        public String getMenuTitle() {
            return "in Frida locally IN-VM";
        }
    }

    @AbstractDebuggerProgramLaunchOpinion.FactoryClass(value="agent.frida.gadp.FridaGadpDebuggerModelFactory")
    protected static class GadpFridaDebuggerProgramLaunchOffer
    extends AbstractFridaDebuggerProgramLaunchOffer {
        public GadpFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        public String getConfigName() {
            return "GADP Frida";
        }

        public String getMenuTitle() {
            return "in Frida locally via GADP";
        }
    }

    protected static abstract class AbstractFridaDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getMenuParentTitle() {
            return "Debug " + this.program.getName();
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"");
        }
    }
}

