/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.plugin.core.debug.gui.DebuggerBlockChooserDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoMapSpec;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerLegacyModulesPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerLegacySectionsPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerMissingModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionsPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingPlugin;
import ghidra.app.plugin.core.debug.service.model.TraceRecorderTarget;
import ghidra.app.plugin.core.debug.service.modules.MapModulesBackgroundCommand;
import ghidra.app.plugin.core.debug.service.modules.MapSectionsBackgroundCommand;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.modules.MapProposal;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.debug.api.modules.SectionMapProposal;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceClosedException;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.ArrayUtils;

public class DebuggerModulesProvider
extends ComponentProviderAdapter {
    protected static final AutoConfigState.ClassHandler<DebuggerModulesProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerModulesProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final DebuggerModulesPlugin plugin;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    ProgramManager programManager;
    @AutoServiceConsumed
    private GoToService goToService;
    @AutoServiceConsumed
    private FileImporterService importerService;
    private final AutoService.Wiring autoServiceWiring;
    private final JSplitPane mainPanel = new JSplitPane(0);
    DebuggerModulesPanel modulesPanel;
    DebuggerLegacyModulesPanel legacyModulesPanel;
    DebuggerSectionsPanel sectionsPanel;
    DebuggerLegacySectionsPanel legacySectionsPanel;
    private final DebuggerBlockChooserDialog blockChooserDialog;
    private final DebuggerModuleMapProposalDialog moduleProposalDialog;
    private final DebuggerSectionMapProposalDialog sectionProposalDialog;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private ActionContext myActionContext;
    DockingAction actionMapIdentically;
    DockingAction actionMapManually;
    DockingAction actionMapModules;
    DockingAction actionMapModuleTo;
    DockingAction actionMapSections;
    DockingAction actionMapSectionTo;
    DockingAction actionMapSectionsTo;
    MultiStateDockingAction<AutoMapSpec> actionAutoMap;
    private final AutoMapSpec defaultAutoMapSpec;
    @AutoConfigStateField(codec=AutoMapSpec.AutoMapSpecConfigFieldCodec.class)
    AutoMapSpec autoMapSpec = this.defaultAutoMapSpec = AutoMapSpec.fromConfigName("1_MAP_BY_MODULE");
    boolean cueAutoMap;
    private ForMappingTraceListener forMappingListener;
    DockingAction actionImportMissingModule;
    DockingAction actionMapMissingModule;
    SelectAddressesAction actionSelectAddresses;
    ImportFromFileSystemAction actionImportFromFileSystem;
    ToggleDockingAction actionFilterSectionsByModules;
    DockingAction actionSelectCurrent;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (a.getSnap() != b.getSnap()) {
            return false;
        }
        return Objects.equals(a.getObject(), b.getObject());
    }

    protected static Set<TraceModule> getSelectedModules(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedModulesFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedModulesFromContext(ctx);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedModulesFromContext(ctx);
        }
        return Set.of();
    }

    protected static Set<TraceSection> getSelectedSections(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedSectionsFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedSectionsFromContext(ctx);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedSectionsFromContext(ctx);
        }
        return Set.of();
    }

    protected static AddressSetView getSelectedAddresses(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedAddressesFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedAddressesFromContext(ctx);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedAddressesFromContext(ctx);
        }
        return null;
    }

    public DebuggerModulesProvider(DebuggerModulesPlugin plugin) {
        super(plugin.getTool(), "Modules", plugin.getName(), null);
        this.plugin = plugin;
        this.setIcon(DebuggerResources.ICON_PROVIDER_MODULES);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MODULES);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.blockChooserDialog = new DebuggerBlockChooserDialog(this.tool);
        this.moduleProposalDialog = new DebuggerModuleMapProposalDialog(this);
        this.sectionProposalDialog = new DebuggerSectionMapProposalDialog(this);
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.setVisible(true);
        this.createActions();
    }

    private void importModuleFromFileSystem(TraceModule module) {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setSelectedFile(new File(module.getName()));
        File file = chooser.getSelectedFile();
        chooser.dispose();
        if (file == null) {
            return;
        }
        Project activeProject = Objects.requireNonNull(AppInfo.getActiveProject());
        DomainFolder root = activeProject.getProjectData().getRootFolder();
        this.importerService.importFile(root, file);
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null) {
            if (this.actionImportMissingModule != null) {
                consoleService.addResolutionAction((DockingActionIf)this.actionImportMissingModule);
            }
            if (this.actionMapMissingModule != null) {
                consoleService.addResolutionAction((DockingActionIf)this.actionMapMissingModule);
            }
        }
    }

    protected void dispose() {
        if (this.consoleService != null) {
            if (this.actionImportMissingModule != null) {
                this.consoleService.removeResolutionAction((DockingActionIf)this.actionImportMissingModule);
            }
            if (this.actionMapMissingModule != null) {
                this.consoleService.removeResolutionAction((DockingActionIf)this.actionMapMissingModule);
            }
        }
        this.blockChooserDialog.dispose();
        this.moduleProposalDialog.dispose();
        this.sectionProposalDialog.dispose();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected boolean isFilterSectionsByModules() {
        return this.actionFilterSectionsByModules.isSelected();
    }

    void modulesPanelContextChanged() {
        this.myActionContext = this.modulesPanel.getActionContext();
        if (this.isFilterSectionsByModules()) {
            this.sectionsPanel.reload();
        }
        this.contextChanged();
    }

    void legacyModulesPanelContextChanged() {
        this.myActionContext = this.legacyModulesPanel.getActionContext();
        if (this.isFilterSectionsByModules()) {
            this.legacySectionsPanel.loadSections();
        }
        this.contextChanged();
    }

    void sectionsPanelContextChanged() {
        this.myActionContext = this.sectionsPanel.getActionContext();
        this.contextChanged();
    }

    void legacySectionsPanelContextChanged() {
        this.myActionContext = this.legacySectionsPanel.getActionContext();
        this.contextChanged();
    }

    protected void buildMainPanel() {
        this.mainPanel.setContinuousLayout(true);
        this.modulesPanel = new DebuggerModulesPanel(this);
        this.mainPanel.setLeftComponent(this.modulesPanel);
        this.legacyModulesPanel = new DebuggerLegacyModulesPanel(this);
        this.sectionsPanel = new DebuggerSectionsPanel(this);
        this.mainPanel.setRightComponent(this.sectionsPanel);
        this.legacySectionsPanel = new DebuggerLegacySectionsPanel(this);
        this.mainPanel.setResizeWeight(0.5);
    }

    protected void createActions() {
        this.actionMapIdentically = (DockingAction)((ActionBuilder)((ActionBuilder)MapIdenticallyAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.current.getTrace() != null)).onAction(this::activatedMapIdentically)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapManually = (DockingAction)((ActionBuilder)((ActionBuilder)MapManuallyAction.builder(this.plugin).enabled(true)).onAction(this::activatedMapManually)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapModules = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapModulesAction.builder(this.plugin).enabledWhen(this::isContextNonEmpty)).popupWhen(this::isContextNonEmpty)).onAction(this::activatedMapModules)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapModuleTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapModuleToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedModules(ctx).size() == 1)).popupWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedModules(ctx).size() == 1)).onAction(this::activatedMapModuleTo)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSections = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionsAction.builder(this.plugin).enabledWhen(this::isContextNonEmpty)).popupWhen(this::isContextNonEmpty)).onAction(this::activatedMapSections)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSectionTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedSections(ctx).size() == 1)).popupWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedSections(ctx).size() == 1)).onAction(this::activatedMapSectionTo)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSectionsTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionsToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.isContextSectionsOfOneModule((ActionContext)ctx))).popupWhen(ctx -> this.currentProgram != null && this.isContextSectionsOfOneModule((ActionContext)ctx))).onAction(this::activatedMapSectionsTo)).buildAndInstallLocal((ComponentProvider)this);
        this.actionAutoMap = (MultiStateDockingAction)AutoMapAction.builder(this.plugin).onActionStateChanged(this::changedAutoMapSpec).buildAndInstallLocal((ComponentProvider)this);
        this.actionAutoMap.setCurrentActionStateByUserData((Object)this.defaultAutoMapSpec);
        this.actionImportMissingModule = (DockingAction)DebuggerResources.ImportMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedImportMissingModule).build();
        this.actionMapMissingModule = (DockingAction)DebuggerResources.MapMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedMapMissingModule).build();
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionImportFromFileSystem = new ImportFromFileSystemAction();
        this.actionFilterSectionsByModules = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FilterAction.builder(this.plugin).description("Filter sections to those in selected modules")).helpLocation(new HelpLocation(this.plugin.getName(), "filter_by_module"))).onAction(this::toggledFilter)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectCurrent = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).enabledWhen(ctx -> this.current.getTrace() != null)).description("Select modules and sections by dynamic selection")).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    private boolean isContextNonEmpty(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return !ctx.getSelectedModules().isEmpty();
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return !ctx.getSelectedSections().isEmpty();
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return !ctx.getObjectValues().isEmpty();
        }
        return false;
    }

    private boolean isContextSectionsOfOneModule(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        try {
            return sel.stream().map(TraceSection::getModule).distinct().count() == 1L;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Could not check section selection context: " + e));
            return false;
        }
    }

    private void activatedMapIdentically(ActionContext ignored) {
        if (this.currentProgram == null || this.current.getTrace() == null) {
            return;
        }
        try {
            this.staticMappingService.addIdentityMapping(this.current.getTrace(), this.currentProgram, Lifespan.nowOn((long)this.traceManager.getCurrentSnap()), true);
        }
        catch (TraceConflictedMappingException e) {
            Msg.showError((Object)((Object)this), null, (String)"Map Identically", (Object)e.getMessage());
        }
    }

    private void activatedMapManually(ActionContext ignored) {
        ComponentProvider provider = this.tool.getComponentProvider("Static Mappings");
        if (provider != null) {
            this.tool.showComponentProvider(provider, true);
            return;
        }
        try {
            this.tool.addPlugin(DebuggerStaticMappingPlugin.class.getName());
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), (Component)this.mainPanel, (String)"Map Manually", (Object)"DebuggerStaticMappingPlugin could not be enabled", (Throwable)e);
            return;
        }
        provider = this.tool.getComponentProvider("Static Mappings");
        assert (provider != null);
        this.tool.showComponentProvider(provider, true);
    }

    private void activatedMapModules(ActionContext ignored) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapModules(sel);
    }

    private void activatedMapModuleTo(ActionContext ignored) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(this.myActionContext);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapModuleTo(sel.iterator().next());
    }

    private void activatedMapSections(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSections(sel);
    }

    private void activatedMapSectionsTo(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSectionsTo(sel);
    }

    private void activatedMapSectionTo(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapSectionTo(sel.iterator().next());
    }

    private void changedAutoMapSpec(ActionState<AutoMapSpec> newState, EventTrigger trigger) {
        this.doSetAutoMapSpec((AutoMapSpec)newState.getUserData());
    }

    private void doSetAutoMapSpec(AutoMapSpec autoMapSpec) {
        if (this.autoMapSpec == autoMapSpec) {
            return;
        }
        this.removeOldTraceListener();
        this.autoMapSpec = autoMapSpec;
        this.addNewTraceListener();
    }

    private void activatedImportMissingModule(DebuggerMissingModuleActionContext context) {
        if (this.importerService == null) {
            Msg.error((Object)((Object)this), (Object)"Import service is not present");
        }
        this.importModuleFromFileSystem(context.getModule());
    }

    private void activatedMapMissingModule(DebuggerMissingModuleActionContext context) {
        this.mapModuleTo(context.getModule());
    }

    private void toggledFilter(ActionContext ignored) {
        boolean filtered = this.isFilterSectionsByModules();
        this.sectionsPanel.setFilteredBySelectedModules(filtered);
        this.legacySectionsPanel.setFilteredBySelectedModules(filtered);
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        if (this.listingService == null || this.traceManager == null || this.current.getTrace() == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceModuleManager moduleManager = this.current.getTrace().getModuleManager();
        if (progSel != null && !progSel.isEmpty()) {
            long snap = this.traceManager.getCurrentSnap();
            HashSet<TraceModule> modSel = new HashSet<TraceModule>();
            HashSet<TraceSection> sectionSel = new HashSet<TraceSection>();
            for (AddressRange range : progSel) {
                for (TraceModule module : moduleManager.getModulesIntersecting(Lifespan.at((long)snap), range)) {
                    if (!module.getSections().isEmpty()) continue;
                    modSel.add(module);
                }
                for (TraceSection section : moduleManager.getSectionsIntersecting(Lifespan.at((long)snap), range)) {
                    sectionSel.add(section);
                    modSel.add(section.getModule());
                }
            }
            this.setSelectedModules(modSel);
            this.setSelectedSections(sectionSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null) {
            Address address = progLoc.getAddress();
            Set<TraceSection> sectionsAt = Set.copyOf(moduleManager.getSectionsAt(this.traceManager.getCurrentSnap(), address));
            if (!sectionsAt.isEmpty()) {
                Set<TraceModule> modulesAt = sectionsAt.stream().map(TraceSection::getModule).collect(Collectors.toSet());
                this.setSelectedModules(modulesAt);
                this.setSelectedSections(sectionsAt);
                return;
            }
            TraceModule bestModule = null;
            for (TraceModule module : moduleManager.getLoadedModules(this.traceManager.getCurrentSnap())) {
                Address base = module.getBase();
                if (base == null || base.getAddressSpace() != address.getAddressSpace()) continue;
                if (bestModule == null) {
                    bestModule = module;
                    continue;
                }
                if (base.compareTo((Object)address) > 0 || base.compareTo((Object)bestModule.getBase()) <= 0) continue;
                bestModule = module;
            }
            if (bestModule.getSections().isEmpty()) {
                this.setSelectedModules(Set.of(bestModule));
                return;
            }
        }
    }

    protected void promptModuleProposal(Collection<ModuleMapProposal.ModuleMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Modules", (Object)"Could not formulate a proposal for any selected module. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<ModuleMapProposal.ModuleMapEntry> adjusted = this.moduleProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapModulesBackgroundCommand(this.staticMappingService, adjusted), (UndoableDomainObject)this.current.getTrace());
    }

    protected void mapModules(Set<TraceModule> modules) {
        if (this.staticMappingService == null) {
            return;
        }
        Map map = this.staticMappingService.proposeModuleMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection proposal = MapProposal.flatten(map.values());
        this.promptModuleProposal(proposal);
    }

    protected void mapModuleTo(TraceModule module) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        ModuleMapProposal proposal = this.staticMappingService.proposeModuleMap(module, program);
        Map map = proposal.computeMap();
        this.promptModuleProposal(map.values());
    }

    protected void promptSectionProposal(Collection<SectionMapProposal.SectionMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Sections", (Object)"Could not formulate a proposal for any selected section. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<SectionMapProposal.SectionMapEntry> adjusted = this.sectionProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapSectionsBackgroundCommand(this.staticMappingService, adjusted), (UndoableDomainObject)this.current.getTrace());
    }

    protected void mapSections(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        Map map = this.staticMappingService.proposeSectionMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection proposal = MapProposal.flatten(map.values());
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionsTo(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        if (modules.size() != 1) {
            return;
        }
        TraceModule module = (TraceModule)modules.iterator().next();
        SectionMapProposal map = this.staticMappingService.proposeSectionMap(module, program);
        Collection proposal = map.computeMap().values();
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionTo(TraceSection section) {
        if (this.staticMappingService == null) {
            return;
        }
        ProgramLocation location = this.currentLocation;
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return;
        }
        SectionMapProposal map = this.staticMappingService.proposeSectionMap(section, location.getProgram(), block);
        this.promptSectionProposal(map.computeMap().values());
    }

    protected Set<MemoryBlock> collectBlocksInOpenPrograms() {
        HashSet<MemoryBlock> result = new HashSet<MemoryBlock>();
        for (Program p : this.programManager.getAllOpenPrograms()) {
            if (p instanceof Trace) continue;
            result.addAll(List.of(p.getMemory().getBlocks()));
        }
        return result;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setProgram(Program program) {
        DomainFile df;
        this.currentProgram = program;
        String name = program != null ? ((df = program.getDomainFile()) != null ? df.getName() : program.getName()) : "...";
        this.actionMapModuleTo.getPopupMenuData().setMenuItemName("Map Module to " + name);
        this.actionMapSectionsTo.getPopupMenuData().setMenuItemName("Map Sections to " + name);
    }

    public static MemoryBlock computeBlock(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Program program = location.getProgram();
        if (program == null) {
            return null;
        }
        Address addr = location.getAddress();
        if (addr == null) {
            return null;
        }
        return program.getMemory().getBlock(addr);
    }

    public static String computeBlockName(ProgramLocation location) {
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return "...";
        }
        Program program = location.getProgram();
        String name = program.getName();
        DomainFile df = program.getDomainFile();
        if (df != null) {
            name = df.getName();
        }
        return name + ":" + block.getName();
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
        String name = "Map Section to " + DebuggerModulesProvider.computeBlockName(location);
        this.actionMapSectionTo.getPopupMenuData().setMenuItemName(name);
    }

    public void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
    }

    protected void addNewTraceListener() {
        if (this.current.getTrace() != null && this.autoMapSpec != null) {
            this.forMappingListener = new ForMappingTraceListener(this.autoMapSpec);
            this.current.getTrace().addListener((DomainObjectListener)this.forMappingListener);
        }
    }

    protected void removeOldTraceListener() {
        if (this.forMappingListener != null) {
            if (this.current.getTrace() != null) {
                this.current.getTrace().removeListener((DomainObjectListener)this.forMappingListener);
            }
            this.forMappingListener = null;
        }
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        boolean changeTrace;
        if (DebuggerModulesProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean bl = changeTrace = this.current.getTrace() != coordinates.getTrace();
        if (changeTrace) {
            this.myActionContext = null;
            this.removeOldTraceListener();
        }
        this.current = coordinates;
        if (changeTrace) {
            this.addNewTraceListener();
        }
        if (Trace.isLegacy((Trace)coordinates.getTrace())) {
            this.modulesPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.sectionsPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacyModulesPanel.coordinatesActivated(coordinates);
            this.legacySectionsPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.legacyModulesPanel) == -1) {
                this.mainPanel.remove(this.modulesPanel);
                this.mainPanel.remove(this.sectionsPanel);
                this.mainPanel.setLeftComponent(this.legacyModulesPanel);
                this.mainPanel.setRightComponent(this.legacySectionsPanel);
                this.mainPanel.validate();
            }
        } else {
            this.legacyModulesPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacySectionsPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.modulesPanel.coordinatesActivated(coordinates);
            this.sectionsPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.modulesPanel) == -1) {
                this.mainPanel.remove(this.legacyModulesPanel);
                this.mainPanel.remove(this.legacySectionsPanel);
                this.mainPanel.setLeftComponent(this.modulesPanel);
                this.mainPanel.setRightComponent(this.sectionsPanel);
                this.mainPanel.validate();
            }
        }
        this.contextChanged();
        if (coordinates.getTarget() instanceof TraceRecorderTarget) {
            this.cueAutoMap = true;
        }
        this.doCuedAutoMap();
    }

    private void doCuedAutoMap() {
        if (this.cueAutoMap) {
            this.cueAutoMap = false;
            Trace trace = this.current.getTrace();
            if (this.autoMapSpec != null && trace != null) {
                this.autoMapSpec.runTask(this.tool, trace);
            }
        }
    }

    public void setSelectedModules(Set<TraceModule> sel) {
        if (Trace.isLegacy((Trace)this.current.getTrace())) {
            this.legacyModulesPanel.setSelectedModules(sel);
        } else {
            this.modulesPanel.setSelectedModules(sel);
        }
    }

    public void setSelectedSections(Set<TraceSection> sel) {
        if (Trace.isLegacy((Trace)this.current.getTrace())) {
            this.legacySectionsPanel.setSelectedSections(sel);
        } else {
            this.sectionsPanel.setSelectedSections(sel);
        }
    }

    private DataTreeDialog getProgramChooserDialog() {
        DomainFileFilter filter = df -> Program.class.isAssignableFrom(df.getDomainObjectClass());
        return new DataTreeDialog(null, "Map Module to Program", 0, filter){
            {
                this.dialogShown();
            }
        };
    }

    public DomainFile askProgram(Program program) {
        DataTreeDialog dialog = this.getProgramChooserDialog();
        if (program != null) {
            dialog.selectDomainFile(program.getDomainFile());
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getDomainFile();
    }

    public Map.Entry<Program, MemoryBlock> askBlock(TraceSection section, Program program, MemoryBlock block) {
        if (this.programManager == null) {
            Msg.warn((Object)((Object)this), (Object)"No program manager!");
            return null;
        }
        return this.blockChooserDialog.chooseBlock(this.getTool(), section, List.of(this.programManager.getAllOpenPrograms()));
    }

    public void setAutoMapSpec(AutoMapSpec spec) {
        this.actionAutoMap.setCurrentActionStateByUserData((Object)spec);
    }

    public AutoMapSpec getAutoMapSpec() {
        return this.autoMapSpec;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionAutoMap.setCurrentActionStateByUserData((Object)this.autoMapSpec);
    }

    static interface MapIdenticallyAction {
        public static final String NAME = "Map Identically";
        public static final String DESCRIPTION = "Map the current trace to the current program using identical addresses";
        public static final Icon ICON = DebuggerResources.ICON_MAP_IDENTICALLY;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_identically";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapManuallyAction {
        public static final String NAME = "Map Manually";
        public static final String DESCRIPTION = "Map the current trace to various programs manually";
        public static final Icon ICON = DebuggerResources.ICON_MAPPINGS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_manually";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapModulesAction {
        public static final String NAME = "Map Modules";
        public static final String DESCRIPTION = "Map selected modules to program images";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_modules";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapModuleToAction {
        public static final String NAME_PREFIX = "Map Module to ";
        public static final String DESCRIPTION = "Map the selected module to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_module_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Module to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionsAction {
        public static final String NAME = "Map Sections";
        public static final String DESCRIPTION = "Map selected sections to program memory blocks";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionToAction {
        public static final String NAME_PREFIX = "Map Section to ";
        public static final String DESCRIPTION = "Map the selected section to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_section_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Section to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionsToAction {
        public static final String NAME_PREFIX = "Map Sections to ";
        public static final String DESCRIPTION = "Map the selected module sections to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Sections to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface AutoMapAction {
        public static final String NAME = "Auto-Map Target Memory";
        public static final Icon ICON = DebuggerResources.ICON_CONFIG;
        public static final String DESCRIPTION = "Automatically map dynamic memory to static counterparts";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "auto_map";

        public static MultiStateActionBuilder<AutoMapSpec> builder(Plugin owner) {
            String ownerName = owner.getName();
            MultiStateActionBuilder builder = (MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).useCheckboxForIcons(true).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
            for (AutoMapSpec spec : AutoMapSpec.allSpecs().values()) {
                builder.addState(spec.getMenuName(), spec.getMenuIcon(), (Object)spec);
            }
            return builder;
        }
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setDescription("Select addresses contained in modules or sections");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.listingService == null) {
                return;
            }
            AddressSetView sel = DebuggerModulesProvider.getSelectedAddresses(context);
            if (sel == null || sel.isEmpty()) {
                return;
            }
            sel = sel.intersect((AddressSetView)DebuggerModulesProvider.this.traceManager.getCurrentView().getMemory());
            ProgramSelection ps = new ProgramSelection(sel);
            DebuggerModulesProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerModulesProvider.this.isContextNonEmpty(context);
        }
    }

    protected class ImportFromFileSystemAction
    extends DebuggerResources.AbstractImportFromFileSystemAction {
        public static final String GROUP = "Dbg1. General";

        public ImportFromFileSystemAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setPopupMenuData(new MenuData(new String[]{"Import From File System"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.importerService == null) {
                return;
            }
            Set<TraceModule> modules = DebuggerModulesProvider.getSelectedModules(context);
            if (modules == null || modules.size() != 1) {
                return;
            }
            TraceModule mod = modules.iterator().next();
            DebuggerModulesProvider.this.importModuleFromFileSystem(mod);
        }

        public boolean isEnabledForContext(ActionContext context) {
            try {
                Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(context);
                return DebuggerModulesProvider.this.importerService != null && sel != null && sel.size() == 1;
            }
            catch (TraceClosedException e) {
                return false;
            }
        }
    }

    protected class ForMappingTraceListener
    extends TraceDomainObjectListener {
        public ForMappingTraceListener(AutoMapSpec spec) {
            for (TraceChangeType<?, ?> type : spec.getChangeTypes()) {
                this.listenFor(type, this::changed);
            }
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::memoryChanged);
        }

        private void changed() {
            DebuggerModulesProvider.this.cueAutoMap = true;
        }

        private void memoryChanged(TraceAddressSnapRange range) {
            if (range.getRange().getAddressSpace().isRegisterSpace()) {
                return;
            }
            if (DebuggerModulesProvider.this.current.getTarget() instanceof TraceRecorderTarget) {
                DebuggerModulesProvider.this.doCuedAutoMap();
            }
        }
    }
}

