/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.EditableColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;

public class TraceValueObjectEditableAttributeColumn<T>
extends TraceValueObjectAttributeColumn<T>
implements EditableColumn<ObjectTableModel.ValueRow, ObjectTableModel.ValueProperty<T>, Trace> {
    public TraceValueObjectEditableAttributeColumn(String attributeName, Class<T> attributeType) {
        super(attributeName, attributeType);
    }

    @Override
    public boolean isEditable(ObjectTableModel.ValueRow row, Settings settings, Trace dataSource, ServiceProvider serviceProvider) {
        return row != null;
    }

    @Override
    public void setValue(ObjectTableModel.ValueRow row, ObjectTableModel.ValueProperty<T> value, Settings settings, Trace dataSource, ServiceProvider serviceProvider) {
        TraceObject object = row.getValue().getChild();
        try (Transaction tx = object.getTrace().openTransaction("Edit column " + this.getColumnName());){
            object.setAttribute(Lifespan.nowOn((long)row.currentSnap()), this.attributeName, value.getValue());
        }
    }
}

