/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.target.TraceObjectValue;

public abstract class AbstractTraceValueObjectLengthColumn
extends TraceValueObjectPropertyColumn<Long> {
    private final String attributeName;

    public AbstractTraceValueObjectLengthColumn(String attributeName) {
        super(Long.class);
        this.attributeName = attributeName;
    }

    protected Long fromRange(AddressRange range) {
        return range.getLength();
    }

    @Override
    public ObjectTableModel.ValueProperty<Long> getProperty(ObjectTableModel.ValueRow row) {
        return new ObjectTableModel.ValueDerivedProperty<Long>(row, Long.class){

            @Override
            public Long getValue() {
                Object object;
                TraceObjectValue entry = this.row.getAttributeEntry(AbstractTraceValueObjectLengthColumn.this.attributeName);
                if (entry == null || !((object = entry.getValue()) instanceof AddressRange)) {
                    return null;
                }
                AddressRange range = (AddressRange)object;
                return AbstractTraceValueObjectLengthColumn.this.fromRange(range);
            }

            @Override
            public String getDisplay() {
                Long value = this.getValue();
                return value == null ? "" : "0x" + Long.toUnsignedString(value, 16);
            }

            @Override
            public String getHtmlDisplay() {
                Long value = this.getValue();
                return value == null ? "" : "<html><body style='font-family:monospaced'>0x" + Long.toUnsignedString(value, 16);
            }
        };
    }
}

