/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Trace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public interface AutoMapSpec
extends ExtensionPoint {
    public static final Private PRIVATE = new Private();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoMapSpec fromConfigName(String name) {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return AutoMapSpec.PRIVATE.specsByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AutoMapSpec> allSpecs() {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return new TreeMap<String, AutoMapSpec>(AutoMapSpec.PRIVATE.specsByName);
        }
    }

    public String getConfigName();

    public String getMenuName();

    default public Icon getMenuIcon() {
        return DebuggerResources.ICON_CONFIG;
    }

    public Collection<TraceChangeType<?, ?>> getChangeTypes();

    default public String getTaskTitle() {
        return this.getMenuName();
    }

    default public void runTask(PluginTool tool, final Trace trace) {
        final DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        final ProgramManager programManager = (ProgramManager)tool.getService(ProgramManager.class);
        if (mappingService == null || programManager == null) {
            return;
        }
        BackgroundCommand cmd = new BackgroundCommand(this.getTaskTitle(), true, true, false){

            public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                try {
                    AutoMapSpec.this.performMapping(mappingService, trace, programManager, monitor);
                    return true;
                }
                catch (CancelledException e) {
                    return false;
                }
            }
        };
        tool.executeBackgroundCommand(cmd, (UndoableDomainObject)trace);
    }

    public void performMapping(DebuggerStaticMappingService var1, Trace var2, ProgramManager var3, TaskMonitor var4) throws CancelledException;

    public static class Private {
        private final Map<String, AutoMapSpec> specsByName = new TreeMap<String, AutoMapSpec>();
        private final ChangeListener classListener = this::classesChanged;

        private Private() {
            ClassSearcher.addChangeListener((ChangeListener)this.classListener);
        }

        private synchronized void classesChanged(ChangeEvent evt) {
            MiscellaneousUtils.collectUniqueInstances(AutoMapSpec.class, this.specsByName, AutoMapSpec::getConfigName);
        }
    }

    public static class AutoMapSpecConfigFieldCodec
    implements AutoConfigState.ConfigFieldCodec<AutoMapSpec> {
        public AutoMapSpec read(SaveState state, String name, AutoMapSpec current) {
            String specName = state.getString(name, null);
            return AutoMapSpec.fromConfigName(specName);
        }

        public void write(SaveState state, String name, AutoMapSpec value) {
            state.putString(name, value.getConfigName());
        }
    }
}

