/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.tree.GTreeNode;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsPlugin;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsolePlugin;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingPlugin;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesPlugin;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPlugin;
import ghidra.app.plugin.core.debug.gui.model.DebuggerModelPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingPlugin;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.pcode.DebuggerPcodeStepperPlugin;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersPlugin;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPlugin;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimePlugin;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesPlugin;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.model.DebuggerProgramLaunchOffer;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.program.database.ProgramContentHandler;
import ghidra.trace.model.Trace;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import resources.MultiIcon;

public interface DebuggerResources {
    public static final String OPTIONS_CATEGORY_DEBUGGER = "Debugger";
    public static final String OPTIONS_CATEGORY_WORKFLOW = "Workflow";
    public static final Icon ICON_DEBUGGER = new GIcon("icon.debugger");
    public static final Icon ICON_CONNECTION = new GIcon("icon.debugger.connect");
    public static final Icon ICON_CONNECT_ACCEPT = new GIcon("icon.debugger.connect.accept");
    public static final Icon ICON_CONNECT_OUTBOUND = new GIcon("icon.debugger.connect.outbound");
    public static final Icon ICON_DISCONNECT = new GIcon("icon.debugger.disconnect");
    public static final Icon ICON_PROCESS = new GIcon("icon.debugger.process");
    public static final Icon ICON_TRACE = Trace.TRACE_ICON;
    public static final Icon ICON_THREAD = new GIcon("icon.debugger.thread");
    public static final Icon ICON_PROGRAM = ProgramContentHandler.PROGRAM_ICON;
    public static final Icon ICON_PROCESSOR = new GIcon("icon.debugger.processor");
    public static final Icon ICON_LAUNCH = new GIcon("icon.debugger.launch");
    public static final Icon ICON_ATTACH = new GIcon("icon.debugger.attach");
    public static final Icon ICON_RESUME = new GIcon("icon.debugger.resume");
    public static final Icon ICON_INTERRUPT = new GIcon("icon.debugger.interrupt");
    public static final Icon ICON_KILL = new GIcon("icon.debugger.kill");
    public static final Icon ICON_DETACH = new GIcon("icon.debugger.detach");
    public static final Icon ICON_RECORD = new GIcon("icon.debugger.record");
    public static final Icon ICON_STEP_INTO = new GIcon("icon.debugger.step.into");
    public static final Icon ICON_STEP_OVER = new GIcon("icon.debugger.step.over");
    public static final Icon ICON_SKIP_OVER = new GIcon("icon.debugger.skip.over");
    public static final Icon ICON_STEP_FINISH = new GIcon("icon.debugger.step.finish");
    public static final Icon ICON_STEP_BACK = new GIcon("icon.debugger.step.back");
    public static final Icon ICON_STEP_LAST = new GIcon("icon.debugger.step.last");
    public static final Icon ICON_SNAP_FORWARD = new GIcon("icon.debugger.snap.forward");
    public static final Icon ICON_SNAP_BACKWARD = new GIcon("icon.debugger.snap.backward");
    public static final Icon ICON_SEEK_PRESENT = new GIcon("icon.debugger.seek.present");
    public static final Icon ICON_SET_BREAKPOINT = new GIcon("icon.debugger.breakpoint.set");
    public static final Icon ICON_CLEAR_BREAKPOINT = new GIcon("icon.debugger.breakpoint.clear");
    public static final Icon ICON_ENABLE_BREAKPOINT = new GIcon("icon.debugger.breakpoint.enable");
    public static final Icon ICON_ENABLE_ALL_BREAKPOINTS = new GIcon("icon.debugger.breakpoint.enable.all");
    public static final Icon ICON_DISABLE_BREAKPOINT = new GIcon("icon.debugger.breakpoint.disable");
    public static final Icon ICON_DISABLE_ALL_BREAKPOINTS = new GIcon("icon.debugger.breakpoint.disable.all");
    public static final Icon ICON_CLEAR_ALL_BREAKPOINTS = new GIcon("icon.debugger.breakpoint.clear.all");
    public static final Icon ICON_MAKE_BREAKPOINTS_EFFECTIVE = new GIcon("icon.debugger.breakpoint.make.effective");
    public static final Icon ICON_LISTING = new GIcon("icon.debugger.provider.listing");
    public static final Icon ICON_MEMORY_BYTES = new GIcon("icon.debugger.provider.memory.bytes");
    public static final Icon ICON_CONSOLE = new GIcon("icon.debugger.provider.console");
    public static final Icon ICON_REGISTERS = new GIcon("icon.debugger.provider.registers");
    public static final Icon ICON_STACK = new GIcon("icon.debugger.provider.stack");
    public static final Icon ICON_BREAKPOINTS = new GIcon("icon.debugger.provider.breakpoints");
    public static final Icon ICON_MODULES = new GIcon("icon.debugger.provider.modules");
    public static final Icon ICON_MAPPINGS = ICON_PROGRAM;
    public static final Icon ICON_PCODE = new GIcon("icon.debugger.provider.pcode");
    public static final Icon ICON_REGIONS = new GIcon("icon.debugger.provider.regions");
    public static final Icon ICON_TIME = new GIcon("icon.debugger.provider.time");
    public static final Icon ICON_OBJECTS = new GIcon("icon.debugger.provider.objects");
    public static final Icon ICON_SAVE = new GIcon("icon.debugger.save");
    public static final Icon ICON_CLOSE = new GIcon("icon.debugger.close");
    public static final Icon ICON_ADD = new GIcon("icon.debugger.add");
    public static final Icon ICON_DELETE = new GIcon("icon.debugger.delete");
    public static final Icon ICON_CLEAR = new GIcon("icon.debugger.clear");
    public static final Icon ICON_REFRESH = new GIcon("icon.debugger.refresh");
    public static final Icon ICON_FILTER = new GIcon("icon.debugger.filter");
    public static final Icon ICON_SELECT_ROWS = new GIcon("icon.debugger.select.rows");
    public static final Icon ICON_AUTOREAD = new GIcon("icon.debugger.autoread");
    public static final Icon ICON_OBJECT_POPULATED = new GIcon("icon.debugger.object.populated");
    public static final Icon ICON_OBJECT_UNPOPULATED = new GIcon("icon.debugger.object.unpopulated");
    public static final Icon ICON_REFRESH_MEMORY = new GIcon("icon.debugger.refresh.memory");
    public static final Icon ICON_RENAME_SNAPSHOT = new GIcon("icon.debugger.rename.snapshot");
    public static final Icon ICON_MAP_IDENTICALLY = new GIcon("icon.debugger.map.identically");
    public static final Icon ICON_MAP_MODULES = new GIcon("icon.debugger.map.modules");
    public static final Icon ICON_MAP_SECTIONS = new GIcon("icon.debugger.map.sections");
    public static final Icon ICON_MAP_REGIONS = new GIcon("icon.debugger.map.regions");
    public static final Icon ICON_BLOCK = new GIcon("icon.debugger.block");
    public static final Icon ICON_SELECT_ADDRESSES = new GIcon("icon.debugger.select.addresses");
    public static final Icon ICON_DATA_TYPES = new GIcon("icon.debugger.data.types");
    public static final Icon ICON_CAPTURE_SYMBOLS = new GIcon("icon.debugger.capture.symbols");
    public static final Icon ICON_LOG_FATAL = new GIcon("icon.debugger.log.fatal");
    public static final Icon ICON_LOG_ERROR = new GIcon("icon.debugger.log.error");
    public static final Icon ICON_LOG_WARN = new GIcon("icon.debugger.log.warn");
    public static final Icon ICON_SYNC = new GIcon("icon.debugger.sync");
    public static final Icon ICON_VISIBILITY = new GIcon("icon.debugger.visibility");
    public static final Icon ICON_PIN = new GIcon("icon.debugger.pin");
    public static final Icon ICON_IMPORT = new GIcon("icon.debugger.import");
    public static final Icon ICON_BLANK = new GIcon("icon.debugger.blank");
    public static final Icon ICON_PACKAGE = new GIcon("icon.debugger.package");
    public static final Icon ICON_EMULATE = new GIcon("icon.debugger.emulate");
    public static final Icon ICON_CONFIG = new GIcon("icon.debugger.config");
    public static final Icon ICON_TOGGLE = new GIcon("icon.debugger.toggle");
    public static final Icon ICON_DIFF = new GIcon("icon.debugger.diff");
    public static final Icon ICON_DIFF_PREV = new GIcon("icon.debugger.diff.previous");
    public static final Icon ICON_DIFF_NEXT = new GIcon("icon.debugger.diff.next");
    public static final HelpLocation HELP_PACKAGE = new HelpLocation("Debugger", "package");
    public static final String HELP_ANCHOR_PLUGIN = "plugin";
    public static final String TITLE_PROVIDER_BREAKPOINTS = "Breakpoints";
    public static final Icon ICON_PROVIDER_BREAKPOINTS = ICON_BREAKPOINTS;
    public static final HelpLocation HELP_PROVIDER_BREAKPOINTS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerBreakpointsPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_CONSOLE = "Debug Console";
    public static final Icon ICON_PROVIDER_CONSOLE = ICON_CONSOLE;
    public static final HelpLocation HELP_PROVIDER_CONSOLE = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerConsolePlugin.class), "plugin");
    public static final String TITLE_PROVIDER_LISTING = "Dynamic";
    public static final Icon ICON_PROVIDER_LISTING = ICON_LISTING;
    public static final HelpLocation HELP_PROVIDER_LISTING = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerListingPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_MAPPINGS = "Static Mappings";
    public static final Icon ICON_PROVIDER_MAPPINGS = ICON_MAPPINGS;
    public static final HelpLocation HELP_PROVIDER_MAPPINGS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerStaticMappingPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_MEMORY_BYTES = "Memory";
    public static final Icon ICON_PROVIDER_MEMORY_BYTES = ICON_MEMORY_BYTES;
    public static final HelpLocation HELP_PROVIDER_MEMORY_BYTES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerMemoryBytesPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_MODULES = "Modules";
    public static final Icon ICON_PROVIDER_MODULES = ICON_MODULES;
    public static final HelpLocation HELP_PROVIDER_MODULES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerModulesPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_PCODE = "Pcode Stepper";
    public static final Icon ICON_PROVIDER_PCODE = ICON_PCODE;
    public static final HelpLocation HELP_PROVIDER_PCODE = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerPcodeStepperPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_REGIONS = "Regions";
    public static final Icon ICON_PROVIDER_REGIONS = ICON_REGIONS;
    public static final HelpLocation HELP_PROVIDER_REGIONS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerRegionsPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_REGISTERS = "Registers";
    public static final Icon ICON_PROVIDER_REGISTERS = ICON_REGISTERS;
    public static final HelpLocation HELP_PROVIDER_REGISTERS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerRegistersPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_TARGETS = "Debugger Targets";
    public static final Icon ICON_PROVIDER_TARGETS = ICON_CONNECTION;
    public static final HelpLocation HELP_PROVIDER_TARGETS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerTargetsPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_STACK = "Stack";
    public static final Icon ICON_PROVIDER_STACK = ICON_STACK;
    public static final HelpLocation HELP_PROVIDER_STACK = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerStackPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_THREADS = "Threads";
    public static final Icon ICON_PROVIDER_THREADS = ICON_DEBUGGER;
    public static final HelpLocation HELP_PROVIDER_THREADS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerThreadsPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_TIME = "Time";
    public static final Icon ICON_PROVIDER_TIME = ICON_TIME;
    public static final HelpLocation HELP_PROVIDER_TIME = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerTimePlugin.class), "plugin");
    public static final String TITLE_PROVIDER_OBJECTS = "Objects";
    public static final Icon ICON_PROVIDER_OBJECTS = new GIcon("icon.debugger.provider.objects");
    public static final HelpLocation HELP_PROVIDER_OBJECTS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerObjectsPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_MODEL = "Model";
    public static final Icon ICON_PROVIDER_MODEL = new GIcon("icon.debugger.provider.model");
    public static final HelpLocation HELP_PROVIDER_MODEL = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerModelPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_WATCHES = "Watches";
    public static final Icon ICON_PROVIDER_WATCHES = ICON_AUTOREAD;
    public static final HelpLocation HELP_PROVIDER_WATCHES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerWatchesPlugin.class), "plugin");
    public static final String TITLE_PROVIDER_INTERPRETER = "Interpreter";
    public static final String BOOKMARK_CATEGORY_MEMORY_READ_ERROR = "Debugger Memory Read Error";
    public static final GColor COLOR_BACKGROUND_STALE = new GColor("color.bg.debugger.plugin.resources.stale");
    public static final Color COLOR_BACKGROUND_ERROR = new GColor("color.bg.debugger.plugin.resources.error");
    public static final int PRIORITY_REGISTER_MARKER = 10;
    public static final Color COLOR_REGISTER_MARKERS = new GColor("color.debugger.plugin.resources.register.marker");
    public static final Icon ICON_REGISTER_MARKER = new GIcon("icon.debugger.marker.register");
    public static final Icon ICON_EVENT_MARKER = new GIcon("icon.debugger.marker.event");
    public static final Color COLOR_VALUE_CHANGED = new GColor("color.debugger.plugin.resources.value.changed");
    public static final Color COLOR_VALUE_CHANGED_SEL = new GColor("color.debugger.plugin.resources.value.changed.selected");
    public static final Icon ICON_UNIQUE_REF_READ = new GIcon("icon.debugger.unique.ref.read");
    public static final Icon ICON_UNIQUE_REF_WRITE = new GIcon("icon.debugger.unique.ref.write");
    public static final Icon ICON_UNIQUE_REF_RW = new MultiIcon(ICON_UNIQUE_REF_READ, new Icon[]{ICON_UNIQUE_REF_WRITE});
    public static final String OPTION_NAME_COLORS_ENABLED_BREAKPOINT_COLORING_BACKGROUND = "Colors.Enabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_ENABLED_BREAKPOINT_COLORING_BACKGROUND = true;
    public static final String OPTION_NAME_COLORS_DISABLED_BREAKPOINT_COLORING_BACKGROUND = "Colors.Disabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_DISABLED_BREAKPOINT_COLORING_BACKGROUND = false;
    public static final String OPTION_NAME_COLORS_INEFF_EN_BREAKPOINT_COLORING_BACKGROUND = "Colors.Ineffective Enabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_INEFF_EN_BREAKPOINT_COLORING_BACKGROUND = true;
    public static final String OPTION_NAME_COLORS_INEFF_DIS_BREAKPOINT_COLORING_BACKGROUND = "Colors.Ineffective Disabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_INEFF_DIS_BREAKPOINT_COLORING_BACKGROUND = false;
    public static final String OPTION_NAME_LOG_BUFFER_LIMIT = "Log Buffer Size";
    public static final int DEFAULT_LOG_BUFFER_LIMIT = 20;
    public static final String GROUP_GENERAL = "Dbg1. General";
    public static final String GROUP_CONNECTION = "Dbg2. Connection";
    public static final String GROUP_VIEWS = "Dbg3. Views";
    public static final String GROUP_TRANSIENT_VIEWS = "Dbg3a. Transient Views";
    public static final String GROUP_CONTROL = "Dbg4. Control";
    public static final String GROUP_TARGET = "Dbg5. Target";
    public static final String GROUP_BREAKPOINTS = "Dbg6. Breakpoints";
    public static final String GROUP_TRACE = "Dbg7. Trace";
    public static final String GROUP_TRACE_TOGGLES = "Dbg7.a. Trace Toggles";
    public static final String GROUP_TRACE_CLOSE = "Dbg7.b. Trace Close";
    public static final String GROUP_MAINTENANCE = "Dbg8. Maintenance";
    public static final String GROUP_MAPPING = "Dbg9. Map Modules/Sections";
    public static final String GROUP_WATCHES = "DbgA. Watches";
    public static final String GROUP_DIFF_NAV = "DiffNavigate";
    public static final String NAME_MAP_IDENTICALLY = "Map Identically";
    public static final String DESCRIPTION_MAP_IDENTICALLY = "Map the current trace to the current program using identical addresses";
    public static final String NAME_MAP_MANUALLY = "Map Manually";
    public static final String DESCRIPTION_MAP_MANUALLY = "Map the current trace to various programs manually";
    public static final String NAME_MAP_MODULES = "Map Modules";
    public static final String DESCRIPTION_MAP_MODULES = "Map selected modules to program images";
    public static final String NAME_PREFIX_MAP_MODULE_TO = "Map Module to ";
    public static final String DESCRIPTION_MAP_MODULE_TO = "Map the selected module to the current program";
    public static final String NAME_MAP_SECTIONS = "Map Sections";
    public static final String DESCRIPTION_MAP_SECTIONS = "Map selected sections to program memory blocks";
    public static final String NAME_PREFIX_MAP_SECTION_TO = "Map Section to ";
    public static final String DESCRIPTION_MAP_SECTION_TO = "Map the selected section to the current program";
    public static final String NAME_PREFIX_MAP_SECTIONS_TO = "Map Sections to ";
    public static final String DESCRIPTION_MAP_SECTIONS_TO = "Map the selected module sections to the current program";
    public static final String NAME_MAP_REGIONS = "Map Regions";
    public static final String DESCRIPTION_MAP_REGIONS = "Map selected regions to program memory blocks";
    public static final String NAME_PREFIX_MAP_REGION_TO = "Map Region to ";
    public static final String DESCRIPTION_MAP_REGION_TO = "Map the selected region to the current program";
    public static final String NAME_PREFIX_MAP_REGIONS_TO = "Map Regions to ";
    public static final String DESCRIPTION_MAP_REGIONS_TO = "Map the selected (module) regions to the current program";
    public static final String NAME_CHOOSE_PLATFORM = "Choose Platform";
    public static final String DESCRIPTION_CHOOSE_PLATFORM = "Choose a platform to use with the current trace";
    public static final String NAME_CHOOSE_MORE_PLATFORMS = "Choose More Platforms";
    public static final String TITLE_CHOOSE_MORE_PLATFORMS = "More...";
    public static final String DESCRIPTION_CHOOSE_MORE_PLATFORMS = "Choose from more platforms to use with the current trace";
    public static final String NAME_CLEAR_REGISTER_TYPE = "Clear Register Type";
    public static final String DESCRIPTION_CLEAR_REGISTER_TYPE = "Clear the register's data type";
    public static final String NAME_REGISTER_TYPE_SETTINGS = "Register Type Settings";
    public static final String DESCRIPTION_REGISTER_TYPE_SETTINGS = "Set the register's data type settings";
    public static final String NAME_WATCH_TYPE_SETTINGS = "Watch Type Settings";
    public static final String DESCRIPTION_WATCH_TYPE_SETTINGS = "Set the watch's data type settings";

    public static void tableRowActivationAction(GTable table, final Runnable runnable) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                runnable.run();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
                    runnable.run();
                }
            }
        });
    }

    public static <T> Function<Throwable, T> showError(Component parent, String message) {
        return e -> {
            Throwable t = AsyncUtils.unwrapThrowable((Throwable)e);
            if (t instanceof CancelledException || t instanceof CancellationException) {
                Msg.error((Object)parent, (Object)("Cancelled: " + message));
            } else {
                Msg.showError((Object)parent, (Component)parent, (String)OPTIONS_CATEGORY_DEBUGGER, (Object)message, (Throwable)e);
            }
            return null;
        };
    }

    public static <V, R> void setSelectedRows(Set<V> sel, Function<V, R> rowMapper, GTable table, RowObjectTableModel<R> model, GTableFilterPanel<R> filterPanel) {
        table.clearSelection();
        for (V v : sel) {
            R row = rowMapper.apply(v);
            if (row == null) continue;
            int modelRow = model.getRowIndex(row);
            int viewRow = filterPanel.getViewRow(modelRow);
            table.getSelectionModel().addSelectionInterval(viewRow, viewRow);
        }
        table.scrollToSelectedRow();
    }

    public static <V, R> void setSelectedRows(Set<V> sel, Function<R, V> getter, GTable table, GTableFilterPanel<R> filterPanel) {
        List data = filterPanel.getTableFilterModel().getModelData();
        for (int i = 0; i < data.size(); ++i) {
            if (!sel.contains(getter.apply(data.get(i)))) continue;
            table.getSelectionModel().addSelectionInterval(i, i);
        }
        table.scrollToSelectedRow();
    }

    public static class ToToggleSelectionListener
    implements DebuggerTraceManagerService.BooleanChangeAdapter {
        private final ToggleDockingAction action;

        public ToToggleSelectionListener(ToggleDockingAction action) {
            this.action = action;
        }

        public void changed(Boolean value) {
            if (this.action.isSelected() == value.booleanValue()) {
                return;
            }
            this.action.setSelected(value.booleanValue());
        }
    }

    public static abstract class AbstractDebuggerModelNode
    extends GTreeNode {
        public Icon getIcon(boolean expanded) {
            return ICON_CONNECTION;
        }

        public String getToolTip() {
            return "A connected debugger client";
        }
    }

    public static abstract class AbstractDebuggerConnectionsNode
    extends GTreeNode {
        public String getName() {
            return "Connections";
        }

        public Icon getIcon(boolean expanded) {
            return ICON_DEBUGGER;
        }

        public String getToolTip() {
            return "Established debugger connections";
        }
    }

    public static interface FollowLinkAction {
        public static final String NAME = "Follow Link";
        public static final String DESCRIPTION = "Navigate to the link target";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "follow_link";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ShowMethodsInTreeAction {
        public static final String NAME = "Show Methods in Tree";
        public static final String DESCRIPTION = "Choose whether to display methods in the tree";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_methods";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ShowPrimitivesInTreeAction {
        public static final String NAME = "Show Primitives in Tree";
        public static final String DESCRIPTION = "Choose whether to display primitive values in the tree";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_primitives";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ShowHiddenAction {
        public static final String NAME = "Show Hidden";
        public static final String DESCRIPTION = "Choose whether to display hidden children";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_hidden";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface LimitToCurrentSnapAction {
        public static final String NAME = "Limit to Current Snap";
        public static final String DESCRIPTION = "Choose whether displayed objects must be alive at the current snap";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_TIME;
        public static final String HELP_ANCHOR = "limit_to_current_snap";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface NextDifferenceAction {
        public static final String NAME = "Next Difference";
        public static final String DESCRIPTION = "Go to the next highlighted difference";
        public static final String GROUP = "DiffNavigate";
        public static final Icon ICON = ICON_DIFF_NEXT;
        public static final String HELP_ANCHOR = "next_diff";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("DiffNavigate")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface PrevDifferenceAction {
        public static final String NAME = "Previous Difference";
        public static final String DESCRIPTION = "Go to the previous highlighted difference";
        public static final String GROUP = "DiffNavigate";
        public static final Icon ICON = ICON_DIFF_PREV;
        public static final String HELP_ANCHOR = "prev_diff";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("DiffNavigate")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CompareTimesAction {
        public static final String NAME = "Compare";
        public static final String DESCRIPTION = "Compare this point in time to another";
        public static final String GROUP = "zzz";
        public static final Icon ICON = ICON_DIFF;
        public static final String HELP_ANCHOR = "compare";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface HideScratchSnapshotsAction {
        public static final String NAME = "Hide Scratch";
        public static final String DESCRIPTION = "Hide negative snaps, typically used as emulation scratch space";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "hide_scratch";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg1. General")).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface WatchAction {
        public static final String NAME = "Watch";
        public static final String DESCRIPTION = "Watch the selected item";
        public static final String GROUP = "DbgA. Watches";
        public static final Icon ICON = ICON_PROVIDER_WATCHES;
        public static final String HELP_ANCHOR = "watch";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup("DbgA. Watches")).popupMenuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectWatchReadsAction {
        public static final String NAME = "Select Reads";
        public static final String DESCRIPTION = "Select every memory range read evaluating this watch";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_REGIONS;
        public static final String HELP_ANCHOR = "select_reads";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectWatchRangeAction {
        public static final String NAME = "Select Range";
        public static final String DESCRIPTION = "For memory watches, select the range comprising the value";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_SELECT_ADDRESSES;
        public static final String HELP_ANCHOR = "select_addresses";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ApplyDataTypeAction {
        public static final String NAME = "Apply Data to Listing ";
        public static final String DESCRIPTION = "Apply the selected data type at the address of this value in the listing";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_DATA_TYPES;
        public static final String HELP_ANCHOR = "apply_data_type";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CloseDeadTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  Dead Traces";
        public static final String DESCRIPTION = "Close all traces not being recorded";
        public static final String HELP_ANCHOR = "close_dead_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseDeadTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseDeadTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseOtherTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  Other Traces";
        public static final String DESCRIPTION = "Close all traces except the current one";
        public static final String HELP_ANCHOR = "close_other_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseOtherTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseOtherTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseAllTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  All Traces";
        public static final String DESCRIPTION = "Close all traces";
        public static final String HELP_ANCHOR = "close_all_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseAllTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseAllTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseTraceAction {
        public static final String NAME_PREFIX = "Close ";
        public static final String DESCRIPTION = "Close the current or selected trace";
        public static final String GROUP = "Dbg7.b. Trace Close";
        public static final String SUB_GROUP = "a";
        public static final Icon ICON = ICON_CLOSE;
        public static final String HELP_ANCHOR = "close_trace";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseTraceAction.builderCommon(owner).menuGroup("Dbg7.b. Trace Close", SUB_GROUP)).menuIcon(ICON)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, "Close ..."});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseTraceAction.builderCommon(owner).popupMenuGroup("Dbg7.b. Trace Close", SUB_GROUP)).popupMenuIcon(ICON)).popupMenuPath(new String[]{"Close ..."});
        }
    }

    public static interface OpenTraceAction {
        public static final String NAME = "Open Trace";
        public static final String DESCRIPTION = "Open a trace from the project";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = ICON_TRACE;
        public static final String HELP_ANCHOR = "open_trace";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg7. Trace")).menuIcon(ICON)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CloseOnTerminateAction {
        public static final String NAME = "Close Traces Upon Termination";
        public static final String DESCRIPTION = "Close any live trace whose recording terminates";
        public static final String GROUP = "Dbg7.a. Trace Toggles";
        public static final Icon ICON = ICON_CLOSE;
        public static final String HELP_ANCHOR = "auto_close_terminated";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).menuGroup("Dbg7.a. Trace Toggles")).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SaveByDefaultAction {
        public static final String NAME = "Save Traces By Default";
        public static final String DESCRIPTION = "Automatically save traces to the project";
        public static final String GROUP = "Dbg7.a. Trace Toggles";
        public static final Icon ICON = ICON_SAVE;
        public static final String HELP_ANCHOR = "save_by_default";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).menuGroup("Dbg7.a. Trace Toggles")).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SynchronizeTargetAction {
        public static final String NAME = "Synchronize Target Activation";
        public static final String DESCRIPTION = "Synchronize trace activation with debugger focus/select";
        public static final Icon ICON = ICON_SYNC;
        public static final String HELP_ANCHOR = "sync_target";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface RenameSnapshotAction {
        public static final String NAME = "Rename Current Snapshot";
        public static final String DESCRIPTION = "Modify the description of the snapshot (event) in the current view";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = ICON_RENAME_SNAPSHOT;
        public static final String HELP_ANCHOR = "rename_snapshot";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).menuGroup("Dbg7. Trace", "zzz")).keyBinding("CTRL SHIFT N")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulateSkipPcodeForwardAction {
        public static final String NAME = "Emulate Trace Skip P-code Forward";
        public static final String DESCRIPTION = "Emulate the recording forward by skipping one p-code op";
        public static final Icon ICON = ICON_SKIP_OVER;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "4";
        public static final String HELP_ANCHOR = "emu_trace_skip_pcode_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulatePcodeForwardAction {
        public static final String NAME = "Emulate Trace p-code Forward";
        public static final String DESCRIPTION = "Emulate the recording forward one p-code tick";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "3";
        public static final String HELP_ANCHOR = "emu_trace_pcode_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulatePcodeBackwardAction {
        public static final String NAME = "Emulate Trace p-code Backward";
        public static final String DESCRIPTION = "Navigate the recording backward one p-code tick";
        public static final Icon ICON = ICON_STEP_BACK;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "2";
        public static final String HELP_ANCHOR = "emu_trace_pcode_backward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulateSkipTickForwardAction {
        public static final String NAME = "Emulate Trace Skip Tick Forward";
        public static final String DESCRIPTION = "Emulate the recording forward by skipping one instruction";
        public static final Icon ICON = ICON_SKIP_OVER;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "4";
        public static final String HELP_ANCHOR = "emu_trace_skip_tick_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulateTickForwardAction {
        public static final String NAME = "Emulate Trace Tick Forward";
        public static final String DESCRIPTION = "Emulate the recording forward one instruction";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "3";
        public static final String HELP_ANCHOR = "emu_trace_tick_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulateTickBackwardAction {
        public static final String NAME = "Emulate Trace Tick Backward";
        public static final String DESCRIPTION = "Emulate the recording backward one tick";
        public static final Icon ICON = ICON_STEP_BACK;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "2";
        public static final String HELP_ANCHOR = "emu_trace_tick_backward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface StepSnapForwardAction {
        public static final String NAME = "Step Trace Snap Forward";
        public static final String DESCRIPTION = "Navigate the recording forward one snap";
        public static final Icon ICON = ICON_SNAP_FORWARD;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "5";
        public static final String HELP_ANCHOR = "step_trace_snap_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface StepSnapBackwardAction {
        public static final String NAME = "Step Trace Snap Backward";
        public static final String DESCRIPTION = "Navigate the recording backward one snap";
        public static final Icon ICON = ICON_SNAP_BACKWARD;
        public static final String GROUP = "Dbg4. Control";
        public static final String ORDER = "1";
        public static final String HELP_ANCHOR = "step_trace_snap_backward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface NewMemoryAction {
        public static final String NAME = "New Memory View";
        public static final String DESCRIPTION = "Open a new memory bytes view";
        public static final String GROUP = "Dbg3a. Transient Views";
        public static final Icon ICON = ICON_MEMORY_BYTES;
        public static final String HELP_ANCHOR = "new_memory";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg3a. Transient Views")).menuIcon(ICON)).menuPath(new String[]{"Window", DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractNewListingAction
    extends DockingAction {
        public static final String NAME = "New Dynamic Listing";
        public static final Icon ICON = ICON_LISTING;
        public static final String HELP_ANCHOR = "new_listing";

        public AbstractNewListingAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Open a new dynamic disassembly listing");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractImportFromFileSystemAction
    extends DockingAction {
        public static final String NAME = "Import From File System";
        public static final String HELP_ANCHOR = "import_from_fs";

        public AbstractImportFromFileSystemAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Import and map the selected module by path from the local file system");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSelectAddressesAction
    extends DockingAction {
        public static final String NAME = "Select Addresses";
        public static final Icon ICON = ICON_SELECT_ADDRESSES;
        public static final String HELP_ANCHOR = "select_addresses";

        public AbstractSelectAddressesAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractToggleAction
    extends DockingAction {
        public static final String NAME = "Toggle";
        public static final Icon ICON = ICON_TOGGLE;
        public static final String HELP_ANCHOR = "toggle_option";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractToggleAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable or disable an option");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractMakeBreakpointsEffectiveAction
    extends DockingAction {
        public static final String NAME = "Make Breakpoints Effective";
        public static final Icon ICON = ICON_MAKE_BREAKPOINTS_EFFECTIVE;
        public static final String HELP_ANCHOR = "make_breakpoints_effective";

        public AbstractMakeBreakpointsEffectiveAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Place enabled but ineffective breakpoints where possible");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Clear All Breakpoints";
        public static final Icon ICON = ICON_CLEAR_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "clear_all_breakpoints";

        public AbstractClearAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Clear";
        public static final Icon ICON = ICON_CLEAR_BREAKPOINT;
        public static final String HELP_ANCHOR = "clear_breakpoints";

        public AbstractClearSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearBreakpointAction
    extends DockingAction {
        public static final String NAME = "Clear Breakpoint";
        public static final Icon ICON = ICON_CLEAR_BREAKPOINT;
        public static final String HELP_ANCHOR = "clear_breakpoint";

        public AbstractClearBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Disable All Breakpoints";
        public static final Icon ICON = ICON_DISABLE_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "disable_all_breakpoints";

        public AbstractDisableAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Disable";
        public static final Icon ICON = ICON_DISABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "disable_breakpoints";

        public AbstractDisableSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableBreakpointAction
    extends DockingAction {
        public static final String NAME = "Disable Breakpoint";
        public static final Icon ICON = ICON_DISABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "disable_breakpoint";

        public AbstractDisableBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Enable All Breakpoints";
        public static final Icon ICON = ICON_ENABLE_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "enable_all_breakpoints";

        public AbstractEnableAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Enable";
        public static final Icon ICON = ICON_ENABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "enable_breakpoints";

        public AbstractEnableSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enabled the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableBreakpointAction
    extends DockingAction {
        public static final String NAME = "Enable Breakpoint";
        public static final Icon ICON = ICON_ENABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "enable_breakpoint";

        public AbstractEnableBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSetBreakpointAction
    extends DockingAction {
        public static final String NAME = "Set Breakpoint";
        public static final Icon ICON = ICON_SET_BREAKPOINT;
        public static final String HELP_ANCHOR = "set_breakpoint";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractSetBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Trap execution");
            this.setHelpLocation(AbstractSetBreakpointAction.help(owner));
        }
    }

    public static interface OpenProgramAction {
        public static final String NAME = "Open Program";
        public static final Icon ICON = ICON_PROGRAM;
        public static final String DESCRIPTION = "Open the program";
        public static final String HELP_ANCHOR = "open_program";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoNewProgramAction
    extends CopyIntoProgramAction {
        public static final String NAME = String.format("Copy Into %s Program", "New");
        public static final String DESCRIPTION = String.format("Copy the current selection into %s program", "a new");
        public static final String HELP_ANCHOR = "copy_into_new";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(DebuggerResources.GROUP_MAINTENANCE)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoCurrentProgramAction
    extends CopyIntoProgramAction {
        public static final String NAME = String.format("Copy Into %s Program", "Current");
        public static final String DESCRIPTION = String.format("Copy the current selection into %s program", "the current");
        public static final String HELP_ANCHOR = "copy_into_current";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(DebuggerResources.GROUP_MAINTENANCE)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoProgramAction {
        public static final String NAME_PAT = "Copy Into %s Program";
        public static final String DESC_PAT = "Copy the current selection into %s program";
        public static final String GROUP = "Dbg8. Maintenance";
    }

    public static interface ExportTraceViewAction {
        public static final String NAME = "Export Trace View";
        public static final String DESCRIPTION = "Export the current view as if a Ghidra program";
        public static final String GROUP = "Dbg8. Maintenance";
        public static final String HELP_ANCHOR = "export_view";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg8. Maintenance")).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectRowsAction {
        public static final String NAME = "Select Rows";
        public static final Icon ICON = ICON_SELECT_ROWS;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "select_rows";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).toolBarIcon(ICON);
        }
    }

    public static interface SelectNoneAction {
        public static final String NAME = "Select None";
        public static final String GROUP = "Select";
        public static final String HELP_ANCHOR = "select_none";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).popupMenuGroup(GROUP)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface FilterAction {
        public static final String NAME = "Filter";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_FILTER;

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON);
        }
    }

    public static interface ClearAction {
        public static final String NAME = "Clear";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_CLEAR;
        public static final String HELP_ANCHOR = "clear";

        public static ActionBuilder builder(Plugin owner) {
            return ClearAction.builder(owner.getName());
        }

        public static ActionBuilder builder(String ownerName) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface RemoveAction {
        public static final String NAME = "Remove";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_DELETE;
        public static final String HELP_ANCHOR = "remove";

        public static ActionBuilder builder(Plugin owner) {
            return RemoveAction.builder(owner.getName());
        }

        public static ActionBuilder builder(String ownerName) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface AddAction {
        public static final String NAME = "Add";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_ADD;
        public static final String HELP_ANCHOR = "add";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface DisassembleAsAction {
        public static final String NAME = "Disassemble as";
        public static final String DESCRIPTION = "Disassemble using an alternative language";
        public static final Icon ICON = new GIcon("icon.debugger.disassemble");
        public static final String HELP_ANCHOR = "disassemble_as";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EnableEditsAction {
        public static final String NAME = "Enable Edits";
        public static final String DESCRIPTION = "Enable editing of recorded or live values";
        public static final String GROUP = "yyyy2";
        public static final Icon ICON = new GIcon("icon.debugger.enable.edits");
        public static final String HELP_ANCHOR = "enable_edits";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CloneWindowAction {
        public static final String NAME = "Clone Window";
        public static final String DESCRIPTION = "Create a disconnected copy of this window";
        public static final String GROUP = "zzzz";
        public static final Icon ICON = new GIcon("icon.provider.clone");
        public static final String HELP_ANCHOR = "clone_window";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectRegistersAction {
        public static final String NAME = "Select Registers";
        public static final String DESCRIPTION = "Select registers to display/modify";
        public static final String GROUP = "aa";
        public static final Icon ICON = new GIcon("icon.debugger.select.registers");
        public static final String HELP_ANCHOR = "select_registers";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractRefreshAction
    extends DockingAction {
        public static final String NAME = "Refresh";
        public static final Icon ICON = ICON_REFRESH;

        public AbstractRefreshAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Refresh the view");
            this.setHelpLocation(new HelpLocation(owner.getName(), "refresh"));
        }
    }

    public static interface AutoReadMemoryAction {
        public static final String NAME = "Auto-Read Target Memory";
        public static final String DESCRIPTION = "Automatically read and record visible memory from the live target";
        public static final String HELP_ANCHOR = "auto_memory";
        public static final String NAME_VIS_RO_ONCE = "Read Visible Memory, RO Once";
        public static final String NAME_VISIBLE = "Read Visible Memory";
        public static final String NAME_LOAD_EMU = "Load Emulator from Programs";
        public static final String NAME_NONE = "Do Not Read Memory";
        public static final Icon ICON_VIS_RO_ONCE = ICON_AUTOREAD;
        public static final Icon ICON_VISIBLE = ICON_AUTOREAD;
        public static final Icon ICON_LOAD_EMU = ICON_EMULATE;
        public static final Icon ICON_NONE = ICON_DELETE;

        public static <T> MultiStateActionBuilder<T> builder(Plugin owner) {
            String ownerName = owner.getName();
            return (MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface FollowsCurrentThreadAction {
        public static final String NAME = "Follows Selected Thread";
        public static final String DESCRIPTION = "Register tracking follows selected thread (and contents follow selected trace)";
        public static final String HELP_ANCHOR = "follows_thread";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapMissingModuleAction {
        public static final String NAME = "Map Missing Module";
        public static final String DESCRIPTION = "Map the missing module to an existing import";
        public static final Icon ICON = ICON_MAP_MODULES;
        public static final String HELP_ANCHOR = "map_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ImportMissingModuleAction {
        public static final String NAME = "Import Missing Module";
        public static final String DESCRIPTION = "Import the missing module from disk";
        public static final Icon ICON = ICON_IMPORT;
        public static final String HELP_ANCHOR = "import_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SyncSelectionFromStaticListingAction {
        public static final String NAME = "Sync Selection from Static Listing";
        public static final String DESCRIPTION = "Change this component's selection to synchronize with the static listing's selection";
        public static final String HELP_ANCHOR = "sync_selection_from_static";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SyncSelectionIntoStaticListingAction {
        public static final String NAME = "Sync Selection into Static Listing";
        public static final String DESCRIPTION = "Change the static listing's selection to synchronize with this component's selection";
        public static final String HELP_ANCHOR = "sync_selection_into_static";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface AutoSyncSelectionWithStaticListingAction {
        public static final String NAME = "Auto-Sync Selection with Static Listing";
        public static final String DESCRIPTION = "Automatically synchronize the static and dynamic listings' selections";
        public static final String HELP_ANCHOR = "auto_sync_selection_static";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface AutoSyncCursorWithStaticListingAction {
        public static final String NAME = "Auto-Sync Cursor with Static Listing";
        public static final String DESCRIPTION = "Automatically synchronize the static and dynamic listings' cursors";
        public static final String HELP_ANCHOR = "auto_sync_cursor_static";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface GoToAction {
        public static final String NAME = "Go To";
        public static final String DESCRIPTION = "Seek this listing to an arbitrary expression";
        public static final String HELP_ANCHOR = "go_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("a")).keyBinding(KeyStroke.getKeyStroke(71, 0))).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface TrackLocationAction {
        public static final String NAME = "Track Location";
        public static final String DESCRIPTION = "Follow a location in this view";
        public static final String HELP_ANCHOR = "track_location";
        public static final String NAME_PC = "Track Program Counter";
        public static final String NAME_PC_BY_REGISTER = "Track Program Counter (by Register)";
        public static final String NAME_PC_BY_STACK = "Track Program Counter (by Stack)";
        public static final String NAME_SP = "Track Stack Pointer";
        public static final String NAME_NONE = "Do Not Track";
        public static final String NAME_PREFIX_WATCH = "Track address of watch: ";
        public static final Icon ICON_PC = ICON_REGISTER_MARKER;
        public static final Icon ICON_PC_BY_REGISTER = ICON_REGISTER_MARKER;
        public static final Icon ICON_PC_BY_STACK = ICON_REGISTER_MARKER;
        public static final Icon ICON_SP = ICON_REGISTER_MARKER;
        public static final Icon ICON_NONE = ICON_DELETE;

        public static <T> MultiStateActionBuilder<T> builder(Plugin owner) {
            String ownerName = owner.getName();
            return (MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractRefreshSelectedMemoryAction
    extends DockingAction {
        public static final String NAME = "Read Selected Memory";
        public static final Icon ICON = ICON_REFRESH_MEMORY;
        public static final String HELP_ANCHOR = "read_memory";

        public AbstractRefreshSelectedMemoryAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("(Re-)read and record memory for the selected addresses into the trace database");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractRecordAction
    extends DockingAction {
        public static final String NAME = "Record";
        public static final Icon ICON = ICON_TRACE;

        public AbstractRecordAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Record the process into a trace and open it (live trace)");
            this.setHelpLocation(new HelpLocation(owner.getName(), "record"));
        }
    }

    public static interface ChoosePlatformAction {
        public static final String NAME = "Choose Platform";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String DESCRIPTION = "Manually select the target platform";
        public static final Icon ICON = ICON_PROCESSOR;
        public static final String HELP_ANCHOR = "choose_platform";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Choose Platform", ownerName).description(DESCRIPTION)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, "Choose Platform"})).menuGroup("Dbg9. Map Modules/Sections")).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface InterpreterInterruptAction {
        public static final String NAME = "Interpreter Interrupt";
        public static final String DESCRIPTION = "Send an interrupt through this Interpreter";
        public static final Icon ICON = ICON_INTERRUPT;
        public static final String HELP_ANCHOR = "interrupt";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).keyBinding("CTRL I")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface PinInterpreterAction {
        public static final String NAME = "Pin Interpreter";
        public static final String DESCRIPTION = "Prevent this Interpreter from closing automatically";
        public static final Icon ICON = ICON_PIN;
        public static final String HELP_ANCHOR = "pin";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface DisconnectAllAction {
        public static final String NAME = "Disconnect All";
        public static final String DESCRIPTION = "Close and Debugger Model Connections";
        public static final Icon ICON = ICON_DISCONNECT;
        public static final String HELP_ANCHOR = "disconnect_all";

        public static ActionBuilder builder(Plugin owner, Plugin helpOwner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, owner.getName()).description(DESCRIPTION)).menuIcon(ICON)).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisconnectAction
    extends DockingAction {
        public static final String NAME = "Disconnect";
        public static final Icon ICON = ICON_DISCONNECT;
        public static final String HELP_ANCHOR = "disconnect";

        public AbstractDisconnectAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Close the connection to the debugging agent");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDetachAction
    extends DockingAction {
        public static final String NAME = "Detach";
        public static final Icon ICON = ICON_DETACH;
        public static final String HELP_ANCHOR = "detach";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractDetachAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Detach from the target (this may cause it to resume)");
            this.setHelpLocation(AbstractDetachAction.help(owner));
        }
    }

    public static abstract class AbstractKillAction
    extends DockingAction {
        public static final String NAME = "Kill";
        public static final Icon ICON = ICON_KILL;
        public static final String HELP_ANCHOR = "kill";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractKillAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Kill, i.e., forcibly terminate, the target");
            this.setHelpLocation(AbstractKillAction.help(owner));
        }
    }

    public static abstract class AbstractInterruptAction
    extends DockingAction {
        public static final String NAME = "Interrupt";
        public static final Icon ICON = ICON_INTERRUPT;
        public static final String HELP_ANCHOR = "interrupt";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractInterruptAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Interrupt, i.e., suspend, the target");
            this.setHelpLocation(AbstractInterruptAction.help(owner));
        }
    }

    public static abstract class AbstractStepLastAction
    extends DockingAction {
        public static final String NAME = "Step Last";
        public static final Icon ICON = ICON_STEP_LAST;
        public static final String HELP_ANCHOR = "step_last";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepLastAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Repeat the last stepping action");
            this.setHelpLocation(AbstractStepLastAction.help(owner));
        }
    }

    public static abstract class AbstractStepFinishAction
    extends DockingAction {
        public static final String NAME = "Step Finish";
        public static final Icon ICON = ICON_STEP_FINISH;
        public static final String HELP_ANCHOR = "step_finish";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepFinishAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target out of the current frame");
            this.setHelpLocation(AbstractStepFinishAction.help(owner));
        }
    }

    public static abstract class AbstractStepOverAction
    extends DockingAction {
        public static final String NAME = "Step Over";
        public static final Icon ICON = ICON_STEP_OVER;
        public static final String HELP_ANCHOR = "step_over";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepOverAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target a single instruction, without following calls");
            this.setHelpLocation(AbstractStepOverAction.help(owner));
        }
    }

    public static abstract class AbstractStepIntoAction
    extends DockingAction {
        public static final String NAME = "Step Into";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String HELP_ANCHOR = "step_into";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepIntoAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target a single instruction, descending into calls");
            this.setHelpLocation(AbstractStepIntoAction.help(owner));
        }
    }

    public static abstract class AbstractResumeAction
    extends DockingAction {
        public static final String NAME = "Resume";
        public static final Icon ICON = ICON_RESUME;
        public static final String HELP_ANCHOR = "resume";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractResumeAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Resume, i.e., go or continue execution of, the target");
            this.setHelpLocation(AbstractResumeAction.help(owner));
        }
    }

    public static abstract class AbstractAttachAction
    extends DockingAction {
        public static final String NAME = "Attach";
        public static final Icon ICON = ICON_ATTACH;
        public static final String DESCRIPTION = "Attach to an existing target accessible to the agent";
        public static final String HELP_ANCHOR = "attach";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractAttachAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription(DESCRIPTION);
            this.setHelpLocation(AbstractAttachAction.help(owner));
        }
    }

    public static abstract class AbstractQuickLaunchAction
    extends DockingAction {
        public static final String NAME = "Quick Launch";
        public static final Icon ICON = ICON_DEBUGGER;
        public static final String HELP_ANCHOR = "quick_launch";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractQuickLaunchAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Load a trace in a local or selected connection");
            this.setHelpLocation(AbstractQuickLaunchAction.help(owner));
        }
    }

    public static interface DebugProgramAction {
        public static final String NAME = "Debug Program";
        public static final Icon ICON = ICON_DEBUGGER;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "debug_program";

        public static <T> MultiStateActionBuilder<T> buttonBuilder(Plugin owner, Plugin helpOwner) {
            return (MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, owner.getName()).toolBarIcon(ICON)).toolBarGroup("Dbg1. General")).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }

        public static ActionBuilder menuBuilder(DebuggerProgramLaunchOffer offer, Plugin owner, Plugin helpOwner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), owner.getName()).description(offer.getButtonTitle())).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, offer.getMenuParentTitle(), offer.getMenuTitle()})).menuIcon(offer.getIcon())).menuGroup("Dbg1. General")).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractLaunchAction
    extends DockingAction {
        public static final String NAME = "Launch";
        public static final Icon ICON = ICON_LAUNCH;
        public static final String HELP_ANCHOR = "launch";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractLaunchAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Launch a target");
            this.setHelpLocation(AbstractLaunchAction.help(owner));
        }
    }

    public static abstract class AbstractConsoleAction
    extends DockingAction {
        public static final String NAME = "Console";
        public static final Icon ICON = ICON_CONSOLE;
        public static final String HELP_ANCHOR = "console";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractConsoleAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Issue commands to the debugger's interpreter");
            this.setHelpLocation(AbstractConsoleAction.help(owner));
        }
    }

    public static abstract class AbstractConnectAction
    extends DockingAction {
        public static final String NAME = "Connect";
        public static final Icon ICON = ICON_CONNECTION;
        public static final String HELP_ANCHOR = "connect";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public AbstractConnectAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Create a new connection to a debugging agent");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface SaveTraceAction {
        public static final String NAME_PREFIX = "Save ";
        public static final String DESCRIPTION = "Save the selected trace";
        public static final Icon ICON = ICON_SAVE;
        public static final String GROUP = "Dbg7. Trace";
        public static final String HELP_ANCHOR = "save_trace";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).menuPath(new String[]{DebuggerResources.OPTIONS_CATEGORY_DEBUGGER, "Save ..."})).menuIcon(ICON)).menuGroup("Dbg7. Trace")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractFlushCachesAction
    extends DockingAction {
        public static final String NAME = "Flush Caches";
        public static final String HELP_ANCHOR = "flush_caches";

        public AbstractFlushCachesAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Flush the targets' client-side caches");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }
}

