/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingActionContext;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.HelpLocation;

public abstract class AbstractTraceDisassembleAction
extends DockingAction {
    protected final DebuggerDisassemblerPlugin plugin;

    public AbstractTraceDisassembleAction(DebuggerDisassemblerPlugin plugin, String name) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "disassemble"));
    }

    protected abstract TracePlatform getPlatform(TraceProgramView var1);

    protected abstract LanguageID getAlternativeLanguageID();

    public void actionPerformed(ActionContext context) {
        if (!(context instanceof DebuggerListingActionContext)) {
            return;
        }
        DebuggerListingActionContext lac = (DebuggerListingActionContext)context;
        TraceProgramView view = lac.getProgram();
        Address address = lac.getAddress();
        AddressSpace space = address.getAddressSpace();
        ProgramSelection selection = lac.getSelection();
        Object set = selection != null && !selection.isEmpty() ? selection : view.getAddressFactory().getAddressSet(space.getMinAddress(), space.getMaxAddress());
        TracePlatform platform = this.getPlatform(view);
        LanguageID altLangID = this.getAlternativeLanguageID();
        TraceDisassembleCommand dis = new TraceDisassembleCommand(platform, address, (AddressSetView)set);
        dis.setInitialContext(DebuggerDisassemblerPlugin.deriveAlternativeDefaultContext(platform.getLanguage(), altLangID, platform.mapHostToGuest(address)));
        dis.run(this.plugin.getTool(), (UndoableDomainObject)view);
    }
}

