/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerWithOffsetMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.exception.CancelledException;

public class VirtualFunctionTablePointerTypeApplier
extends MsTypeApplier {
    public VirtualFunctionTablePointerTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    int getOffset(AbstractMsType type) {
        if (type instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType) {
            AbstractVirtualFunctionTablePointerWithOffsetMsType offType = (AbstractVirtualFunctionTablePointerWithOffsetMsType)type;
            return offType.getOffset();
        }
        return 0;
    }

    String getMemberName(AbstractMsType type) {
        return "VFTablePtr" + this.getOffset(type);
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        VoidDataType dataType;
        if (type instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType) {
            AbstractVirtualFunctionTablePointerWithOffsetMsType vftPtrWOffset = (AbstractVirtualFunctionTablePointerWithOffsetMsType)type;
            dataType = this.applyPointer(vftPtrWOffset.getPointerTypeRecordNumber(), fixupContext, breakCycle);
        } else if (type instanceof AbstractVirtualFunctionTablePointerMsType) {
            AbstractVirtualFunctionTablePointerMsType vftPtr = (AbstractVirtualFunctionTablePointerMsType)type;
            dataType = this.applyPointer(vftPtr.getPointerTypeRecordNumber(), fixupContext, breakCycle);
        } else {
            dataType = VoidDataType.dataType;
            this.applicator.appendLogMsg("PDB Warning: Type not handled: " + type.getClass().getSimpleName());
        }
        dataType = this.applicator.resolve((DataType)dataType);
        return dataType;
    }

    private DataType applyPointer(RecordNumber pointerTypeRecordNumber, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        MsTypeApplier rawApplier = this.applicator.getTypeApplier(pointerTypeRecordNumber);
        if (rawApplier instanceof PointerTypeApplier) {
            PointerTypeApplier pointerApplier = (PointerTypeApplier)rawApplier;
            AbstractMsType type = this.applicator.getPdb().getTypeRecord(pointerTypeRecordNumber);
            return pointerApplier.apply(type, fixupContext, breakCycle);
        }
        this.applicator.appendLogMsg("cannot process " + rawApplier.getClass().getSimpleName() + "for " + this.getClass().getSimpleName());
        return null;
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractVirtualFunctionTablePointerMsType) && !(type instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + VirtualFunctionTablePointerTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

