/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeModuleSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeSourceAndLineMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;

public class UdtSourceLineTypeApplier
extends MsTypeApplier {
    public UdtSourceLineTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    int getLineNumber(AbstractMsType type) {
        if (type instanceof UserDefinedTypeSourceAndLineMsType) {
            UserDefinedTypeSourceAndLineMsType udtSLType = (UserDefinedTypeSourceAndLineMsType)type;
            return udtSLType.getLineNumber();
        }
        if (type instanceof UserDefinedTypeModuleSourceAndLineMsType) {
            UserDefinedTypeModuleSourceAndLineMsType udtMSLType = (UserDefinedTypeModuleSourceAndLineMsType)type;
            return udtMSLType.getLineNumber();
        }
        return -1;
    }

    String getSourceFileName(AbstractMsType type) {
        if (type instanceof UserDefinedTypeSourceAndLineMsType) {
            UserDefinedTypeSourceAndLineMsType udtSLType = (UserDefinedTypeSourceAndLineMsType)type;
            return udtSLType.getSourceFileName();
        }
        if (type instanceof UserDefinedTypeModuleSourceAndLineMsType) {
            UserDefinedTypeModuleSourceAndLineMsType udtMSLType = (UserDefinedTypeModuleSourceAndLineMsType)type;
            return udtMSLType.getSourceFileName();
        }
        return null;
    }

    RecordNumber getUdtRecordNumber(AbstractMsType type) {
        if (type instanceof UserDefinedTypeSourceAndLineMsType) {
            UserDefinedTypeSourceAndLineMsType udtSLType = (UserDefinedTypeSourceAndLineMsType)type;
            return udtSLType.getUdtRecordNumber();
        }
        if (type instanceof UserDefinedTypeModuleSourceAndLineMsType) {
            UserDefinedTypeModuleSourceAndLineMsType udtMSLType = (UserDefinedTypeModuleSourceAndLineMsType)type;
            return udtMSLType.getUdtRecordNumber();
        }
        return null;
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        String filename = this.getSourceFileName(type);
        int lineNumber = this.getLineNumber(type);
        RecordNumber udtRecordNumber = this.getUdtRecordNumber(type);
        MsTypeApplier typeApplier = this.applicator.getTypeApplier(udtRecordNumber);
        this.applicator.putRecordNumberByFileName(udtRecordNumber, filename);
        if (type instanceof UserDefinedTypeModuleSourceAndLineMsType) {
            int moduleNumber = ((UserDefinedTypeModuleSourceAndLineMsType)type).getModuleNumber();
            this.applicator.putRecordNumberByModuleNumber(udtRecordNumber, moduleNumber);
        }
        return null;
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof UserDefinedTypeSourceAndLineMsType) && !(type instanceof UserDefinedTypeModuleSourceAndLineMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + UdtSourceLineTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

