/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeExtMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;

public class NestedTypeApplier
extends MsTypeApplier {
    public NestedTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    String getMemberName(AbstractMsType type) {
        if (type instanceof AbstractNestedTypeMsType) {
            AbstractNestedTypeMsType nested = (AbstractNestedTypeMsType)type;
            return nested.getName();
        }
        if (type instanceof AbstractNestedTypeExtMsType) {
            AbstractNestedTypeExtMsType nestedExt = (AbstractNestedTypeExtMsType)type;
            return nestedExt.getName();
        }
        return "";
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        RecordNumber typeRecordNumber;
        if (type instanceof AbstractNestedTypeMsType) {
            AbstractNestedTypeMsType nestedType = (AbstractNestedTypeMsType)type;
            typeRecordNumber = nestedType.getNestedTypeDefinitionRecordNumber();
        } else if (type instanceof AbstractNestedTypeExtMsType) {
            AbstractNestedTypeExtMsType extNestedType = (AbstractNestedTypeExtMsType)type;
            typeRecordNumber = extNestedType.getNestedTypeDefinitionRecordNumber();
        } else {
            throw new PdbException("Unexpected nested type in field list: " + type.getClass().getSimpleName());
        }
        AbstractMsType mType = this.applicator.getPdb().getTypeRecord(typeRecordNumber);
        MsTypeApplier applier = this.applicator.getTypeApplier(typeRecordNumber);
        return applier.apply(mType, fixupContext, breakCycle);
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractNestedTypeMsType) && !(type instanceof AbstractNestedTypeExtMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + NestedTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

