/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.util.exception.CancelledException;

public class MemberFunctionTypeApplier
extends AbstractFunctionTypeApplier {
    public MemberFunctionTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    private MsTypeApplier getThisPointerApplier(AbstractMemberFunctionMsType procType) {
        MsTypeApplier applier = this.applicator.getTypeApplier(procType.getThisPointerRecordNumber());
        return applier;
    }

    @Override
    protected CallingConvention getCallingConvention(AbstractMsType type) {
        return ((AbstractMemberFunctionMsType)type).getCallingConvention();
    }

    @Override
    protected Pointer getThisPointer(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        PrimitiveMsType primitive;
        RecordNumber ptrRecord = ((AbstractMemberFunctionMsType)type).getThisPointerRecordNumber();
        if (ptrRecord == null) {
            return null;
        }
        AbstractMsType mType = this.applicator.getPdb().getTypeRecord(ptrRecord);
        if (mType instanceof PrimitiveMsType && (primitive = (PrimitiveMsType)mType).isNoType()) {
            return null;
        }
        if (mType instanceof AbstractPointerMsType) {
            AbstractPointerMsType msPtr = (AbstractPointerMsType)mType;
            this.predefineClass(msPtr.getUnderlyingRecordNumber());
        }
        this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionThisPointer(mType);
        DataType dt = this.applicator.getProcessedDataType(ptrRecord, fixupContext, breakCycle);
        if (dt instanceof Pointer) {
            Pointer ptr = (Pointer)dt;
            return ptr;
        }
        return null;
    }

    @Override
    protected Composite getContainingComplexApplier(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        RecordNumber containerRecord = ((AbstractMemberFunctionMsType)type).getContainingClassRecordNumber();
        if (containerRecord == null) {
            return null;
        }
        AbstractMsType mType = this.applicator.getPdb().getTypeRecord(containerRecord);
        this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionContainingType(mType);
        DataType dt = this.applicator.getProcessedDataType(containerRecord, fixupContext, breakCycle);
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return composite;
        }
        return null;
    }

    @Override
    protected void processContainingType(AbstractMsType type) {
        RecordNumber containerRecord = ((AbstractMemberFunctionMsType)type).getContainingClassRecordNumber();
        if (containerRecord == null) {
            return;
        }
        this.predefineClass(containerRecord);
        AbstractMsType mType = this.applicator.getPdb().getTypeRecord(containerRecord);
        this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionContainingType(mType);
    }

    private void predefineClass(RecordNumber recordNumber) {
        AbstractMsType type = this.applicator.getPdb().getTypeRecord(recordNumber);
        if (!(type instanceof AbstractCompositeMsType)) {
            return;
        }
        AbstractCompositeMsType msComposite = (AbstractCompositeMsType)type;
        MsTypeApplier applier = this.applicator.getTypeApplier(recordNumber);
        if (!(applier instanceof CompositeTypeApplier)) {
            return;
        }
        CompositeTypeApplier compApplier = (CompositeTypeApplier)applier;
        SymbolPath sp = compApplier.getFixedSymbolPath(msComposite);
        this.applicator.predefineClass(sp);
    }

    @Override
    protected boolean isConstructor(AbstractMsType type) {
        return ((AbstractMemberFunctionMsType)type).isConstructor();
    }

    @Override
    protected RecordNumber getReturnRecordNumber(AbstractMsType type) {
        return ((AbstractMemberFunctionMsType)type).getReturnRecordNumber();
    }

    @Override
    protected RecordNumber getArgListRecordNumber(AbstractMsType type) {
        return ((AbstractMemberFunctionMsType)type).getArgListRecordNumber();
    }
}

