/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractUnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BaseClassTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CppCompositeType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbUniversalMember;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MemberTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NestedTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NoTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.VirtualFunctionTablePointerTypeApplier;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompositeTypeApplier
extends AbstractComplexTypeApplier {
    public CompositeTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    CppCompositeType getClassType(AbstractMsType type) {
        return this.applicator.getClassType(type);
    }

    private ComboType create(AbstractCompositeMsType type) {
        AbstractCompositeMsType defType = this.getDefinitionType(type, AbstractCompositeMsType.class);
        SymbolPath fixedSp = this.getFixedSymbolPath(defType);
        CategoryPath categoryPath = this.applicator.getCategory(fixedSp.getParent());
        return CompositeTypeApplier.createComposite(this.applicator, fixedSp.getName(), defType, categoryPath, fixedSp);
    }

    private static ComboType createComposite(DefaultPdbApplicator myApplicator, String name, AbstractCompositeMsType compositeMsType, CategoryPath categoryPath, SymbolPath fixedSymbolPath) {
        CppCompositeType myClassType;
        StructureDataType myComposite;
        String mangledName = compositeMsType.getMangledName();
        if (compositeMsType instanceof AbstractClassMsType) {
            myApplicator.predefineClass(fixedSymbolPath);
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), 0, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setClass();
        } else if (compositeMsType instanceof AbstractStructureMsType) {
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), 0, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setStruct();
        } else if (compositeMsType instanceof AbstractUnionMsType) {
            myComposite = new UnionDataType(categoryPath, fixedSymbolPath.getName(), myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setUnion();
        } else {
            String message = "Unsupported datatype (" + compositeMsType.getClass().getSimpleName() + "): " + fixedSymbolPath.getPath();
            myApplicator.appendLogMsg(message);
            return null;
        }
        myClassType.setName(name);
        myClassType.setSize(myApplicator.bigIntegerToInt(compositeMsType.getSize()));
        myClassType.setFinal(compositeMsType.getMsProperty().isSealed());
        return new ComboType((Composite)myComposite, myClassType);
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        return this.apply((AbstractCompositeMsType)type, fixupContext, breakCycle);
    }

    private void applyInternal(ComboType combo, AbstractCompositeMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, type.getFieldDescriptorListRecordNumber());
        FieldListTypeApplier.FieldLists lists = fieldListApplier.getFieldLists(type.getFieldDescriptorListRecordNumber());
        if (type instanceof AbstractUnionMsType) {
            this.applyBasic(combo, type, lists, fixupContext, breakCycle);
        } else {
            this.applyCpp(combo, type, lists, fixupContext, breakCycle);
        }
    }

    private void applyBasic(ComboType combo, AbstractCompositeMsType type, FieldListTypeApplier.FieldLists lists, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        Composite composite = combo.dt();
        CppCompositeType classType = combo.ct();
        boolean isClass = type instanceof AbstractClassMsType;
        int size = this.getSizeInt(type);
        CompositeTypeApplier.clearComponents(composite);
        ArrayList<DefaultPdbUniversalMember> myMembers = new ArrayList<DefaultPdbUniversalMember>();
        this.addVftPtrs(composite, classType, lists.vftPtrs(), type, myMembers, fixupContext, breakCycle);
        this.addMembers(composite, classType, lists.nonstaticMembers(), type, myMembers, fixupContext, breakCycle);
        if (!DefaultCompositeMember.applyDataTypeMembers(composite, isClass, size, myMembers, msg -> this.reconstructionWarn((String)msg, this.hasHiddenComponents(lists)), this.applicator.getCancelOnlyWrappingMonitor())) {
            CompositeTypeApplier.clearComponents(composite);
        }
    }

    private void applyCpp(ComboType combo, AbstractCompositeMsType type, FieldListTypeApplier.FieldLists lists, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        Composite composite = combo.dt();
        CppCompositeType classType = combo.ct();
        CompositeTypeApplier.clearComponents(composite);
        ArrayList<DefaultPdbUniversalMember> myMembers = new ArrayList<DefaultPdbUniversalMember>();
        this.addClassTypeBaseClassesNew(composite, classType, lists.bases(), type, fixupContext, breakCycle);
        this.addVftPtrs(composite, classType, lists.vftPtrs(), type, myMembers, fixupContext, breakCycle);
        this.addMembers(composite, classType, lists.nonstaticMembers(), type, myMembers, fixupContext, breakCycle);
        if (!classType.validate()) {
            // empty if block
        }
        classType.createLayout(this.applicator.getPdbApplicatorOptions().getCompositeLayout(), this.applicator.getVbtManager(), this.applicator.getCancelOnlyWrappingMonitor());
    }

    private void reconstructionWarn(String msg, boolean hasHiddenComponents) {
        if (msg.contains("failed to align") && hasHiddenComponents) {
            msg = msg.replaceFirst("PDB", "PDB CLASS");
        }
        Msg.warn((Object)this, (Object)msg);
    }

    BigInteger getSize(AbstractCompositeMsType type) {
        AbstractCompositeMsType definition = this.getDefinitionType(type);
        return definition.getSize();
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    private boolean hasHiddenComponents(FieldListTypeApplier.FieldLists lists) {
        return lists.methods().size() != 0 || lists.bases().size() != 0;
    }

    private void addClassTypeBaseClassesNew(Composite composite, CppCompositeType myClassType, List<AbstractMsType> msBases, AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        AbstractCompositeMsType cType = (AbstractCompositeMsType)type;
        for (AbstractMsType baseType : msBases) {
            MsTypeApplier baseApplier = this.applicator.getTypeApplier(baseType);
            if (!(baseApplier instanceof BaseClassTypeApplier)) {
                this.applicator.appendLogMsg(baseApplier.getClass().getSimpleName() + " seen where BaseClassTypeApplier expected for " + cType.getName());
                continue;
            }
            BaseClassTypeApplier baseTypeApplier = (BaseClassTypeApplier)baseApplier;
            if (baseType instanceof AbstractBaseClassMsType) {
                AbstractBaseClassMsType baseClassType = (AbstractBaseClassMsType)baseType;
                this.applyDirectBaseClass(baseClassType, myClassType, fixupContext);
                continue;
            }
            if (baseType instanceof AbstractVirtualBaseClassMsType) {
                AbstractVirtualBaseClassMsType virtualBaseClassType = (AbstractVirtualBaseClassMsType)baseType;
                this.applyDirectVirtualBaseClass(virtualBaseClassType, myClassType, fixupContext, breakCycle);
                continue;
            }
            if (baseType instanceof AbstractIndirectVirtualBaseClassMsType) {
                AbstractIndirectVirtualBaseClassMsType indirectVirtualBaseClassType = (AbstractIndirectVirtualBaseClassMsType)baseType;
                this.applyIndirectVirtualBaseClass(indirectVirtualBaseClassType, myClassType, fixupContext, breakCycle);
                continue;
            }
            throw new AssertException("Unknown base class type: " + baseType.getClass().getSimpleName());
        }
    }

    private void applyDirectBaseClass(AbstractBaseClassMsType base, CppCompositeType myClassType, FixupContext fixupContext) throws PdbException, CancelledException {
        CppCompositeType underlyingClassType = this.getUnderlyingClassType(base.getBaseClassRecordNumber(), fixupContext);
        if (underlyingClassType == null) {
            return;
        }
        ClassFieldMsAttributes atts = base.getAttributes();
        int offset = this.applicator.bigIntegerToInt(base.getOffset());
        myClassType.addDirectBaseClass(underlyingClassType, CompositeTypeApplier.convertAttributes(atts), offset);
    }

    private void applyDirectVirtualBaseClass(AbstractVirtualBaseClassMsType base, CppCompositeType myClassType, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber(), fixupContext);
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber(), fixupContext, breakCycle);
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = this.applicator.bigIntegerToInt(base.getBasePointerOffset());
        int offsetFromVbt = this.applicator.bigIntegerToInt(base.getBaseOffsetFromVbt());
        myClassType.addDirectVirtualBaseClass(underlyingCt, CompositeTypeApplier.convertAttributes(atts), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private void applyIndirectVirtualBaseClass(AbstractIndirectVirtualBaseClassMsType base, CppCompositeType myClassType, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber(), fixupContext);
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber(), fixupContext, breakCycle);
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = this.applicator.bigIntegerToInt(base.getBasePointerOffset());
        int offsetFromVbt = this.applicator.bigIntegerToInt(base.getBaseOffsetFromVbt());
        myClassType.addIndirectVirtualBaseClass(underlyingCt, CompositeTypeApplier.convertAttributes(atts), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private CppCompositeType getUnderlyingClassType(RecordNumber recordNumber, FixupContext fixupContext) throws CancelledException, PdbException {
        AbstractMsType type = this.applicator.getPdb().getTypeRecord(recordNumber);
        if (!(type instanceof AbstractCompositeMsType)) {
            this.applicator.appendLogMsg(type.getClass().getSimpleName() + " seen where Composite Type expected for base class.");
            return null;
        }
        AbstractCompositeMsType comp = (AbstractCompositeMsType)type;
        this.applicator.getProcessedDataType(recordNumber, fixupContext, false);
        MsTypeApplier baseUnderlyingApplier = this.applicator.getTypeApplier(recordNumber);
        if (!(baseUnderlyingApplier instanceof CompositeTypeApplier)) {
            this.applicator.appendLogMsg(baseUnderlyingApplier.getClass().getSimpleName() + " seen where CompositeTypeApplier expected for base class.");
            return null;
        }
        CompositeTypeApplier baseApplier = (CompositeTypeApplier)baseUnderlyingApplier;
        CppCompositeType underlyingClassType = baseApplier.getClassType(type);
        if (underlyingClassType == null) {
            this.applicator.appendLogMsg("Underlying base class type is null.");
        }
        return underlyingClassType;
    }

    private DataType getVirtualBaseTablePointerDataType(RecordNumber recordNumber, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        DataType dt = this.applicator.getProcessedDataType(recordNumber, fixupContext, breakCycle);
        if (dt != null) {
            return dt;
        }
        this.applicator.appendLogMsg("Generating a generic Virtual Base Table Pointer.");
        return new PointerDataType();
    }

    private static CppCompositeType.ClassFieldAttributes convertAttributes(ClassFieldMsAttributes atts) {
        return new CppCompositeType.ClassFieldAttributes(switch (atts.getAccess()) {
            case ClassFieldMsAttributes.Access.PUBLIC -> CppCompositeType.Access.PUBLIC;
            case ClassFieldMsAttributes.Access.PROTECTED -> CppCompositeType.Access.PROTECTED;
            case ClassFieldMsAttributes.Access.PRIVATE -> CppCompositeType.Access.PRIVATE;
            default -> CppCompositeType.Access.BLANK;
        }, switch (atts.getProperty()) {
            case ClassFieldMsAttributes.Property.VIRTUAL -> CppCompositeType.Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.STATIC -> CppCompositeType.Property.STATIC;
            case ClassFieldMsAttributes.Property.FRIEND -> CppCompositeType.Property.FRIEND;
            default -> CppCompositeType.Property.BLANK;
        });
    }

    private void addMembers(Composite composite, CppCompositeType myClassType, List<AbstractMemberMsType> msMembers, AbstractCompositeMsType type, List<DefaultPdbUniversalMember> myMembers, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        for (int index = 0; index < msMembers.size(); ++index) {
            this.applicator.checkCancelled();
            AbstractMemberMsType memberType = msMembers.get(index);
            DefaultPdbUniversalMember member = this.getNonStaticMember(composite, memberType, index, fixupContext, breakCycle);
            DataType dt = member.getDataType().getDataType();
            if (this.applicator.isPlaceholderType(dt)) {
                fixupContext.putFixup(index);
            }
            myMembers.add(member);
            myClassType.addMember(member.getName(), dt, member.isZeroLengthArray(), member.getAttributes(), member.getOffset(), member.getComment());
        }
    }

    private void addVftPtrs(Composite composite, CppCompositeType myClassType, List<AbstractVirtualFunctionTablePointerMsType> msVftPtrs, AbstractCompositeMsType type, List<DefaultPdbUniversalMember> myMembers, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        for (AbstractVirtualFunctionTablePointerMsType vftPtr : msVftPtrs) {
            MsTypeApplier applierIterated = this.applicator.getTypeApplier(vftPtr);
            if (!(applierIterated instanceof VirtualFunctionTablePointerTypeApplier)) continue;
            VirtualFunctionTablePointerTypeApplier vtPtrApplier = (VirtualFunctionTablePointerTypeApplier)applierIterated;
            DefaultPdbUniversalMember member = this.getVftPtrMember(vftPtr, vtPtrApplier, fixupContext, breakCycle);
            myMembers.add(member);
            myClassType.addVirtualFunctionTablePointer(member.getName(), member.getDataType().getDataType(), member.getOffset());
        }
    }

    private void addOthers(Composite composite, CppCompositeType myClassType, List<AbstractMsType> msMembers, AbstractCompositeMsType type, List<DefaultPdbUniversalMember> myMembers, FixupContext fixupContext) throws CancelledException, PdbException {
        for (AbstractMsType typeIterated : msMembers) {
            MsTypeApplier applierIterated = this.applicator.getTypeApplier(typeIterated);
            if (applierIterated instanceof EnumerateTypeApplier) {
                EnumerateTypeApplier enumerateApplier = (EnumerateTypeApplier)applierIterated;
                if (typeIterated instanceof AbstractEnumerateMsType) {
                    AbstractEnumerateMsType enumerateType = (AbstractEnumerateMsType)typeIterated;
                    this.processEnumerate(type, enumerateApplier, enumerateType);
                    continue;
                }
            }
            if (applierIterated instanceof NestedTypeApplier) {
                NestedTypeApplier nestedTypeApplier = (NestedTypeApplier)applierIterated;
                this.processNestedType(type, nestedTypeApplier, typeIterated);
                continue;
            }
            if (applierIterated instanceof NoTypeApplier) {
                if (typeIterated instanceof AbstractStaticMemberMsType) continue;
                this.processNotHandled(composite, applierIterated, typeIterated);
                continue;
            }
            this.processNotHandled(composite, applierIterated, typeIterated);
        }
    }

    private DefaultPdbUniversalMember getNonStaticMember(Composite container, AbstractMemberMsType memberMsType, int ordinal, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        ArrayTypeApplier arrayApplier;
        MsTypeApplier applier = this.applicator.getTypeApplier(memberMsType);
        if (!(applier instanceof MemberTypeApplier)) {
            throw new PdbException("Member applier expected");
        }
        MemberTypeApplier memberApplier = (MemberTypeApplier)applier;
        String memberName = memberMsType.getName();
        int offset = this.applicator.bigIntegerToInt(memberMsType.getOffset());
        ClassFieldMsAttributes memberAttributes = memberMsType.getAttribute();
        memberAttributes.getAccess();
        AbstractMsType fieldType = this.applicator.getPdb().getTypeRecord(memberMsType.getFieldTypeRecordNumber());
        MsTypeApplier fieldApplier = this.applicator.getTypeApplier(fieldType);
        String memberComment = null;
        DataType fieldDataType = this.applicator.getProcessedDataType(memberMsType.getFieldTypeRecordNumber(), fixupContext, breakCycle);
        if (fieldApplier instanceof PointerTypeApplier) {
            PointerTypeApplier ptrApplier = (PointerTypeApplier)fieldApplier;
            AbstractPointerMsType pointerType = (AbstractPointerMsType)fieldType;
            memberComment = ptrApplier.getPointerCommentField(pointerType, fixupContext);
        }
        boolean isZeroLengthArray = fieldDataType instanceof Array && fieldApplier instanceof ArrayTypeApplier && (arrayApplier = (ArrayTypeApplier)fieldApplier).isFlexibleArray(fieldType);
        DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(memberName, fieldDataType, isZeroLengthArray, offset, CompositeTypeApplier.convertAttributes(memberAttributes), memberComment);
        return member;
    }

    private DefaultPdbUniversalMember getVftPtrMember(AbstractVirtualFunctionTablePointerMsType type, VirtualFunctionTablePointerTypeApplier vtPtrApplier, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        String vftPtrMemberName = vtPtrApplier.getMemberName(type);
        int offset = vtPtrApplier.getOffset(type);
        DataType dt = vtPtrApplier.apply(type, fixupContext, breakCycle);
        return new DefaultPdbUniversalMember(vftPtrMemberName, dt, offset);
    }

    private void processEnumerate(AbstractCompositeMsType type, EnumerateTypeApplier applier, AbstractEnumerateMsType enumerateType) {
        String fieldName = enumerateType.getName();
        Numeric numeric = enumerateType.getNumeric();
        this.pdbLogAndInfoMessage(this, "Don't know how to apply EnumerateTypeApplier fieldName " + fieldName + " and value " + numeric + ".");
    }

    private void processNestedType(AbstractCompositeMsType type, NestedTypeApplier nestedTypeApplier, AbstractMsType enumerateType) {
        String memberTypeName = enumerateType.getName();
        if (type.getName().equals(memberTypeName)) {
            // empty if block
        }
    }

    private void processNotHandled(Composite composite, MsTypeApplier applier, AbstractMsType memberType) {
        this.applicator.appendLogMsg(applier.getClass().getSimpleName() + " with contained " + memberType.getClass().getSimpleName() + " unexpected for " + composite.getName());
    }

    DataType fixup(AbstractCompositeMsType type, Map<Integer, DataType> contextMap) throws CancelledException, PdbException {
        DataType dt = this.applicator.getDataType(type);
        if (dt instanceof DataTypeImpl || !(dt instanceof Composite)) {
            throw new PdbException("Can only fixup Composite DB ");
        }
        return null;
    }

    DataType apply(AbstractCompositeMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        Composite composite;
        ComboType combo;
        int typeNumber = type.getRecordNumber().getNumber();
        int mappedNumber = this.applicator.getMappedComplexType(typeNumber);
        DataType existingDt = this.applicator.getDataType(mappedNumber);
        if (existingDt != null) {
            return existingDt;
        }
        AbstractMsType msType = this.applicator.getPdb().getTypeRecord(RecordNumber.typeRecordNumber(mappedNumber));
        if (!(msType instanceof AbstractCompositeMsType)) {
            throw new PdbException("PDB processing error");
        }
        type = (AbstractCompositeMsType)msType;
        CppCompositeType myClassType = this.getClassType(type);
        if (myClassType == null) {
            combo = this.create(type);
            composite = combo.dt();
            myClassType = combo.ct();
            this.applicator.putClassType(type, myClassType);
        } else {
            composite = myClassType.getComposite();
            combo = new ComboType(composite, myClassType);
        }
        this.applyInternal(combo, type, fixupContext, breakCycle);
        composite = (Composite)this.applicator.resolve((DataType)composite);
        this.applicator.putDataType(mappedNumber, (DataType)composite);
        return composite;
    }

    private AbstractCompositeMsType getDefinitionType(AbstractComplexMsType type) {
        return this.getDefinitionType(type, AbstractCompositeMsType.class);
    }

    public void fixUp(FixupContext fixupContext) throws PdbException, CancelledException {
        Integer indexNumber = fixupContext.peekFixupRecord();
        if (indexNumber == null) {
            return;
        }
        AbstractMsType t = this.applicator.getPdb().getTypeRecord(RecordNumber.typeRecordNumber(indexNumber));
        if (!(t instanceof AbstractComplexMsType)) {
            throw new PdbException("error");
        }
        AbstractComplexMsType type = (AbstractComplexMsType)t;
        AbstractCompositeMsType defType = this.getDefinitionType(type);
        DataType dataType = this.applicator.getDataType(indexNumber);
        if (dataType == null) {
            this.applicator.appendLogMsg("Null type for index: " + indexNumber);
            return;
        }
        if (dataType instanceof DataTypeImpl) {
            this.applicator.appendLogMsg("Impl type for index: " + indexNumber);
            return;
        }
        if (!(dataType instanceof Composite)) {
            this.applicator.appendLogMsg("Composite expected type for index: " + indexNumber);
            return;
        }
        Composite compositeDB = (Composite)dataType;
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, defType.getFieldDescriptorListRecordNumber());
        FieldListTypeApplier.FieldLists lists = fieldListApplier.getFieldLists(defType.getFieldDescriptorListRecordNumber());
        List<AbstractMemberMsType> msMembers = lists.nonstaticMembers();
        List<Integer> fixupIndices = fixupContext.getFixups();
        for (int index : fixupIndices) {
            this.applicator.checkCancelled();
            AbstractMemberMsType memberType = msMembers.get(index);
            DefaultPdbUniversalMember member = this.getNonStaticMember(compositeDB, memberType, index, null, false);
            this.replaceComponentDataType(compositeDB, member);
        }
    }

    private void replaceComponentDataType(Composite compositeDB, DefaultPdbUniversalMember member) throws CancelledException, PdbException {
        DataType dt = member.getDataType().getDataType();
        if (this.applicator.isPlaceholderPointer(dt)) {
            throw new PdbException("Placeholder pointer not expected");
        }
        if (!this.recurseReplacement(compositeDB, 0, member)) {
            Msg.warn((Object)this, (Object)("PDB: Unable to replace placeholder component of: " + compositeDB.getName()));
        }
    }

    private boolean recurseReplacement(Composite compositeDB, int baseOffset, DefaultPdbUniversalMember member) throws CancelledException, PdbException {
        DataTypeComponent[] components;
        for (DataTypeComponent component : components = compositeDB.getDefinedComponents()) {
            if (member.getOffset() > baseOffset + component.getEndOffset() || member.getOffset() < baseOffset + component.getOffset()) continue;
            DataType componentDt = component.getDataType();
            if (!this.applicator.isPlaceholderType(componentDt) && componentDt instanceof Composite) {
                Composite nestedComposite = (Composite)componentDt;
                if (!this.recurseReplacement(nestedComposite, baseOffset + component.getOffset(), member)) continue;
                return true;
            }
            if (!this.applicator.isPlaceholderType(componentDt) || !component.getFieldName().equals(member.getName()) || member.getOffset() != baseOffset + component.getOffset()) continue;
            DataType replacementDt = member.getDataType().getDataType();
            int length = replacementDt.getLength();
            if (length != componentDt.getLength()) {
                throw new PdbException("Mismatch component type length on replacement: " + replacementDt.getName());
            }
            int ordinal = component.getOrdinal();
            CompositeTypeApplier.replaceComponent(compositeDB, ordinal, replacementDt);
            return true;
        }
        return false;
    }

    private static void replaceComponent(Composite composite, int ordinal, DataType newType) throws PdbException {
        if (composite instanceof Structure) {
            Structure struct = (Structure)composite;
            DataTypeComponent dtc = struct.getComponent(ordinal);
            struct.replace(ordinal, newType, newType.getLength(), dtc.getFieldName(), dtc.getComment());
        } else if (composite instanceof Union) {
            Union union = (Union)composite;
            DataTypeComponent dtc = union.getComponent(ordinal);
            union.delete(ordinal);
            union.insert(ordinal, newType, newType.getLength(), dtc.getFieldName(), dtc.getComment());
        } else {
            throw new PdbException("Not struct or union: " + composite.getClass().getSimpleName());
        }
    }

    private record ComboType(Composite dt, CppCompositeType ct) {
    }
}

