/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUnknownMsSymbol;

public class UnknownMsSymbol
extends AbstractUnknownMsSymbol {
    private int unknownPdbId = 0;
    private byte[] data;

    public UnknownMsSymbol(AbstractPdb pdb, PdbByteReader reader, int unknownPdbId) {
        super(pdb, reader);
        this.unknownPdbId = unknownPdbId;
        this.data = reader.parseBytesRemaining();
    }

    @Override
    public int getPdbId() {
        return this.unknownPdbId;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void emit(StringBuilder builder) {
        PdbByteReader reader = new PdbByteReader(this.data);
        builder.append(String.format("%s: Bytes:%s", this.getSymbolTypeName(), reader.dumpBytes()));
    }

    @Override
    protected String getSymbolTypeName() {
        return String.format("UNKNOWN_SYMBOL (0X%04X)", this.unknownPdbId);
    }
}

