/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ModuleInformation {
    protected long modulePointer;
    protected SectionContribution sectionContribution;
    protected boolean writtenSinceOpen;
    protected boolean ecSymbolicInformationEnabled;
    protected int bitfield;
    protected int spare;
    protected int indexToTSMList;
    protected int streamNumberDebugInformation;
    protected int sizeLocalSymbolsDebugInformation;
    protected int sizeLineNumberDebugInformation;
    protected int sizeC13StyleLineNumberInformation;
    protected int numFilesContributing;
    protected List<Integer> offsetsArray = new ArrayList<Integer>();
    protected List<String> filenamesArray = new ArrayList<String>();
    protected String moduleName;
    protected String objectFileName;
    protected long nameIndexSourceFile;
    protected long nameIndexCompilerPdbPath;
    protected AbstractPdb pdb;
    private Map<Integer, String> filenameByOffset = new HashMap<Integer, String>();

    public ModuleInformation(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public int getNumFilesContributing() {
        return this.numFilesContributing;
    }

    public List<Integer> getOffsetsArray() {
        return this.offsetsArray;
    }

    public List<String> getFilenamesArray() {
        return this.filenamesArray;
    }

    public int getStreamNumberDebugInformation() {
        return this.streamNumberDebugInformation;
    }

    public int getSizeLocalSymbolsDebugInformation() {
        return this.sizeLocalSymbolsDebugInformation;
    }

    public int getSizeLineNumberDebugInformation() {
        return this.sizeLineNumberDebugInformation;
    }

    public int getSizeC13StyleLineNumberInformation() {
        return this.sizeC13StyleLineNumberInformation;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public SectionContribution getSectionContribution() {
        return this.sectionContribution;
    }

    public String getFilenameByOffset(int offset) {
        return this.filenameByOffset.get(offset);
    }

    protected void deserialize(PdbByteReader reader) throws PdbException {
        this.modulePointer = reader.parseUnsignedIntVal();
        this.sectionContribution.deserialize(reader);
        this.bitfield = reader.parseUnsignedShortVal();
        this.writtenSinceOpen = (this.bitfield & 1) == 1;
        this.bitfield >>= 1;
        this.spare = this.bitfield & 0x7F;
        this.bitfield >>= 1;
        this.indexToTSMList = this.bitfield & 0xFF;
        this.ecSymbolicInformationEnabled = false;
        this.streamNumberDebugInformation = reader.parseUnsignedShortVal();
        this.sizeLocalSymbolsDebugInformation = reader.parseInt();
        this.sizeLineNumberDebugInformation = reader.parseInt();
        this.sizeC13StyleLineNumberInformation = reader.parseInt();
        this.numFilesContributing = reader.parseUnsignedShortVal();
        reader.align4();
        reader.parseBytes(4);
        this.parseAdditionals(reader);
        reader.align4();
    }

    protected abstract void parseAdditionals(PdbByteReader var1) throws PdbException;

    protected abstract String dumpAdditionals();

    protected void addFilenameByOffset(int offset, String filename) {
        this.filenameByOffset.put(offset, filename);
    }

    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModuleInformation-------------------------------------------\n");
        builder.append("modulePointer: ");
        builder.append(this.modulePointer);
        builder.append("\n");
        builder.append(this.sectionContribution.dump());
        builder.append("\nwrittenSinceOpen: ");
        builder.append(this.writtenSinceOpen);
        builder.append("\necSymbolicInformationEnabled: ");
        builder.append(this.ecSymbolicInformationEnabled);
        builder.append("\nspare: ");
        builder.append(this.spare);
        builder.append("\nindexToTSMList: ");
        builder.append(this.indexToTSMList);
        builder.append("\nstreamNumberDebugInformation: ");
        builder.append(this.streamNumberDebugInformation);
        builder.append("\nsizeLocalSymbolsDebugInformation: ");
        builder.append(this.sizeLocalSymbolsDebugInformation);
        builder.append("\nsizeLineNumberDebugInformation: ");
        builder.append(this.sizeLineNumberDebugInformation);
        builder.append("\nsizeC13StyleLineNumberInformation: ");
        builder.append(this.sizeC13StyleLineNumberInformation);
        builder.append("\nnumFilesContributing: ");
        builder.append(this.numFilesContributing);
        builder.append(this.dumpAdditionals());
        builder.append("\nmoduleName: ");
        builder.append(this.moduleName);
        builder.append("\nobjectFileName: ");
        builder.append(this.objectFileName);
        builder.append("\nEnd ModuleInformation---------------------------------------\n");
        return builder.toString();
    }
}

