/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.gadp;

import agent.dbgeng.gadp.DbgEngGadpServer;
import agent.dbgmodel.gadp.impl.DbgModelGadpServerImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AgentWindow;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface DbgModelGadpServer
extends DbgEngGadpServer {
    public static void main(String[] args) throws Exception {
        try {
            new DbgModelRunner().run(args);
        }
        catch (Throwable t) {
            System.err.println(ExceptionUtils.getMessage((Throwable)t));
            System.exit(1);
        }
    }

    public static DbgModelGadpServer newInstance(SocketAddress addr) throws IOException {
        return new DbgModelGadpServerImpl(addr);
    }

    public static class DbgModelRunner
    extends DbgEngGadpServer.DbgEngRunner {
        public void run(String[] args) throws IOException, InterruptedException, ExecutionException {
            this.parseArguments(args);
            try (DbgModelGadpServer server = DbgModelGadpServer.newInstance(this.bindTo);){
                server.startDbgEng(this.dbgengArgs.toArray(new String[0])).exceptionally(e -> {
                    e = AsyncUtils.unwrapThrowable((Throwable)e);
                    Msg.error((Object)((Object)this), (Object)("Error starting dbgeng/GADP: " + e));
                    System.exit(-1);
                    return null;
                });
                new AgentWindow("dbgmodel.dll Agent for Ghidra", server.getLocalAddress());
                while (server.isRunning()) {
                    Thread.sleep(1000L);
                }
            }
        }
    }
}

