/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.Map;

public class SizeRestrictedFilter
implements DatatypeFilter {
    public static final String NAME = "any";
    protected int minSize;
    protected int maxSize;

    public SizeRestrictedFilter() {
        this.minSize = 0;
        this.maxSize = 0;
    }

    public SizeRestrictedFilter(int min, int max) {
        this.minSize = min;
        this.maxSize = max;
        if (this.maxSize == 0 && this.minSize >= 0) {
            this.maxSize = Integer.MAX_VALUE;
        }
    }

    public boolean filterOnSize(DataType dt) {
        if (this.maxSize == 0) {
            return true;
        }
        return dt.getLength() >= this.minSize && dt.getLength() <= this.maxSize;
    }

    @Override
    public DatatypeFilter clone() {
        return new SizeRestrictedFilter(this.minSize, this.maxSize);
    }

    @Override
    public boolean isEquivalent(DatatypeFilter op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        SizeRestrictedFilter otherFilter = (SizeRestrictedFilter)op;
        return this.maxSize == otherFilter.maxSize && this.minSize == otherFilter.minSize;
    }

    @Override
    public boolean filter(DataType dt) {
        return this.filterOnSize(dt);
    }

    protected void encodeAttributes(Encoder encoder) throws IOException {
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_MINSIZE, this.minSize);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_MAXSIZE, this.maxSize);
    }

    protected void restoreAttributesXml(XmlElement el) {
        for (Map.Entry attrib : el.getAttributes().entrySet()) {
            String nm = (String)attrib.getKey();
            if (nm.equals(AttributeId.ATTRIB_MINSIZE.name())) {
                this.minSize = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()));
                continue;
            }
            if (!nm.equals(AttributeId.ATTRIB_MAXSIZE.name())) continue;
            this.maxSize = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()));
        }
        if (this.maxSize == 0 && this.minSize >= 0) {
            this.maxSize = Integer.MAX_VALUE;
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, NAME);
        this.encodeAttributes(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE.name()});
        this.restoreAttributesXml(elem);
        parser.end(elem);
    }
}

