/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class HomogeneousAggregate
extends SizeRestrictedFilter {
    public static final String NAME_FLOAT4 = "homogeneous-float-aggregate";
    public static final int MAX_PRIMITIVES = 4;
    private String name;
    private int metaType;
    private int maxPrimitives;

    public HomogeneousAggregate(String nm, int meta) {
        this.name = nm;
        this.metaType = meta;
        this.maxPrimitives = 2;
    }

    public HomogeneousAggregate(String nm, int meta, int maxPrim, int min, int max) {
        super(min, max);
        this.name = nm;
        this.metaType = meta;
        this.maxPrimitives = maxPrim;
    }

    @Override
    public DatatypeFilter clone() {
        return new HomogeneousAggregate(this.name, this.metaType, this.maxPrimitives, this.minSize, this.maxSize);
    }

    @Override
    public boolean filter(DataType dt) {
        int meta = PcodeDataTypeManager.getMetatype(dt);
        if (meta != 4 && meta != 3) {
            return false;
        }
        ArrayList<DataType> res = new ArrayList<DataType>();
        if (!DatatypeFilter.extractPrimitives(dt, 4, res) || res.isEmpty()) {
            return false;
        }
        DataType base = res.get(0);
        int baseMeta = PcodeDataTypeManager.getMetatype(base);
        if (baseMeta != this.metaType) {
            return false;
        }
        for (int i = 1; i < res.size(); ++i) {
            if (res.get(i) == base) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        this.encodeAttributes(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE.name()});
        this.restoreAttributesXml(elem);
        parser.end(elem);
    }
}

