/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.database.SpecExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InputListType;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.ParamListRegisterOut;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParamListStandardOut;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class PrototypeModel {
    public static final int UNKNOWN_EXTRAPOP = 32768;
    protected String name;
    protected boolean isExtension;
    private int extrapop;
    private int stackshift;
    private ParamList inputParams;
    private ParamList outputParams;
    private Varnode[] unaffected;
    private Varnode[] killedbycall;
    private Varnode[] returnaddress;
    private Varnode[] likelytrash;
    private PrototypeModel compatModel;
    private AddressSet localRange;
    private AddressSet paramRange;
    private InputListType inputListType = InputListType.STANDARD;
    private boolean hasThis;
    private boolean isConstruct;
    private boolean hasUponEntry;
    private boolean hasUponReturn;

    public PrototypeModel(String name, PrototypeModel model) {
        this.name = name;
        this.isExtension = false;
        this.extrapop = model.extrapop;
        this.stackshift = model.stackshift;
        this.inputListType = model.inputListType;
        this.inputParams = model.inputParams;
        this.outputParams = model.outputParams;
        this.unaffected = model.unaffected;
        this.killedbycall = model.killedbycall;
        this.returnaddress = model.returnaddress;
        this.likelytrash = model.likelytrash;
        this.compatModel = model;
        this.localRange = new AddressSet(model.localRange);
        this.paramRange = new AddressSet(model.paramRange);
        this.hasThis = model.hasThis || name.equals("__thiscall");
        this.isConstruct = model.isConstruct;
        this.hasUponEntry = model.hasUponEntry;
        this.hasUponReturn = model.hasUponReturn;
    }

    public PrototypeModel() {
        this.name = null;
        this.isExtension = false;
        this.extrapop = 32768;
        this.stackshift = -1;
        this.inputParams = null;
        this.outputParams = null;
        this.unaffected = null;
        this.killedbycall = null;
        this.returnaddress = null;
        this.likelytrash = null;
        this.compatModel = null;
        this.localRange = null;
        this.paramRange = null;
        this.hasThis = false;
        this.isConstruct = false;
        this.hasUponEntry = false;
        this.hasUponReturn = false;
    }

    public Varnode[] getUnaffectedList() {
        if (this.unaffected == null) {
            this.unaffected = new Varnode[0];
        }
        return this.unaffected;
    }

    public Varnode[] getKilledByCallList() {
        if (this.killedbycall == null) {
            this.killedbycall = new Varnode[0];
        }
        return this.killedbycall;
    }

    public Varnode[] getLikelyTrash() {
        if (this.likelytrash == null) {
            this.likelytrash = new Varnode[0];
        }
        return this.likelytrash;
    }

    public Varnode[] getReturnAddress() {
        return this.returnaddress;
    }

    public boolean isMerged() {
        return false;
    }

    public boolean isProgramExtension() {
        return this.isExtension;
    }

    public String getName() {
        return this.name;
    }

    public int getExtrapop() {
        return this.extrapop;
    }

    public int getStackshift() {
        return this.stackshift;
    }

    public boolean hasThisPointer() {
        return this.hasThis;
    }

    public boolean isConstructor() {
        return this.isConstruct;
    }

    public InputListType getInputListType() {
        return this.inputListType;
    }

    public boolean hasInjection() {
        return this.hasUponEntry || this.hasUponReturn;
    }

    public VariableStorage getReturnLocation(DataType dataType, Program program) {
        DataType clone = dataType.clone(program.getDataTypeManager());
        PrototypePieces proto = new PrototypePieces(this, clone);
        ArrayList<ParameterPieces> res = new ArrayList<ParameterPieces>();
        this.outputParams.assignMap(proto, program.getDataTypeManager(), res, false);
        if (res.size() > 0) {
            return res.get(0).getVariableStorage(program);
        }
        return null;
    }

    public VariableStorage getNextArgLocation(Parameter[] params, DataType dataType, Program program) {
        return this.getArgLocation(params != null ? params.length : 0, params, dataType, program);
    }

    public VariableStorage getArgLocation(int argIndex, Parameter[] params, DataType dataType, Program program) {
        if (dataType != null) {
            dataType = dataType.clone(program.getDataTypeManager());
        }
        DataType[] arr = new DataType[argIndex + 2];
        arr[0] = VoidDataType.dataType;
        for (int i = 0; i < argIndex; ++i) {
            arr[i + 1] = params != null && i < params.length ? params[i].getDataType() : DataType.DEFAULT;
        }
        arr[argIndex + 1] = dataType;
        VariableStorage[] res = this.getStorageLocations(program, arr, false);
        return res[res.length - 1];
    }

    public void assignParameterStorage(PrototypePieces proto, DataTypeManager dtManager, ArrayList<ParameterPieces> res, boolean addAutoParams) {
        this.outputParams.assignMap(proto, dtManager, res, addAutoParams);
        this.inputParams.assignMap(proto, dtManager, res, addAutoParams);
        if (this.hasThis && addAutoParams && res.size() > 1) {
            int thisIndex = 1;
            if (res.get((int)1).hiddenReturnPtr && res.size() > 2) {
                if (this.inputParams.isThisBeforeRetPointer()) {
                    res.get(1).swapMarkup(res.get(2));
                } else {
                    thisIndex = 2;
                }
            }
            res.get((int)thisIndex).isThisPointer = true;
        }
    }

    public VariableStorage[] getStorageLocations(Program program, DataType[] dataTypes, boolean addAutoParams) {
        PointerDataType injectedThis = null;
        if (addAutoParams && this.hasThis) {
            injectedThis = new PointerDataType(program.getDataTypeManager());
        }
        PrototypePieces proto = new PrototypePieces(this, dataTypes, injectedThis);
        ArrayList<ParameterPieces> res = new ArrayList<ParameterPieces>();
        this.assignParameterStorage(proto, program.getDataTypeManager(), res, addAutoParams);
        VariableStorage[] finalres = new VariableStorage[res.size()];
        for (int i = 0; i < finalres.length; ++i) {
            finalres[i] = res.get(i).getVariableStorage(program);
        }
        return finalres;
    }

    public PrototypeModel getAliasParent() {
        return this.compatModel;
    }

    public boolean isErrorPlaceholder() {
        return false;
    }

    private void buildParamList(String strategy) throws XmlParseException {
        if (strategy == null || strategy.equals("standard")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListStandardOut();
            this.inputListType = InputListType.STANDARD;
        } else if (strategy.equals("register")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListRegisterOut();
            this.inputListType = InputListType.REGISTER;
        } else {
            throw new XmlParseException("Unknown assign strategy: " + strategy);
        }
    }

    public void encode(Encoder encoder, PcodeInjectLibrary injectLibrary) throws IOException {
        if (this.compatModel != null) {
            encoder.openElement(ElementId.ELEM_MODELALIAS);
            encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
            encoder.writeString(AttributeId.ATTRIB_PARENT, this.compatModel.name);
            encoder.closeElement(ElementId.ELEM_MODELALIAS);
            return;
        }
        encoder.openElement(ElementId.ELEM_PROTOTYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        if (this.extrapop != 32768) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_EXTRAPOP, this.extrapop);
        } else {
            encoder.writeString(AttributeId.ATTRIB_EXTRAPOP, "unknown");
        }
        encoder.writeSignedInteger(AttributeId.ATTRIB_STACKSHIFT, this.stackshift);
        if (this.hasThis) {
            encoder.writeBool(AttributeId.ATTRIB_HASTHIS, true);
        }
        if (this.isConstruct) {
            encoder.writeBool(AttributeId.ATTRIB_CONSTRUCTOR, true);
        }
        if (this.inputListType != InputListType.STANDARD) {
            encoder.writeString(AttributeId.ATTRIB_STRATEGY, "register");
        }
        this.inputParams.encode(encoder, true);
        this.outputParams.encode(encoder, false);
        if (this.hasUponEntry || this.hasUponReturn) {
            InjectPayload payload = injectLibrary.getPayload(3, this.getInjectName());
            payload.encode(encoder);
        }
        if (this.unaffected != null) {
            encoder.openElement(ElementId.ELEM_UNAFFECTED);
            this.encodeVarnodes(encoder, this.unaffected);
            encoder.closeElement(ElementId.ELEM_UNAFFECTED);
        }
        if (this.killedbycall != null) {
            encoder.openElement(ElementId.ELEM_KILLEDBYCALL);
            this.encodeVarnodes(encoder, this.killedbycall);
            encoder.closeElement(ElementId.ELEM_KILLEDBYCALL);
        }
        if (this.likelytrash != null) {
            encoder.openElement(ElementId.ELEM_LIKELYTRASH);
            this.encodeVarnodes(encoder, this.likelytrash);
            encoder.closeElement(ElementId.ELEM_LIKELYTRASH);
        }
        if (this.returnaddress != null) {
            encoder.openElement(ElementId.ELEM_RETURNADDRESS);
            this.encodeVarnodes(encoder, this.returnaddress);
            encoder.closeElement(ElementId.ELEM_RETURNADDRESS);
        }
        if (this.localRange != null && !this.localRange.isEmpty()) {
            encoder.openElement(ElementId.ELEM_LOCALRANGE);
            this.encodeAddressSet(encoder, this.localRange);
            encoder.closeElement(ElementId.ELEM_LOCALRANGE);
        }
        if (this.paramRange != null && !this.paramRange.isEmpty()) {
            encoder.openElement(ElementId.ELEM_PARAMRANGE);
            this.encodeAddressSet(encoder, this.paramRange);
            encoder.closeElement(ElementId.ELEM_PARAMRANGE);
        }
        encoder.closeElement(ElementId.ELEM_PROTOTYPE);
    }

    private void encodeVarnodes(Encoder encoder, Varnode[] varnodes) throws IOException {
        for (Varnode vn : varnodes) {
            encoder.openElement(ElementId.ELEM_VARNODE);
            AddressXML.encodeAttributes(encoder, vn.getAddress(), vn.getSize());
            encoder.closeElement(ElementId.ELEM_VARNODE);
        }
    }

    private Varnode[] readVarnodes(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        parser.start(new String[0]);
        ArrayList<Varnode> varnodeList = new ArrayList<Varnode>();
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            AddressXML ourAddress = AddressXML.restoreXml(el, cspec);
            if (ourAddress.getJoinRecord() != null) {
                throw new XmlParseException("No \"join\" in <unaffected>, <killedbycall>, or <likelytrash>");
            }
            varnodeList.add(ourAddress.getVarnode());
            parser.end(el);
        }
        parser.end();
        Varnode[] res = new Varnode[varnodeList.size()];
        varnodeList.toArray(res);
        return res;
    }

    private void encodeAddressSet(Encoder encoder, AddressSet addressSet) throws IOException {
        AddressRangeIterator iter = addressSet.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange addrRange = (AddressRange)iter.next();
            AddressSpace space = addrRange.getAddressSpace();
            long first = addrRange.getMinAddress().getOffset();
            long last = addrRange.getMaxAddress().getOffset();
            if (space.hasSignedOffset()) {
                long mask;
                if (space.getSize() < 64) {
                    mask = 1L;
                    mask <<= space.getSize();
                } else {
                    mask = 0L;
                }
                --mask;
                if (first < 0L && last >= 0L) {
                    encoder.openElement(ElementId.ELEM_RANGE);
                    encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
                    encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, first &= mask);
                    encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, mask);
                    encoder.closeElement(ElementId.ELEM_RANGE);
                    first = 0L;
                }
                first &= mask;
                last &= mask;
            }
            encoder.openElement(ElementId.ELEM_RANGE);
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, first);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, last);
            encoder.closeElement(ElementId.ELEM_RANGE);
        }
    }

    private AddressSet readAddressSet(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        AddressSet addressSet = new AddressSet();
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            AddressXML range = AddressXML.restoreRangeXml(el, cspec);
            parser.end(el);
            Address firstAddr = range.getFirstAddress();
            Address lastAddr = range.getLastAddress();
            addressSet.add(firstAddr, lastAddr);
        }
        parser.end();
        return addressSet;
    }

    protected String getInjectName() {
        if (this.hasUponEntry) {
            return this.name + "@@inject_uponentry";
        }
        return this.name + "@@inject_uponreturn";
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        this.inputParams = null;
        this.outputParams = null;
        XmlElement protoElement = parser.start(new String[0]);
        this.name = protoElement.getAttribute("name");
        if (!SpecExtension.isValidFormalName(this.name)) {
            throw new XmlParseException("Prototype name uses illegal characters");
        }
        this.extrapop = 32768;
        String extpopStr = protoElement.getAttribute("extrapop");
        if (!extpopStr.equals("unknown")) {
            this.extrapop = SpecXmlUtils.decodeInt((String)extpopStr);
        }
        this.stackshift = SpecXmlUtils.decodeInt((String)protoElement.getAttribute("stackshift"));
        this.hasThis = false;
        this.isConstruct = false;
        String thisString = protoElement.getAttribute("hasthis");
        this.hasThis = thisString != null ? SpecXmlUtils.decodeBoolean((String)thisString) : this.name.equals("__thiscall");
        String constructString = protoElement.getAttribute("constructor");
        if (constructString != null) {
            this.isConstruct = SpecXmlUtils.decodeBoolean((String)constructString);
        }
        this.buildParamList(protoElement.getAttribute("strategy"));
        while (parser.peek().isStart()) {
            XmlElement subel = parser.peek();
            String elName = subel.getName();
            if (elName.equals("input")) {
                this.inputParams.restoreXml(parser, cspec);
                continue;
            }
            if (elName.equals("output")) {
                this.outputParams.restoreXml(parser, cspec);
                continue;
            }
            if (elName.equals("pcode")) {
                XmlElement el = parser.peek();
                String source = "Compiler spec=" + cspec.getCompilerSpecID().getIdAsString();
                if (el.getAttribute("inject").equals("uponentry")) {
                    this.hasUponEntry = true;
                } else {
                    this.hasUponReturn = true;
                }
                cspec.getPcodeInjectLibrary().restoreXmlInject(source, this.getInjectName(), 3, parser);
                continue;
            }
            if (elName.equals("unaffected")) {
                this.unaffected = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("killedbycall")) {
                this.killedbycall = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("returnaddress")) {
                this.returnaddress = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("likelytrash")) {
                this.likelytrash = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("localrange")) {
                this.localRange = this.readAddressSet(parser, cspec);
                continue;
            }
            if (elName.equals("paramrange")) {
                this.paramRange = this.readAddressSet(parser, cspec);
                continue;
            }
            subel = parser.start(new String[0]);
            parser.discardSubTree(subel);
        }
        parser.end(protoElement);
    }

    public boolean possibleInputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.inputParams.possibleParamWithSlot(loc, size, res);
    }

    public boolean possibleOutputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.outputParams.possibleParamWithSlot(loc, size, res);
    }

    public int getStackParameterAlignment() {
        return this.inputParams.getStackParameterAlignment();
    }

    public Long getStackParameterOffset() {
        return this.inputParams.getStackParameterOffset();
    }

    public VariableStorage[] getPotentialInputRegisterStorage(Program prog) {
        return this.inputParams.getPotentialRegisterStorage(prog);
    }

    public boolean isEquivalent(PrototypeModel obj) {
        String compatNameOp2;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!this.name.equals(obj.name)) {
            return false;
        }
        if (this.extrapop != obj.extrapop || this.stackshift != obj.stackshift) {
            return false;
        }
        if (this.hasThis != obj.hasThis || this.isConstruct != obj.isConstruct) {
            return false;
        }
        if (this.hasUponEntry != obj.hasUponEntry || this.hasUponReturn != obj.hasUponReturn) {
            return false;
        }
        if (this.inputListType != obj.inputListType) {
            return false;
        }
        if (!this.inputParams.isEquivalent(obj.inputParams)) {
            return false;
        }
        if (!this.outputParams.isEquivalent(obj.outputParams)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.unaffected, (Object[])obj.unaffected)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.killedbycall, (Object[])obj.killedbycall)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.likelytrash, (Object[])obj.likelytrash)) {
            return false;
        }
        String compatName = this.compatModel != null ? this.compatModel.getName() : "";
        String string = compatNameOp2 = obj.compatModel != null ? obj.compatModel.getName() : "";
        if (!compatName.equals(compatNameOp2)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.localRange, (Object)obj.localRange)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.paramRange, (Object)obj.paramRange)) {
            return false;
        }
        return SystemUtilities.isArrayEqual((Object[])this.returnaddress, (Object[])obj.returnaddress);
    }

    public String toString() {
        return this.getName();
    }

    protected void setReturnAddress(Varnode[] returnaddress) {
        this.returnaddress = returnaddress;
    }
}

