/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MenuResourceDataType
extends DynamicDataType {
    private static short MF_POPUP = (short)16;
    private static short MF_END = (short)128;

    public MenuResourceDataType() {
        this(null, "MenuResource", null);
    }

    public MenuResourceDataType(DataTypeManager dtm) {
        this(null, "MenuResource", dtm);
    }

    protected MenuResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    @Override
    public String getDescription() {
        return "Menu stored as a Resource";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "MenuRes";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return "Menu";
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer mbIn) {
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        int tempOffset = 0;
        MemBuffer memBuffer = mbIn;
        try {
            tempOffset = this.addMenuItemTemplateHeaderStructure(memBuffer, comps, tempOffset);
            if (tempOffset < 0) {
                return null;
            }
            boolean lastItem = false;
            Stack<Short> parentItemOptions = new Stack<Short>();
            parentItemOptions.push((short)0);
            while (!lastItem) {
                short option = memBuffer.getShort(tempOffset);
                tempOffset = this.addMenuItemTemplate(memBuffer, comps, tempOffset, option);
                if ((option & MF_POPUP) == MF_POPUP) {
                    parentItemOptions.push(option);
                } else if ((option & MF_END) == MF_END) {
                    short parentOptions = (Short)parentItemOptions.pop();
                    while ((parentOptions & MF_END) == MF_END) {
                        parentOptions = (Short)parentItemOptions.pop();
                    }
                }
                if (parentItemOptions.size() != 0) continue;
                lastItem = true;
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("buffer error: " + e.getMessage()), (Throwable)((Object)e));
        }
        DataTypeComponent[] result = comps.toArray(new DataTypeComponent[comps.size()]);
        return result;
    }

    private int addMenuItemTemplateHeaderStructure(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short versionNumber = memBuffer.getShort(tempOffset);
        if (versionNumber != 0) {
            Msg.debug((Object)this, (Object)"Invalid MENUITEM_TEMPLATE_HEADER version number");
            return -1;
        }
        short menuItemsOffset = memBuffer.getShort(tempOffset + 2);
        if (menuItemsOffset < 0) {
            Msg.debug((Object)this, (Object)"Invalid MENUITEM_TEMPLATE_HEADER offset");
            return -1;
        }
        tempOffset = this.addComp(this.menuItemTemplateHeaderStructure(), 4, "Menu Item Template Header Structure", memBuffer.getAddress(), comps, tempOffset);
        return tempOffset;
    }

    private StructureDataType menuItemTemplateHeaderStructure() {
        StructureDataType struct = new StructureDataType("MENUITEM_TEMPLATE_HEADER", 0);
        struct.add(WordDataType.dataType);
        struct.add(WordDataType.dataType);
        try {
            struct.getComponent(0).setFieldName("versionNumber");
            struct.getComponent(1).setFieldName("offset");
        }
        catch (DuplicateNameException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception building MENUITEM_TEMPLATE_HEADER", (Throwable)e);
        }
        struct.getComponent(0).setComment("Version number of menu");
        struct.getComponent(1).setComment("Menu items offset.");
        return struct;
    }

    private int addMenuItemTemplate(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset, short mtOption) {
        if ((mtOption & MF_POPUP) == MF_POPUP) {
            tempOffset = this.addComp(WordDataType.dataType, 2, "mtOption", memBuffer.getAddress(), comps, tempOffset);
        } else {
            tempOffset = this.addComp(WordDataType.dataType, 2, "mtOption", memBuffer.getAddress(), comps, tempOffset);
            tempOffset = this.addComp(WordDataType.dataType, 2, "mtID", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        }
        tempOffset = this.addUnicodeString(memBuffer, comps, tempOffset, "Menu Item String");
        return tempOffset;
    }

    private int addComp(DataType dataType, int len, String fieldName, Address address, List<DataTypeComponent> comps, int currentOffset) {
        if (len > 0) {
            ReadOnlyDataTypeComponent readOnlyDataTypeComponent = new ReadOnlyDataTypeComponent(dataType, this, len, comps.size(), currentOffset, fieldName, null);
            comps.add(readOnlyDataTypeComponent);
            currentOffset += len;
        }
        return currentOffset;
    }

    private int addUnicodeString(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset, String title) {
        byte[] tempBytes = new byte[1024];
        memBuffer.getBytes(tempBytes, tempOffset);
        int strLength = MenuResourceDataType.findUnicodeLength(tempBytes);
        if (strLength >= 2) {
            tempOffset = this.addComp(UnicodeDataType.dataType, strLength, title, memBuffer.getAddress().add(tempOffset), comps, tempOffset);
            return tempOffset;
        }
        return -1;
    }

    static int findUnicodeLength(byte[] byteArray) {
        for (int i = 0; i <= byteArray.length; i += 2) {
            if (byteArray[i] != 0 || byteArray[i + 1] != 0) continue;
            return i + 2;
        }
        return -1;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<Menu-Resource>";
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "Menu";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MenuResourceDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.MenuResourceDataType", (String)MenuResourceDataType.class.getName());
    }
}

