/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;

public class SegmentedAddressSpace
extends GenericAddressSpace {
    private static final int REALMODE_SIZE = 21;
    private static final long REALMODE_MAXOFFSET = 1114095L;

    protected SegmentedAddressSpace(String name, int size, int unique) {
        super(name, size, 1, unique);
    }

    public SegmentedAddressSpace(String name, int unique) {
        super(name, 21, 1, unique);
        this.maxOffset = 1114095L;
        this.spaceSize = this.maxOffset + 1L;
        this.maxAddress = this.getUncheckedAddress(this.maxOffset);
    }

    protected long getFlatOffset(int segment, long offset) {
        long res = segment;
        res <<= 4;
        return res += offset;
    }

    protected int getDefaultSegmentFromFlat(long flat) {
        if (flat > 1048575L) {
            return 65535;
        }
        return (int)(flat >> 4 & 0xF000L);
    }

    protected long getDefaultOffsetFromFlat(long flat) {
        if (flat > 1048575L) {
            return flat - 1048560L;
        }
        return flat & 0xFFFFL;
    }

    protected long getOffsetFromFlat(long flat, int segment) {
        return flat - (long)(segment << 4);
    }

    protected SegmentedAddress getAddressInSegment(long flat, int preferredSegment) {
        int off;
        if ((long)(preferredSegment << 4) <= flat && (off = (int)(flat - (long)(preferredSegment << 4))) <= 65535) {
            return new SegmentedAddress(this, preferredSegment, off);
        }
        return null;
    }

    @Override
    public Address getAddress(String addrString, boolean caseSensitive) throws AddressFormatException {
        int colonPos = addrString.indexOf(":");
        if (colonPos >= 0) {
            String addrSpaceStr = addrString.substring(0, colonPos);
            String offStr = addrString.substring(colonPos + 1);
            if (StringUtilities.equals((String)this.getName(), (String)addrSpaceStr, (boolean)caseSensitive)) {
                colonPos = offStr.indexOf(":");
                if (colonPos >= 0) {
                    String segString = offStr.substring(0, colonPos);
                    offStr = offStr.substring(colonPos + 1);
                    return this.parseSegmented(segString, offStr);
                }
                return this.parseNonSegmented(offStr);
            }
            return this.parseSegmented(addrSpaceStr, offStr);
        }
        return this.parseNonSegmented(addrString);
    }

    @Override
    public Address subtract(Address addr, long displacement) {
        if (displacement < 0L) {
            return this.add(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize) {
            throw new AddressOutOfBoundsException("Address Overflow in subtract: " + addr + " + " + displacement);
        }
        long off = addr.getOffset() - displacement;
        if (off >= 0L) {
            SegmentedAddress saddr = (SegmentedAddress)addr;
            SegmentedAddress resaddr = this.getAddressInSegment(off, saddr.getSegment());
            if (resaddr == null) {
                resaddr = new SegmentedAddress(this, off);
            }
            return resaddr;
        }
        throw new AddressOutOfBoundsException("Address Overflow in subtract: " + addr + " + " + displacement);
    }

    @Override
    public Address add(Address addr, long displacement) {
        if (displacement < 0L) {
            return this.subtract(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize) {
            throw new AddressOutOfBoundsException("Address Overflow in add: " + addr + " + " + displacement);
        }
        long off = addr.getOffset() + displacement;
        if (off >= 0L && off <= this.maxOffset) {
            SegmentedAddress saddr = (SegmentedAddress)addr;
            SegmentedAddress resaddr = this.getAddressInSegment(off, saddr.getSegment());
            if (resaddr == null) {
                resaddr = new SegmentedAddress(this, off);
            }
            return resaddr;
        }
        throw new AddressOutOfBoundsException("Address Overflow in add: " + addr + " + " + displacement);
    }

    private long parseString(String addr) {
        if (addr.startsWith("0x") || addr.startsWith("0X")) {
            return NumericUtilities.parseHexLong((String)addr.substring(2));
        }
        return NumericUtilities.parseHexLong((String)addr);
    }

    private SegmentedAddress parseNonSegmented(String offStr) throws AddressFormatException {
        try {
            long off = (int)this.parseString(offStr);
            return new SegmentedAddress(this, off);
        }
        catch (NumberFormatException e) {
            throw new AddressFormatException("Cannot parse (" + offStr + ") as a number.");
        }
        catch (AddressOutOfBoundsException e) {
            throw new AddressFormatException(e.getMessage());
        }
    }

    private SegmentedAddress parseSegmented(String segStr, String offStr) throws AddressFormatException {
        int seg = -1;
        try {
            seg = (int)this.parseString(segStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        int off = -1;
        try {
            off = (int)this.parseString(offStr);
        }
        catch (NumberFormatException e) {
            throw new AddressFormatException("Cannot parse (" + segStr + ":" + offStr + ") as a number.");
        }
        try {
            return this.getAddress(seg, off);
        }
        catch (AddressOutOfBoundsException e) {
            throw new AddressFormatException(e.getMessage());
        }
    }

    @Override
    public SegmentedAddress getAddress(long byteOffset) {
        return new SegmentedAddress(this, byteOffset);
    }

    @Override
    public SegmentedAddress getAddressInThisSpaceOnly(long byteOffset) {
        return new SegmentedAddress(this, byteOffset);
    }

    @Override
    protected SegmentedAddress getUncheckedAddress(long byteOffset) {
        return new SegmentedAddress(byteOffset, this);
    }

    public SegmentedAddress getAddress(int segment, int segmentOffset) {
        if (segmentOffset > 65535) {
            throw new AddressOutOfBoundsException("Offset is too large.");
        }
        if (segment > 65535) {
            throw new AddressOutOfBoundsException("Segment is too large.");
        }
        return new SegmentedAddress(this, segment, segmentOffset);
    }

    public int getNextOpenSegment(Address addr) {
        int res = (int)addr.getOffset();
        res = (res >> 4) + 1;
        return res;
    }

    @Override
    public SegmentedAddressSpace getPhysicalSpace() {
        return this;
    }

    @Override
    public int getPointerSize() {
        return 2;
    }
}

