/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBLongIterator;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.EquateRefDBAdapterV0;
import ghidra.program.database.symbol.EquateRefDBAdapterV1;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class EquateRefDBAdapter {
    static final String EQUATE_REFS_TABLE_NAME = "Equate References";
    static final Schema REFS_SCHEMA = new Schema(1, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE, ShortField.INSTANCE, LongField.INSTANCE}, new String[]{"Equate ID", "Equate Reference", "Operand Index", "Varnode Hash"});
    static final int EQUATE_ID_COL = 0;
    static final int ADDR_COL = 1;
    static final int OP_INDEX_COL = 2;
    static final int HASH_COL = 3;

    EquateRefDBAdapter() {
    }

    static EquateRefDBAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new EquateRefDBAdapterV1(dbHandle, addrMap, true);
        }
        try {
            EquateRefDBAdapterV1 adapter = new EquateRefDBAdapterV1(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            EquateRefDBAdapter adapter = EquateRefDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = EquateRefDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static EquateRefDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new EquateRefDBAdapterV1(handle, addrMap, false);
        }
        catch (VersionException versionException) {
            return new EquateRefDBAdapterV0(handle, addrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EquateRefDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, EquateRefDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Equate References...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            EquateRefDBAdapterV1 tmpAdapter = new EquateRefDBAdapterV1(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(1));
                rec.setLongValue(1, addrMap.getKey(addr, true));
                rec.setLongValue(3, 0L);
                ((EquateRefDBAdapter)tmpAdapter).updateRecord(rec);
            }
            dbHandle.deleteTable(EQUATE_REFS_TABLE_NAME);
            EquateRefDBAdapterV1 newAdapter = new EquateRefDBAdapterV1(dbHandle, addrMap, true);
            iter = ((EquateRefDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                ((EquateRefDBAdapter)newAdapter).updateRecord(rec);
            }
            EquateRefDBAdapterV1 equateRefDBAdapterV1 = newAdapter;
            return equateRefDBAdapterV1;
        }
    }

    abstract DBRecord createReference(long var1, short var3, long var4, long var6) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract int getRecordCount();

    abstract Field[] getRecordKeysForAddr(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract Field[] getRecordKeysForEquateID(long var1) throws IOException;

    abstract DBLongIterator getIteratorForAddresses() throws IOException;

    abstract DBLongIterator getIteratorForAddresses(Address var1, Address var2) throws IOException;

    abstract DBLongIterator getIteratorForAddresses(AddressSetView var1) throws IOException;

    abstract DBLongIterator getIteratorForAddresses(Address var1) throws IOException;

    abstract void removeRecord(long var1) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;
}

