/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBRecord;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;

class BitMappedSubMemoryBlock
extends SubMemoryBlock {
    private final MemoryMapDB memMap;
    private final Address mappedAddress;
    private boolean ioPending;

    BitMappedSubMemoryBlock(MemoryMapDBAdapter adapter, DBRecord record) {
        super(adapter, record);
        this.memMap = adapter.getMemoryMap();
        AddressMapDB addressMap = this.memMap.getAddressMap();
        this.mappedAddress = addressMap.decodeAddress(record.getLongValue(5), false);
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        if (this.ioPending) {
            throw new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            byte by = this.getBitOverlayByte(offsetInSubBlock);
            return by;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    AddressRange getMappedRange() {
        Address endMappedAddress = this.mappedAddress.add((this.subBlockLength - 1L) / 8L);
        return new AddressRangeImpl(this.mappedAddress, endMappedAddress);
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            int i;
            this.ioPending = true;
            for (i = 0; i < len; ++i) {
                b[i + off] = this.getBitOverlayByte(offsetInMemBlock++);
            }
            i = len;
            return i;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByte(long offsetInMemBlock, byte b) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            this.doPutByte(this.mappedAddress.addNoWrap(offsetInSubBlock / 8L), (int)(offsetInSubBlock % 8L), b);
        }
        catch (AddressOverflowException e) {
            new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        try {
            int i;
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            for (i = 0; i < len; ++i) {
                this.doPutByte(this.mappedAddress.addNoWrap(offsetInSubBlock / 8L), (int)(offsetInSubBlock % 8L), b[off + i]);
                ++offsetInSubBlock;
            }
            i = len;
            return i;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    private byte getBitOverlayByte(long blockOffset) throws AddressOverflowException, MemoryAccessException {
        Address otherAddr = this.mappedAddress.addNoWrap(blockOffset / 8L);
        byte b = this.memMap.getByte(otherAddr);
        return (byte)(b >> (int)(blockOffset % 8L) & 1);
    }

    private void doPutByte(Address addr, int bitIndex, byte b) throws MemoryAccessException {
        this.ioPending = true;
        byte value = this.memMap.getByte(addr);
        int mask = 1 << bitIndex % 8;
        value = b == 0 ? (byte)(value & ~mask) : (byte)(value | mask);
        this.memMap.setByte(addr, value);
    }

    @Override
    protected boolean join(SubMemoryBlock sub2) {
        return false;
    }

    @Override
    protected boolean isMapped() {
        return true;
    }

    @Override
    protected MemoryBlockType getType() {
        return MemoryBlockType.BIT_MAPPED;
    }

    @Override
    protected SubMemoryBlock split(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getDescription() {
        return "Bit Mapped: " + this.mappedAddress;
    }
}

