/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.program.database.function.FunctionTagMappingAdapter;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionTagMappingAdapterV0
extends FunctionTagMappingAdapter
implements DBListener {
    static final int SCHEMA_VERSION = 0;
    public static final int V0_FUNCTION_ID_COL = 0;
    public static final int V0_TAG_ID_COL = 1;
    static final Schema SCHEMA = new Schema(0, "ID", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Function ID", "Tag ID"});
    private Table table;
    private final DBHandle dbHandle;

    FunctionTagMappingAdapterV0(DBHandle dbHandle, boolean create) throws VersionException {
        this.dbHandle = dbHandle;
        dbHandle.addListener((DBListener)this);
        if (!create) {
            this.table = dbHandle.getTable("Function Tag Map");
            if (this.table == null) {
                return;
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    DBRecord getRecord(long functionID, long tagID) throws IOException {
        if (this.table == null) {
            return null;
        }
        LongField value = new LongField(functionID);
        RecordIterator iter = this.table.indexIterator(0, (Field)value, (Field)value, true);
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            if (rec.getLongValue(0) != functionID || rec.getLongValue(1) != tagID) continue;
            return rec;
        }
        return null;
    }

    @Override
    DBRecord createFunctionTagRecord(long functionID, long tagID) throws IOException {
        Table t = this.getTable();
        DBRecord rec = SCHEMA.createRecord(t.getKey());
        rec.setLongValue(0, functionID);
        rec.setLongValue(1, tagID);
        t.putRecord(rec);
        return rec;
    }

    @Override
    boolean removeFunctionTagRecord(long functionID, long tagID) throws IOException {
        DBRecord record = this.getRecord(functionID, tagID);
        if (record != null) {
            return this.table.deleteRecord(record.getKey());
        }
        return false;
    }

    @Override
    void removeFunctionTagRecord(long tagID) throws IOException {
        if (this.table == null) {
            return;
        }
        RecordIterator iter = this.table.iterator();
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            Long tID = rec.getLongValue(1);
            if (tID != tagID) continue;
            iter.delete();
        }
    }

    @Override
    RecordIterator getRecordsByFunctionID(long functionID) throws IOException {
        if (this.table == null) {
            return new EmptyRecordIterator();
        }
        LongField value = new LongField(functionID);
        return this.table.indexIterator(0, (Field)value, (Field)value, true);
    }

    @Override
    protected RecordIterator getRecords() throws IOException {
        if (this.table == null) {
            return new EmptyRecordIterator();
        }
        return this.table.iterator();
    }

    @Override
    boolean isTagAssigned(long tagID) throws IOException {
        if (this.table == null) {
            return false;
        }
        for (DBRecord rec : this.table) {
            if (rec.getLongValue(1) != tagID) continue;
            return true;
        }
        return false;
    }

    private Table getTable() throws IOException {
        if (this.table == null) {
            this.table = this.dbHandle.createTable("Function Tag Map", SCHEMA, new int[]{0});
        }
        return this.table;
    }

    public void dbRestored(DBHandle dbh) {
        this.table = dbh.getTable("Function Tag Map");
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table table) {
    }

    public void tableAdded(DBHandle dbh, Table table) {
    }
}

