/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Table;
import db.util.ErrorHandler;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.SettingDB;
import ghidra.program.database.data.SettingsCache;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.program.database.data.SettingsDBAdapterV1;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public abstract class ProgramBasedDataTypeManagerDB
extends DataTypeManagerDB
implements ProgramBasedDataTypeManager {
    private static final String INSTANCE_SETTINGS_TABLE_NAME = "Instance Settings";
    private SettingsDBAdapter instanceSettingsAdapter;
    private SettingsCache<Address> instanceSettingsCache = new SettingsCache(200);

    protected ProgramBasedDataTypeManagerDB(DBHandle handle, AddressMap addrMap, int openMode, String tablePrefix, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, addrMap, openMode, tablePrefix, errHandler, lock, monitor);
    }

    @Override
    protected void initializeOtherAdapters(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        if (this.addrMap != null) {
            this.instanceSettingsAdapter = SettingsDBAdapter.getAdapter(this.tablePrefix + INSTANCE_SETTINGS_TABLE_NAME, this.dbHandle, openMode, this.addrMap, monitor);
        }
    }

    @Override
    public void invalidateCache() {
        this.lock.acquire();
        try {
            super.invalidateCache();
            if (this.instanceSettingsAdapter != null) {
                this.instanceSettingsAdapter.invalidateNameCache();
                this.instanceSettingsCache.clear();
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected abstract void dataSettingChanged(Address var1);

    @Override
    public boolean isChangeAllowed(Data data, SettingsDefinition settingsDefinition) {
        if (settingsDefinition instanceof TypeDefSettingsDefinition) {
            return false;
        }
        for (SettingsDefinition def : data.getDataType().getSettingsDefinitions()) {
            if (!def.equals(settingsDefinition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setLongSettingsValue(Data data, String name, long value) {
        return this.updateInstanceSettings(data, name, null, value);
    }

    @Override
    public boolean setStringSettingsValue(Data data, String name, String value) {
        return this.updateInstanceSettings(data, name, value, -1L);
    }

    @Override
    public boolean setSettings(Data data, String name, Object value) {
        if (value instanceof String) {
            return this.updateInstanceSettings(data, name, (String)value, -1L);
        }
        if (this.isAllowedNumberType(value)) {
            return this.updateInstanceSettings(data, name, null, ((Number)value).longValue());
        }
        throw new IllegalArgumentException("Unsupportd Settings Value: " + (value == null ? "null" : value.getClass().getName()));
    }

    private boolean isAllowedNumberType(Object value) {
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        return value instanceof Byte;
    }

    @Override
    public Long getLongSettingsValue(Data data, String name) {
        SettingDB settings = this.getSettingDB(data, name);
        if (settings != null) {
            return settings.getLongValue();
        }
        return null;
    }

    @Override
    public String getStringSettingsValue(Data data, String name) {
        SettingDB settings = this.getSettingDB(data, name);
        if (settings != null) {
            return settings.getStringValue();
        }
        return null;
    }

    @Override
    public Object getSettings(Data data, String name) {
        String obj = this.getStringSettingsValue(data, name);
        if (obj != null) {
            return obj;
        }
        return this.getLongSettingsValue(data, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearSetting(Data data, String name) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            this.instanceSettingsCache.remove(dataAddr, name);
            long addr = this.addrMap.getKey(dataAddr, false);
            if (this.instanceSettingsAdapter.removeSettingsRecord(addr, name)) {
                this.dataSettingChanged(dataAddr);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSettings(Data data) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            Field[] keys;
            this.instanceSettingsCache.clear();
            boolean changed = false;
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            for (Field key : keys = this.instanceSettingsAdapter.getSettingsKeys(this.addrMap.getKey(dataAddr, false))) {
                this.instanceSettingsAdapter.removeSettingsRecord(key.getLongValue());
                changed = true;
            }
            if (changed) {
                this.dataSettingChanged(dataAddr);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        DBHandle scratchPad = null;
        this.lock.acquire();
        try {
            this.instanceSettingsCache.clear();
            scratchPad = this.dbHandle.getScratchPad();
            Table tmpTable = scratchPad.createTable(INSTANCE_SETTINGS_TABLE_NAME, SettingsDBAdapterV1.V1_SETTINGS_SCHEMA);
            List<KeyRange> keyRanges = this.addrMap.getKeyRanges(fromAddr, fromAddr.add(length - 1L), false);
            for (KeyRange range : keyRanges) {
                RecordIterator iter = this.instanceSettingsAdapter.getRecords(range.minKey, range.maxKey);
                while (iter.hasNext()) {
                    monitor.checkCancelled();
                    DBRecord rec = iter.next();
                    tmpTable.putRecord(rec);
                    iter.delete();
                }
            }
            RecordIterator iter = tmpTable.iterator();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                Address addr = this.addrMap.decodeAddress(rec.getLongValue(0));
                long offset = addr.subtract(fromAddr);
                addr = toAddr.add(offset);
                rec.setLongValue(0, this.addrMap.getKey(addr, true));
                this.instanceSettingsAdapter.updateSettingsRecord(rec);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            if (scratchPad != null) {
                try {
                    scratchPad.deleteTable(INSTANCE_SETTINGS_TABLE_NAME);
                }
                catch (IOException iOException) {}
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getInstanceSettingsNames(Data data) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            String[] stringArray = this.instanceSettingsAdapter.getSettingsNames(this.addrMap.getKey(dataAddr, false));
            return stringArray;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new String[0];
    }

    @Override
    public boolean isEmptySetting(Data data) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            return this.instanceSettingsAdapter.getSettingsKeys(this.addrMap.getKey(dataAddr, false)).length == 0;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateInstanceSettings(Data data, String name, String strValue, long longValue) {
        boolean wasChanged = false;
        this.lock.acquire();
        try {
            if (this.instanceSettingsAdapter == null) {
                throw new UnsupportedOperationException();
            }
            if (!this.checkSetting(data, name)) {
                boolean bl = false;
                return bl;
            }
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            long addrKey = this.addrMap.getKey(dataAddr, true);
            DBRecord rec = this.instanceSettingsAdapter.updateSettingsRecord(addrKey, name, strValue, longValue);
            if (rec != null) {
                SettingDB setting = new SettingDB(rec, this.instanceSettingsAdapter.getSettingName(rec));
                this.instanceSettingsCache.put(dataAddr, name, setting);
                this.dataSettingChanged(dataAddr);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return wasChanged;
    }

    private boolean checkSetting(Data data, String name) {
        SettingsDefinition settingsDefinition = null;
        for (SettingsDefinition def : data.getDataType().getSettingsDefinitions()) {
            if (!def.getStorageKey().equals(name)) continue;
            settingsDefinition = def;
            break;
        }
        if (settingsDefinition == null) {
            Msg.warn((Object)this, (Object)("Ignored unrecognized setting '" + name + "'"));
            return false;
        }
        if (settingsDefinition instanceof TypeDefSettingsDefinition) {
            Msg.warn((Object)this, (Object)("Ignored disallowed instance setting '" + name + "'"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingDB getSettingDB(Data data, String name) {
        this.lock.acquire();
        try {
            if (this.instanceSettingsAdapter == null) {
                throw new UnsupportedOperationException();
            }
            Address dataAddr = ProgramBasedDataTypeManagerDB.getDataSettingsAddress(data);
            SettingDB settings = this.instanceSettingsCache.get(dataAddr, name);
            if (settings != null) {
                SettingDB settingDB = settings;
                return settingDB;
            }
            long addr = this.addrMap.getKey(dataAddr, false);
            DBRecord rec = this.instanceSettingsAdapter.getSettingsRecord(addr, name);
            if (rec != null) {
                settings = new SettingDB(rec, this.instanceSettingsAdapter.getSettingName(rec));
                this.instanceSettingsCache.put(dataAddr, name, settings);
                SettingDB settingDB = settings;
                return settingDB;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            List<KeyRange> addrKeyRanges = this.addrMap.getKeyRanges(startAddr, endAddr, false);
            int cnt = addrKeyRanges.size();
            for (int i = 0; i < cnt; ++i) {
                KeyRange kr = addrKeyRanges.get(i);
                this.instanceSettingsAdapter.delete(kr.minKey, kr.maxKey, monitor);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.instanceSettingsCache.clear();
            this.lock.release();
        }
    }

    private static Address getDataSettingsAddress(Data data) {
        DataType dataType;
        Data parent = data.getParent();
        if (parent != null && (dataType = parent.getDataType()) instanceof Array) {
            return ProgramBasedDataTypeManagerDB.getDataSettingsAddress(parent);
        }
        return data.getAddress();
    }
}

