/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.Table;
import ghidra.framework.data.DomainObjectDBChangeSet;
import ghidra.program.database.ChangeDiff;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.NormalizedAddressSet;
import ghidra.program.database.util.SynchronizedAddressSetCollection;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetCollection;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.listing.ProgramChangeSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

class ProgramDBChangeSet
implements ProgramChangeSet,
DomainObjectDBChangeSet {
    private static final Schema STORED_ID_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE}, new String[]{"value"});
    private static final Schema STORED_ADDRESS_RANGE_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"addr1", "addr2"});
    private static final String DATATYPE_ADDITIONS = "DataType Additions";
    private static final String DATATYPE_CHANGES = "DataType Changes";
    private static final String CATEGORY_ADDITIONS = "Category Additions";
    private static final String CATEGORY_CHANGES = "Category Changes";
    private static final String PROGRAM_TREE_ADDITIONS = "Program Tree Additions";
    private static final String PROGRAM_TREE_CHANGES = "Program Tree Changes";
    private static final String ADDRESS_CHANGES = "Address Changes";
    private static final String REGISTER_ADDRESS_CHANGES = "Register Address Changes";
    private static final String SYMBOL_ADDITIONS = "Symbol Additions";
    private static final String SYMBOL_CHANGES = "Symbol Changes";
    private static final String SOURCE_ARCHIVE_ADDITIONS = "Source Archive Additions";
    private static final String SOURCE_ARCHIVE_CHANGES = "Source Archive Changes";
    private static final String FUNCTION_TAG_CHANGES = "Function Tag Changes";
    private static final String FUNCTION_TAG_ADDITIONS = "Function Tag Additions";
    private NormalizedAddressSet changedAddrsSinceCheckout;
    private NormalizedAddressSet changedAddrsSinceSave;
    private NormalizedAddressSet changedRegAddrsSinceCheckout;
    private NormalizedAddressSet changedRegAddrsSinceSave;
    private HashSet<Long> changedDataTypeIds;
    private HashSet<Long> changedCategoryIds;
    private HashSet<Long> changedProgramTreeIds;
    private HashSet<Long> changedSymbolIds;
    private HashSet<Long> changedSourceArchiveIds;
    private HashSet<Long> changedTagIds;
    private HashSet<Long> addedDataTypeIds;
    private HashSet<Long> addedCategoryIds;
    private HashSet<Long> addedProgramTreeIds;
    private HashSet<Long> addedSymbolIds;
    private HashSet<Long> addedSourceArchiveIds;
    private HashSet<Long> addedTagIds;
    private NormalizedAddressSet tmpAddrs;
    private NormalizedAddressSet tmpRegAddrs;
    private HashSet<Long> tmpChangedDataTypeIds;
    private HashSet<Long> tmpChangedCategoryIds;
    private HashSet<Long> tmpChangedProgramTreeIds;
    private HashSet<Long> tmpChangedSymbolIds;
    private HashSet<Long> tmpChangedSourceArchiveIds;
    private HashSet<Long> tmpChangedTagIds;
    private HashSet<Long> tmpAddedDataTypeIds;
    private HashSet<Long> tmpAddedCategoryIds;
    private HashSet<Long> tmpAddedProgramTreeIds;
    private HashSet<Long> tmpAddedSymbolIds;
    private HashSet<Long> tmpAddedSourceArchiveIds;
    private HashSet<Long> tmpAddedTagIds;
    private LinkedList<ChangeDiff> undoList = new LinkedList();
    private LinkedList<ChangeDiff> redoList = new LinkedList();
    private boolean inTransaction;
    private int numUndos = 4;
    private AddressMap addrMap;

    public ProgramDBChangeSet(AddressMap addrMap, int numUndos) {
        this.addrMap = addrMap;
        this.numUndos = numUndos;
        this.changedAddrsSinceCheckout = new NormalizedAddressSet(addrMap);
        this.changedRegAddrsSinceCheckout = new NormalizedAddressSet(addrMap);
        this.changedAddrsSinceSave = new NormalizedAddressSet(addrMap);
        this.changedRegAddrsSinceSave = new NormalizedAddressSet(addrMap);
        this.changedDataTypeIds = new HashSet();
        this.changedCategoryIds = new HashSet();
        this.changedProgramTreeIds = new HashSet();
        this.changedSymbolIds = new HashSet();
        this.changedSourceArchiveIds = new HashSet();
        this.changedTagIds = new HashSet();
        this.addedDataTypeIds = new HashSet();
        this.addedCategoryIds = new HashSet();
        this.addedProgramTreeIds = new HashSet();
        this.addedSymbolIds = new HashSet();
        this.addedSourceArchiveIds = new HashSet();
        this.addedTagIds = new HashSet();
    }

    @Override
    public synchronized AddressSetView getAddressSet() {
        SynchronizedAddressSetCollection addressSetCollection = new SynchronizedAddressSetCollection(this, this.changedAddrsSinceCheckout, this.changedAddrsSinceSave, this.tmpAddrs);
        return addressSetCollection.getCombinedAddressSet();
    }

    @Override
    public synchronized AddressSetCollection getAddressSetCollectionSinceLastSave() {
        return new SynchronizedAddressSetCollection(this, this.changedAddrsSinceSave, this.tmpAddrs);
    }

    @Override
    public synchronized AddressSetCollection getAddressSetCollectionSinceCheckout() {
        return new SynchronizedAddressSetCollection(this, this.changedAddrsSinceCheckout, this.changedAddrsSinceSave);
    }

    @Override
    public synchronized void add(AddressSetView addrSet) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddrs.add(addrSet);
    }

    @Override
    public synchronized void addRange(Address addr1, Address addr2) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        if (addr1.isMemoryAddress() || addr1.isExternalAddress()) {
            this.tmpAddrs.addRange(addr1, addr2);
        }
    }

    @Override
    public synchronized void addRegisterRange(Address addr1, Address addr2) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpRegAddrs.addRange(addr1, addr2);
    }

    @Override
    public synchronized AddressSetView getRegisterAddressSet() {
        SynchronizedAddressSetCollection addressSetCollection = new SynchronizedAddressSetCollection(this, this.changedRegAddrsSinceCheckout, this.changedRegAddrsSinceSave, this.tmpRegAddrs);
        return addressSetCollection.getCombinedAddressSet();
    }

    @Override
    public synchronized void dataTypeChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedDataTypeIds.contains(lid) && !this.tmpAddedDataTypeIds.contains(lid)) {
            this.tmpChangedDataTypeIds.add(lid);
        }
    }

    @Override
    public synchronized void dataTypeAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedDataTypeIds.add(id);
    }

    @Override
    public synchronized long[] getDataTypeChanges() {
        return this.getLongs(this.changedDataTypeIds);
    }

    @Override
    public synchronized long[] getDataTypeAdditions() {
        return this.getLongs(this.addedDataTypeIds);
    }

    @Override
    public synchronized void categoryChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedCategoryIds.contains(lid) && !this.tmpAddedCategoryIds.contains(lid)) {
            this.tmpChangedCategoryIds.add(lid);
        }
    }

    @Override
    public synchronized void categoryAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedCategoryIds.add(id);
    }

    @Override
    public synchronized long[] getCategoryChanges() {
        return this.getLongs(this.changedCategoryIds);
    }

    @Override
    public synchronized long[] getCategoryAdditions() {
        return this.getLongs(this.addedCategoryIds);
    }

    @Override
    public synchronized void programTreeChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedProgramTreeIds.contains(lid) && !this.tmpAddedProgramTreeIds.contains(lid)) {
            this.tmpChangedProgramTreeIds.add(lid);
        }
    }

    @Override
    public synchronized void programTreeAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedProgramTreeIds.add(id);
    }

    @Override
    public synchronized long[] getProgramTreeChanges() {
        return this.getLongs(this.changedProgramTreeIds);
    }

    @Override
    public synchronized long[] getProgramTreeAdditions() {
        return this.getLongs(this.addedProgramTreeIds);
    }

    @Override
    public synchronized void symbolChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedSymbolIds.contains(lid) && !this.tmpAddedSymbolIds.contains(lid)) {
            this.tmpChangedSymbolIds.add(lid);
        }
    }

    @Override
    public synchronized void symbolAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedSymbolIds.add(id);
    }

    @Override
    public synchronized long[] getSymbolChanges() {
        return this.getLongs(this.changedSymbolIds);
    }

    @Override
    public synchronized long[] getSymbolAdditions() {
        return this.getLongs(this.addedSymbolIds);
    }

    @Override
    public synchronized void tagChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.changedTagIds.contains(lid) && !this.tmpChangedTagIds.contains(lid)) {
            this.tmpChangedTagIds.add(lid);
        }
    }

    @Override
    public synchronized void tagCreated(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedTagIds.add(id);
    }

    @Override
    public synchronized long[] getTagChanges() {
        return this.getLongs(this.changedTagIds);
    }

    @Override
    public synchronized long[] getTagCreations() {
        return this.getLongs(this.addedTagIds);
    }

    @Override
    public void sourceArchiveAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedSourceArchiveIds.add(id);
    }

    @Override
    public void sourceArchiveChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedSourceArchiveIds.contains(lid) && !this.tmpAddedSourceArchiveIds.contains(lid)) {
            this.tmpChangedSourceArchiveIds.add(lid);
        }
    }

    @Override
    public long[] getSourceArchiveAdditions() {
        return this.getLongs(this.addedSourceArchiveIds);
    }

    @Override
    public long[] getSourceArchiveChanges() {
        return this.getLongs(this.changedSourceArchiveIds);
    }

    public synchronized void clearUndo(boolean isCheckedOut) {
        if (this.inTransaction) {
            throw new IllegalStateException("Cannot clear in a transaction");
        }
        if (!isCheckedOut) {
            this.changedAddrsSinceCheckout.clear();
            this.changedRegAddrsSinceCheckout.clear();
            this.changedAddrsSinceSave.clear();
            this.changedRegAddrsSinceSave.clear();
            this.changedCategoryIds.clear();
            this.changedDataTypeIds.clear();
            this.changedProgramTreeIds.clear();
            this.changedSymbolIds.clear();
            this.changedSourceArchiveIds.clear();
            this.addedCategoryIds.clear();
            this.addedDataTypeIds.clear();
            this.addedProgramTreeIds.clear();
            this.addedSymbolIds.clear();
            this.addedSourceArchiveIds.clear();
        }
        this.clearUndo();
    }

    public synchronized void startTransaction() {
        this.inTransaction = true;
        this.tmpAddrs = new NormalizedAddressSet(this.addrMap);
        this.tmpRegAddrs = new NormalizedAddressSet(this.addrMap);
        this.tmpChangedDataTypeIds = new HashSet();
        this.tmpChangedCategoryIds = new HashSet();
        this.tmpChangedProgramTreeIds = new HashSet();
        this.tmpChangedSymbolIds = new HashSet();
        this.tmpChangedSourceArchiveIds = new HashSet();
        this.tmpChangedTagIds = new HashSet();
        this.tmpAddedDataTypeIds = new HashSet();
        this.tmpAddedCategoryIds = new HashSet();
        this.tmpAddedProgramTreeIds = new HashSet();
        this.tmpAddedSymbolIds = new HashSet();
        this.tmpAddedSourceArchiveIds = new HashSet();
        this.tmpAddedTagIds = new HashSet();
    }

    public synchronized void endTransaction(boolean commit) {
        if (!this.inTransaction) {
            return;
        }
        this.inTransaction = false;
        if (commit) {
            this.redoList.clear();
            this.tmpAddrs.delete(this.changedAddrsSinceSave);
            this.tmpRegAddrs.delete(this.changedRegAddrsSinceSave);
            this.tmpChangedDataTypeIds.removeAll(this.changedDataTypeIds);
            this.tmpChangedCategoryIds.removeAll(this.changedCategoryIds);
            this.tmpChangedProgramTreeIds.removeAll(this.changedProgramTreeIds);
            this.tmpChangedSymbolIds.removeAll(this.changedSymbolIds);
            this.tmpChangedSourceArchiveIds.removeAll(this.changedSourceArchiveIds);
            this.tmpChangedTagIds.removeAll(this.changedTagIds);
            this.changedAddrsSinceSave.add(this.tmpAddrs);
            this.changedRegAddrsSinceSave.add(this.tmpRegAddrs);
            this.changedDataTypeIds.addAll(this.tmpChangedDataTypeIds);
            this.changedCategoryIds.addAll(this.tmpChangedCategoryIds);
            this.changedProgramTreeIds.addAll(this.tmpChangedProgramTreeIds);
            this.changedSymbolIds.addAll(this.tmpChangedSymbolIds);
            this.changedSourceArchiveIds.addAll(this.tmpChangedSourceArchiveIds);
            this.changedTagIds.addAll(this.tmpChangedTagIds);
            this.addedDataTypeIds.addAll(this.tmpAddedDataTypeIds);
            this.addedCategoryIds.addAll(this.tmpAddedCategoryIds);
            this.addedProgramTreeIds.addAll(this.tmpAddedProgramTreeIds);
            this.addedSymbolIds.addAll(this.tmpAddedSymbolIds);
            this.addedSourceArchiveIds.addAll(this.tmpAddedSourceArchiveIds);
            this.addedTagIds.addAll(this.tmpAddedTagIds);
            this.undoList.addLast(new ChangeDiff(this.tmpAddrs, this.tmpRegAddrs, this.tmpChangedDataTypeIds, this.tmpChangedCategoryIds, this.tmpChangedProgramTreeIds, this.tmpChangedSymbolIds, this.tmpChangedSourceArchiveIds, this.tmpChangedTagIds, this.tmpAddedDataTypeIds, this.tmpAddedCategoryIds, this.tmpAddedProgramTreeIds, this.tmpAddedSymbolIds, this.tmpAddedSourceArchiveIds, this.tmpAddedTagIds));
            if (this.undoList.size() > this.numUndos) {
                this.undoList.removeFirst();
            }
        }
        this.tmpAddrs = null;
        this.tmpRegAddrs = null;
        this.tmpChangedDataTypeIds = null;
        this.tmpChangedCategoryIds = null;
        this.tmpChangedProgramTreeIds = null;
        this.tmpChangedSymbolIds = null;
        this.tmpChangedSourceArchiveIds = null;
        this.tmpChangedTagIds = null;
        this.tmpAddedDataTypeIds = null;
        this.tmpAddedCategoryIds = null;
        this.tmpAddedProgramTreeIds = null;
        this.tmpAddedSymbolIds = null;
        this.tmpAddedSourceArchiveIds = null;
        this.tmpAddedTagIds = null;
    }

    public synchronized void undo() {
        ChangeDiff diff = this.undoList.removeLast();
        this.changedAddrsSinceSave.delete(diff.set);
        this.changedRegAddrsSinceSave.delete(diff.regSet);
        this.changedDataTypeIds.removeAll(diff.changedDts);
        this.changedCategoryIds.removeAll(diff.changedCats);
        this.changedProgramTreeIds.removeAll(diff.changedPts);
        this.changedSymbolIds.removeAll(diff.changedSyms);
        this.changedSourceArchiveIds.removeAll(diff.changedArchives);
        this.changedTagIds.removeAll(diff.changedTags);
        this.addedDataTypeIds.removeAll(diff.addedDts);
        this.addedCategoryIds.removeAll(diff.addedCats);
        this.addedProgramTreeIds.removeAll(diff.addedPts);
        this.addedSymbolIds.removeAll(diff.addedSyms);
        this.addedSourceArchiveIds.removeAll(diff.addedArchives);
        this.addedTagIds.removeAll(diff.addedTags);
        this.redoList.addLast(diff);
    }

    public synchronized void redo() {
        ChangeDiff diff = this.redoList.removeLast();
        this.changedAddrsSinceSave.add(diff.set);
        this.changedRegAddrsSinceSave.add(diff.regSet);
        this.changedDataTypeIds.addAll(diff.changedDts);
        this.changedCategoryIds.addAll(diff.changedCats);
        this.changedProgramTreeIds.addAll(diff.changedPts);
        this.changedSymbolIds.addAll(diff.changedSyms);
        this.changedSourceArchiveIds.addAll(diff.changedArchives);
        this.changedTagIds.addAll(diff.changedTags);
        this.addedDataTypeIds.addAll(diff.addedDts);
        this.addedCategoryIds.addAll(diff.addedCats);
        this.addedProgramTreeIds.addAll(diff.addedPts);
        this.addedSymbolIds.addAll(diff.addedSyms);
        this.addedSourceArchiveIds.addAll(diff.addedArchives);
        this.addedTagIds.addAll(diff.addedTags);
        this.undoList.addLast(diff);
    }

    public synchronized void clearUndo() {
        this.undoList.clear();
        this.redoList.clear();
    }

    public synchronized void setMaxUndos(int numUndos) {
        this.numUndos = numUndos;
    }

    public synchronized void read(DBHandle dbh) throws IOException {
        this.readIdRecords(dbh, DATATYPE_ADDITIONS, this.addedDataTypeIds);
        this.readIdRecords(dbh, DATATYPE_CHANGES, this.changedDataTypeIds);
        this.readIdRecords(dbh, CATEGORY_ADDITIONS, this.addedCategoryIds);
        this.readIdRecords(dbh, CATEGORY_CHANGES, this.changedCategoryIds);
        this.readIdRecords(dbh, PROGRAM_TREE_ADDITIONS, this.addedProgramTreeIds);
        this.readIdRecords(dbh, PROGRAM_TREE_CHANGES, this.changedProgramTreeIds);
        this.readIdRecords(dbh, SYMBOL_ADDITIONS, this.addedSymbolIds);
        this.readIdRecords(dbh, SYMBOL_CHANGES, this.changedSymbolIds);
        this.readIdRecords(dbh, SOURCE_ARCHIVE_ADDITIONS, this.addedSourceArchiveIds);
        this.readIdRecords(dbh, SOURCE_ARCHIVE_CHANGES, this.changedSourceArchiveIds);
        this.readIdRecords(dbh, FUNCTION_TAG_ADDITIONS, this.addedTagIds);
        this.readIdRecords(dbh, FUNCTION_TAG_CHANGES, this.changedTagIds);
        this.readAddressRangeRecords(dbh, ADDRESS_CHANGES, this.changedAddrsSinceCheckout);
        this.readAddressRangeRecords(dbh, REGISTER_ADDRESS_CHANGES, this.changedRegAddrsSinceCheckout);
        this.clearUndo();
    }

    private void readIdRecords(DBHandle dbh, String tableName, Set<Long> ids) throws IOException {
        Table table = dbh.getTable(tableName);
        if (table != null) {
            if (table.getSchema().getVersion() != 0) {
                throw new IOException("Change data produced with newer version of Ghidra");
            }
            for (DBRecord rec : table) {
                ids.add(rec.getLongValue(0));
            }
        }
    }

    private void readAddressRangeRecords(DBHandle dbh, String tableName, NormalizedAddressSet set) throws IOException {
        Table table = dbh.getTable(tableName);
        if (table != null) {
            if (table.getSchema().getVersion() != 0) {
                throw new IOException("Change data produced with newer version of Ghidra");
            }
            for (DBRecord rec : table) {
                Address addr1 = this.addrMap.decodeAddress(rec.getLongValue(0));
                Address addr2 = this.addrMap.decodeAddress(rec.getLongValue(1));
                if (!addr1.isMemoryAddress() && !addr1.isExternalAddress()) continue;
                set.addRange(addr1, addr2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DBHandle dbh, boolean isRecoverySave) throws IOException {
        this.changedAddrsSinceCheckout.add(this.changedAddrsSinceSave);
        this.changedRegAddrsSinceCheckout.add(this.changedRegAddrsSinceSave);
        if (!isRecoverySave) {
            this.changedAddrsSinceSave.clear();
            this.changedRegAddrsSinceSave.clear();
        }
        long txId = dbh.startTransaction();
        boolean success = false;
        try {
            this.writeIdRecords(dbh, DATATYPE_ADDITIONS, this.addedDataTypeIds);
            this.writeIdRecords(dbh, DATATYPE_CHANGES, this.changedDataTypeIds);
            this.writeIdRecords(dbh, CATEGORY_ADDITIONS, this.addedCategoryIds);
            this.writeIdRecords(dbh, CATEGORY_CHANGES, this.changedCategoryIds);
            this.writeIdRecords(dbh, PROGRAM_TREE_ADDITIONS, this.addedProgramTreeIds);
            this.writeIdRecords(dbh, PROGRAM_TREE_CHANGES, this.changedProgramTreeIds);
            this.writeIdRecords(dbh, SYMBOL_ADDITIONS, this.addedSymbolIds);
            this.writeIdRecords(dbh, SYMBOL_CHANGES, this.changedSymbolIds);
            this.writeIdRecords(dbh, SOURCE_ARCHIVE_ADDITIONS, this.addedSourceArchiveIds);
            this.writeIdRecords(dbh, SOURCE_ARCHIVE_CHANGES, this.changedSourceArchiveIds);
            this.writeIdRecords(dbh, FUNCTION_TAG_ADDITIONS, this.addedTagIds);
            this.writeIdRecords(dbh, FUNCTION_TAG_CHANGES, this.changedTagIds);
            this.writeAddressRangeRecords(dbh, ADDRESS_CHANGES, this.changedAddrsSinceCheckout);
            this.writeAddressRangeRecords(dbh, REGISTER_ADDRESS_CHANGES, this.changedRegAddrsSinceCheckout);
            success = true;
        }
        finally {
            dbh.endTransaction(txId, success);
        }
    }

    private void writeIdRecords(DBHandle dbh, String tableName, Set<Long> ids) throws IOException {
        if (ids.size() > 0) {
            Table table = dbh.createTable(tableName, STORED_ID_SCHEMA);
            DBRecord rec = STORED_ID_SCHEMA.createRecord(0L);
            int key = 1;
            for (long id : ids) {
                rec.setKey((long)key++);
                rec.setLongValue(0, id);
                table.putRecord(rec);
            }
        }
    }

    private void writeAddressRangeRecords(DBHandle dbh, String tableName, AddressSetView set) throws IOException {
        if (!set.isEmpty()) {
            Table table = dbh.createTable(tableName, STORED_ADDRESS_RANGE_SCHEMA);
            DBRecord rec = STORED_ADDRESS_RANGE_SCHEMA.createRecord(0L);
            int key = 1;
            for (KeyRange range : this.addrMap.getKeyRanges(set, false, false)) {
                rec.setKey((long)key++);
                rec.setLongValue(0, range.minKey);
                rec.setLongValue(1, range.maxKey);
                table.putRecord(rec);
            }
        }
    }

    private long[] getLongs(HashSet<Long> set) {
        long[] result = new long[set.size()];
        Iterator<Long> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        return result;
    }

    @Override
    public boolean hasChanges() {
        return !this.changedAddrsSinceSave.isEmpty() || !this.changedRegAddrsSinceSave.isEmpty() || !this.changedDataTypeIds.isEmpty() || !this.changedCategoryIds.isEmpty() || !this.changedProgramTreeIds.isEmpty() || !this.changedSymbolIds.isEmpty() || !this.changedSourceArchiveIds.isEmpty() || !this.changedTagIds.isEmpty() || !this.addedDataTypeIds.isEmpty() || !this.addedCategoryIds.isEmpty() || !this.addedProgramTreeIds.isEmpty() || !this.addedSymbolIds.isEmpty() || !this.addedSourceArchiveIds.isEmpty() || !this.addedTagIds.isEmpty();
    }
}

