/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class OpTpl {
    private VarnodeTpl output;
    private int opcode;
    private VarnodeTpl[] input;

    protected OpTpl() {
    }

    public OpTpl(int opcode, VarnodeTpl output, VarnodeTpl[] inputs) {
        this.opcode = opcode;
        this.output = output;
        this.input = inputs;
    }

    public VarnodeTpl getOutput() {
        return this.output;
    }

    public VarnodeTpl[] getInput() {
        return this.input;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void restoreXml(XmlPullParser parser, AddressFactory factory) throws UnknownInstructionException {
        XmlElement el = parser.start(new String[]{"op_tpl"});
        this.opcode = PcodeOp.getOpcode(el.getAttribute("code"));
        XmlElement outel = parser.peek();
        if (outel.getName().equals("null")) {
            this.output = null;
            parser.discardSubTree();
        } else {
            this.output = new VarnodeTpl();
            this.output.restoreXml(parser, factory);
        }
        ArrayList<VarnodeTpl> inputlist = new ArrayList<VarnodeTpl>();
        while (!parser.peek().isEnd()) {
            VarnodeTpl vn = new VarnodeTpl();
            vn.restoreXml(parser, factory);
            inputlist.add(vn);
        }
        this.input = new VarnodeTpl[inputlist.size()];
        inputlist.toArray(this.input);
        parser.end(el);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.output != null) {
            sb.append(this.output);
            sb.append(" = ");
        }
        sb.append(PcodeOp.getMnemonic(this.opcode));
        boolean first = true;
        for (VarnodeTpl in : this.input) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(" ");
            sb.append(in);
        }
        return sb.toString();
    }
}

