/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class ConstructTpl {
    private int numlabels = 0;
    private OpTpl[] vec;
    private HandleTpl result;

    public ConstructTpl() {
    }

    public ConstructTpl(OpTpl[] opvec) {
        this.vec = opvec;
        this.result = null;
    }

    public ConstructTpl(OpTpl[] opvec, HandleTpl res, int nmLabels) {
        this.vec = opvec;
        this.result = res;
        this.numlabels = nmLabels;
    }

    public int getNumLabels() {
        return this.numlabels;
    }

    public OpTpl[] getOpVec() {
        return this.vec;
    }

    public HandleTpl getResult() {
        return this.result;
    }

    public int restoreXml(XmlPullParser parser, AddressFactory factory) throws UnknownInstructionException {
        XmlElement handel;
        String sectionidstr;
        int sectionid = -1;
        XmlElement el = parser.start(new String[]{"construct_tpl"});
        String nmlabelstr = el.getAttribute("labels");
        if (nmlabelstr != null) {
            this.numlabels = SpecXmlUtils.decodeInt((String)nmlabelstr);
        }
        if ((sectionidstr = el.getAttribute("section")) != null) {
            sectionid = SpecXmlUtils.decodeInt((String)sectionidstr);
        }
        if ((handel = parser.peek()).getName().equals("null")) {
            this.result = null;
            parser.discardSubTree();
        } else {
            this.result = new HandleTpl();
            this.result.restoreXml(parser, factory);
        }
        ArrayList<OpTpl> oplist = new ArrayList<OpTpl>();
        while (!parser.peek().isEnd()) {
            OpTpl op = new OpTpl();
            op.restoreXml(parser, factory);
            oplist.add(op);
        }
        this.vec = new OpTpl[oplist.size()];
        oplist.toArray(this.vec);
        parser.end(el);
        return sectionid;
    }
}

