/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import generic.util.DequePush;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseActionGotoTable;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyEOI;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.assembler.sleigh.util.AsmUtil;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class AssemblyParseMachine
implements Comparable<AssemblyParseMachine> {
    private static final int ERROR_NONE = 0;
    private static final int ERROR_SYNTAX = 1;
    protected final AssemblyParser parser;
    protected final List<Integer> output = new ArrayList<Integer>();
    protected final Stack<Integer> stack = new Stack();
    protected final Stack<AssemblyParseTreeNode> treeStack = new Stack();
    protected final String buffer;
    protected int pos;
    protected AssemblyParseToken lastTok;
    protected final AssemblyNumericSymbols symbols;
    protected boolean accepted = false;
    protected int error = 0;
    protected String got;
    protected Collection<AssemblyTerminal> expected;
    protected final int id;
    static int nextMachineId = 0;
    static final DbgTimer DBG = DbgTimer.INACTIVE;

    public AssemblyParseMachine(AssemblyParser parser, String input, int pos, AssemblyParseToken lastTok, AssemblyNumericSymbols symbols) {
        this.parser = parser;
        this.stack.push(0);
        this.buffer = input;
        this.pos = pos;
        this.lastTok = lastTok;
        this.id = nextMachineId++;
        this.symbols = symbols;
    }

    public int hashCode() {
        int result = this.pos;
        for (int s : this.output) {
            result *= 31;
            result += s;
        }
        for (AssemblyParseTreeNode s : this.treeStack) {
            result *= 31;
            result += s.hashCode();
        }
        result *= 31;
        result += this.accepted ? 1 : 0;
        result *= 31;
        return result += this.error;
    }

    public boolean equals(Object that) {
        if (!(that instanceof AssemblyParseMachine)) {
            return false;
        }
        AssemblyParseMachine apm = (AssemblyParseMachine)that;
        if (this.pos != apm.pos) {
            return false;
        }
        if (!this.output.equals(apm.output)) {
            return false;
        }
        if (!this.stack.equals(apm.stack)) {
            return false;
        }
        if (this.accepted != apm.accepted) {
            return false;
        }
        return this.error == apm.error;
    }

    @Override
    public int compareTo(AssemblyParseMachine that) {
        int result = this.pos - that.pos;
        if (result != 0) {
            return result;
        }
        result = AsmUtil.compareInOrder(this.stack, that.stack);
        if (result != 0) {
            return result;
        }
        result = AsmUtil.compareInOrder(this.output, that.output);
        if (result != 0) {
            return result;
        }
        if (this.accepted & !that.accepted) {
            return 1;
        }
        if (!this.accepted & that.accepted) {
            return -1;
        }
        result = this.error - that.error;
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public AssemblyParseMachine copy() {
        AssemblyParseMachine c = new AssemblyParseMachine(this.parser, this.buffer, this.pos, this.lastTok, this.symbols);
        c.output.clear();
        c.output.addAll(this.output);
        c.stack.clear();
        c.stack.addAll(this.stack);
        c.treeStack.clear();
        c.treeStack.addAll(this.treeStack);
        c.accepted = this.accepted;
        c.error = this.error;
        DBG.println("Copied " + this.id + " to " + c.id);
        return c;
    }

    protected void doAction(AssemblyParseActionGotoTable.Action a, AssemblyParseToken tok, Set<AssemblyParseMachine> results, Deque<AssemblyParseMachine> visited) {
        try (DbgTimer.DbgCtx dc = DBG.start("Action: " + a);){
            if (a instanceof AssemblyParseActionGotoTable.ShiftAction) {
                AssemblyParseMachine m = this.copy();
                m.stack.push(((AssemblyParseActionGotoTable.ShiftAction)a).newStateNum);
                m.treeStack.push(tok);
                m.lastTok = tok;
                m.pos += tok.getString().length();
                m.exhaust(results, visited);
            } else if (a instanceof AssemblyParseActionGotoTable.ReduceAction) {
                AssemblyProduction prod = ((AssemblyParseActionGotoTable.ReduceAction)a).prod;
                AssemblyParseBranch branch = new AssemblyParseBranch(this.parser.grammar, prod);
                AssemblyParseMachine m = this.copy();
                m.output.add(prod.getIndex());
                DBG.println("Prod: " + prod);
                for (AssemblySymbol sym : prod.getRHS()) {
                    m.stack.pop();
                    branch.addChild(m.treeStack.pop());
                }
                for (AssemblyParseActionGotoTable.Action aa : m.parser.actions.get(m.stack.peek(), (AssemblySymbol)prod.getLHS())) {
                    AssemblyParseActionGotoTable.GotoAction ga = (AssemblyParseActionGotoTable.GotoAction)aa;
                    DBG.println("Goto: " + ga);
                    AssemblyParseMachine n = m.copy();
                    n.stack.push(ga.newStateNum);
                    n.treeStack.push(branch);
                    n.exhaust(results, visited);
                }
            } else if (a instanceof AssemblyParseActionGotoTable.AcceptAction) {
                AssemblyParseMachine m = this.copy();
                m.accepted = true;
                results.add(m);
            }
        }
    }

    protected void consume(AssemblyTerminal t, AssemblyParseToken tok, Set<AssemblyParseMachine> results, Deque<AssemblyParseMachine> visited) {
        try (DbgTimer.DbgCtx dc = DBG.start("Matched " + t + " " + tok);){
            Collection<AssemblyParseActionGotoTable.Action> as = this.parser.actions.get(this.stack.peek(), t);
            assert (!as.isEmpty());
            DBG.println("Actions: " + as);
            for (AssemblyParseActionGotoTable.Action a : as) {
                this.doAction(a, tok, results, visited);
            }
        }
    }

    protected static AssemblyParseMachine findLoop(AssemblyParseMachine machine, Collection<AssemblyParseMachine> visited) {
        for (AssemblyParseMachine v : visited) {
            if (v == machine || v.pos != machine.pos || !v.stack.equals(machine.stack)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.stack + ":" + this.treeStack + ":" + this.buffer + " (" + this.pos + ")";
    }

    protected void exhaust(Set<AssemblyParseMachine> results, Deque<AssemblyParseMachine> visited) {
        try (DbgTimer.DbgCtx dc = DBG.start("Exhausting machine " + this.id);){
            DBG.println("Machine: " + this);
            AssemblyParseMachine loop = AssemblyParseMachine.findLoop(this, visited);
            if (loop != null) {
                DBG.println("Pruned. Loop of " + loop.id);
                return;
            }
            try (DequePush push = DequePush.push(visited, (Object)this);){
                if (this.error != 0) {
                    throw new AssertionError((Object)"INTERNAL: Tried to step a machine with errors");
                }
                if (this.accepted) {
                    throw new AssertionError((Object)"INTERNAL: Tried to step an accepted machine");
                }
                Collection<AssemblyTerminal> terms = this.parser.actions.getExpected(this.stack.peek());
                if (terms.isEmpty()) {
                    throw new RuntimeException("Encountered a state with no actions");
                }
                TreeSet<AssemblyTerminal> unmatched = new TreeSet<AssemblyTerminal>(terms);
                for (AssemblyTerminal t : terms) {
                    for (AssemblyParseToken assemblyParseToken : t.match(this.buffer, this.pos, this.parser.grammar, this.symbols)) {
                        unmatched.remove(t);
                        assert (this.buffer.regionMatches(this.pos, assemblyParseToken.getString(), 0, assemblyParseToken.getString().length()));
                        this.consume(t, assemblyParseToken, results, visited);
                    }
                }
                if (!unmatched.isEmpty()) {
                    TreeSet<AssemblyTerminal> newExpected;
                    AssemblyParseMachine m = this.copy();
                    if (m.lastTok == null || !(m.lastTok instanceof AssemblySentential.TruncatedWhiteSpaceParseToken)) {
                        newExpected = unmatched;
                    } else {
                        newExpected = new TreeSet();
                        newExpected.add(AssemblySentential.WHITE_SPACE);
                    }
                    DBG.println("Syntax Error: ");
                    DBG.println("  Expected: " + newExpected);
                    DBG.println("  Got: " + this.buffer.substring(this.pos));
                    m.error = 1;
                    m.got = this.buffer.substring(this.pos);
                    m.expected = newExpected;
                    results.add(m);
                    return;
                }
            }
        }
    }

    public Set<AssemblyParseMachine> exhaust() {
        LinkedHashSet<AssemblyParseMachine> results = new LinkedHashSet<AssemblyParseMachine>();
        LinkedList<AssemblyParseMachine> visited = new LinkedList<AssemblyParseMachine>();
        this.exhaust(results, visited);
        return results;
    }

    public AssemblyParseBranch getTree() {
        if (!this.accepted) {
            throw new AssertionError((Object)"INTERNAL: Machine has not accepted its buffer");
        }
        if (this.pos != this.buffer.length()) {
            throw new AssertionError((Object)"INTERNAL: Machine has not emptied its buffer");
        }
        if (!this.treeStack.pop().getSym().equals(AssemblyEOI.EOI)) {
            throw new AssertionError((Object)"INTERNAL: Machine has not encountered end of input marker");
        }
        if (this.treeStack.size() != 1) {
            throw new AssertionError((Object)"INTERNAL: More than root branch remains on machine stack");
        }
        return (AssemblyParseBranch)this.treeStack.pop();
    }
}

