/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.linux;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import ghidra.pty.Pty;
import ghidra.pty.linux.LinuxPtyChild;
import ghidra.pty.linux.LinuxPtyParent;
import ghidra.pty.linux.PosixC;
import ghidra.pty.linux.Util;
import ghidra.util.Msg;
import java.io.IOException;

public class LinuxPty
implements Pty {
    static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final int aparent;
    private final int achild;
    private boolean closed = false;
    private final LinuxPtyParent parent;
    private final LinuxPtyChild child;

    public static LinuxPty openpty() throws IOException {
        IntByReference p = new IntByReference();
        IntByReference c = new IntByReference();
        Memory n = new Memory(1024L);
        Util.INSTANCE.openpty(p, c, (Pointer)n, null, null);
        return new LinuxPty(p.getValue(), c.getValue(), n.getString(0L));
    }

    LinuxPty(int aparent, int achild, String name) {
        Msg.debug((Object)this, (Object)("New Pty: " + name + " at (" + aparent + "," + achild + ")"));
        this.aparent = aparent;
        this.achild = achild;
        this.parent = new LinuxPtyParent(aparent);
        this.child = new LinuxPtyChild(achild, name);
    }

    @Override
    public LinuxPtyParent getParent() {
        return this.parent;
    }

    @Override
    public LinuxPtyChild getChild() {
        return this.child;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        LIB_POSIX.close(this.achild);
        LIB_POSIX.close(this.aparent);
        this.closed = true;
    }
}

