/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.VectorResult;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimilarityVectorResult {
    private FunctionDescription basefunc;
    private List<VectorResult> notes;
    private int totalcount;

    public SimilarityVectorResult() {
    }

    public SimilarityVectorResult(FunctionDescription f) {
        this.basefunc = f;
        this.notes = new ArrayList<VectorResult>();
        this.totalcount = 0;
    }

    public void addNotes(List<VectorResult> newnotes) {
        for (VectorResult note : newnotes) {
            this.totalcount += note.hitcount;
            this.notes.add(note);
        }
    }

    public Iterator<VectorResult> iterator() {
        return this.notes.iterator();
    }

    public FunctionDescription getBase() {
        return this.basefunc;
    }

    public int getTotalCount() {
        return this.totalcount;
    }

    public void sortNotes() {
        Collections.sort(this.notes, new Comparator<VectorResult>(){

            @Override
            public int compare(VectorResult o1, VectorResult o2) {
                return Long.compare(o1.vectorid, o2.vectorid);
            }
        });
    }

    public void saveXml(Writer write) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<simvecres");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.basefunc.getExecutableRecord().getXrefIndex());
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.basefunc.getFunctionName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"addr", (long)this.basefunc.getAddress());
        buf.append(">\n");
        write.append(buf.toString());
        Iterator<VectorResult> iter = this.notes.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(write);
        }
        write.append("</simvecres>\n");
    }

    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory, DescriptionManager qmanage, Map<Integer, ExecutableRecord> exeMap) throws LSHException {
        this.notes = new ArrayList<VectorResult>();
        XmlElement el = parser.start(new String[]{"simvecres"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
        ExecutableRecord exe = exeMap.get(id);
        long address = SpecXmlUtils.decodeLong((String)el.getAttribute("addr"));
        this.basefunc = qmanage.findFunction(el.getAttribute("name"), address, exe);
        this.totalcount = 0;
        while (parser.peek().isStart()) {
            VectorResult newnote = new VectorResult();
            newnote.restoreXml(parser, vectorFactory);
            this.notes.add(newnote);
            this.totalcount += newnote.hitcount;
        }
        parser.end();
    }
}

