/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.ingest;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IterateRepository {
    protected abstract void process(Program var1, TaskMonitor var2) throws Exception, CancelledException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(URL ghidraURL, TaskMonitor monitor) throws Exception, CancelledException {
        String tmp;
        int pos;
        if (!GhidraURL.isServerRepositoryURL((URL)ghidraURL) && !GhidraURL.isLocalProjectURL((URL)ghidraURL)) {
            throw new MalformedURLException("Unsupported repository URL: " + ghidraURL);
        }
        URL repoURL = GhidraURL.getProjectURL((URL)ghidraURL);
        String path = GhidraURL.getProjectPathname((URL)ghidraURL);
        String finalelement = null;
        if (!(path = path.trim()).endsWith("/") && (pos = path.lastIndexOf(47)) >= 0 && (tmp = path.substring(0, pos + 1)).length() != 0 && !tmp.equals("/")) {
            finalelement = path.substring(pos + 1);
            path = tmp;
            ghidraURL = GhidraURL.isServerRepositoryURL((URL)ghidraURL) ? new URL(repoURL + path) : new URL(repoURL + "?" + path);
        }
        try {
            GhidraURLConnection c = (GhidraURLConnection)ghidraURL.openConnection();
            Msg.debug(IterateRepository.class, (Object)("Opening ghidra repository: " + ghidraURL));
            Object obj = c.getContent();
            if (!(obj instanceof GhidraURLWrappedContent)) {
                throw new IOException("Connect to repository folder failed");
            }
            Object consumer = new Object();
            GhidraURLWrappedContent wrappedContent = (GhidraURLWrappedContent)obj;
            Object content = null;
            try {
                content = wrappedContent.getContent(consumer);
                if (!(content instanceof DomainFolder)) {
                    throw new IOException("Connect to repository folder failed");
                }
                DomainFolder folder = (DomainFolder)content;
                int totalFiles = this.getTotalFileCount(folder);
                monitor.setMaximum((long)totalFiles);
                monitor.setShowProgressValue(true);
                if (finalelement != null) {
                    DomainFolder subfolder = folder.getFolder(finalelement);
                    if (subfolder != null) {
                        folder = subfolder;
                    } else {
                        DomainFile file = folder.getFile(finalelement);
                        if (file == null) {
                            throw new IOException("Bad folder/file element: " + finalelement);
                        }
                        this.process(file, monitor);
                        return;
                    }
                }
                this.process(folder, monitor);
            }
            finally {
                if (content != null) {
                    wrappedContent.release(content, consumer);
                }
            }
        }
        catch (NotConnectedException e) {
            throw new IOException("Ghidra repository connection failed (" + repoURL + "): " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IOException("Repository path not found: " + path);
        }
    }

    private void process(DomainFolder folder, TaskMonitor monitor) throws Exception, CancelledException {
        for (DomainFile domainFile : folder.getFiles()) {
            monitor.checkCancelled();
            this.process(domainFile, monitor);
        }
        for (DomainFile domainFile : folder.getFolders()) {
            monitor.checkCancelled();
            this.process((DomainFolder)domainFile, monitor);
        }
    }

    private int getTotalFileCount(DomainFolder folder) {
        int count = 0;
        count += folder.getFiles().length;
        for (DomainFolder subfolder : folder.getFolders()) {
            count += this.getTotalFileCount(subfolder);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(DomainFile file, TaskMonitor monitor) throws Exception, CancelledException {
        if (!"Program".equals(file.getContentType())) {
            return;
        }
        Program program = null;
        Object consumer = new Object();
        try {
            Msg.debug(IterateRepository.class, (Object)("Processing " + file.getPathname() + "..."));
            monitor.setMessage("Processing: " + file.getName());
            monitor.incrementProgress(1L);
            program = (Program)file.getReadOnlyDomainObject(consumer, -1, monitor);
            this.process(program, monitor);
        }
        catch (VersionException e) {
            Msg.error(IterateRepository.class, (Object)("Failed to process file " + file.getPathname() + ": " + e.getMessage()));
        }
        finally {
            if (program != null) {
                program.release(consumer);
            }
        }
    }
}

