/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.util.Msg;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

public class GhidraClassLoader
extends URLClassLoader {
    public static final String ENABLE_RESTRICTED_EXTENSIONS_PROPERTY = "ghidra.extensions.classpath.restricted";
    public static final String CP = "java.class.path";
    public static final String CP_EXT = "java.class.path.ext";

    public GhidraClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        try {
            System.setProperty(CP, System.getProperty(CP) + File.pathSeparatorChar + new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            Msg.debug(this, "URL is not a valid path: " + url);
        }
    }

    public boolean addPath(String path) {
        try {
            this.addURL(new File(path).toURI().toURL());
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void appendToClassPathForInstrumentation(String path) {
        this.addPath(path);
    }
}

