/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.CursorPosition;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;
import ghidra.app.plugin.core.decompile.actions.FieldBasedSearchLocation;
import java.util.List;
import java.util.Objects;

public class DecompilerSearcher
implements FindDialogSearcher {
    private DecompilerPanel decompilerPanel;

    public DecompilerSearcher(DecompilerPanel decompilerPanel) {
        this.decompilerPanel = decompilerPanel;
    }

    public CursorPosition getCursorPosition() {
        FieldLocation fieldLocation = this.decompilerPanel.getCursorPosition();
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getStart() {
        int lineNumber = 0;
        int fieldNumber = 0;
        int column = 0;
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, 0, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getEnd() {
        List<Field> lines = this.decompilerPanel.getFields();
        int lineNumber = lines.size() - 1;
        ClangTextField textLine = (ClangTextField)lines.get(lineNumber);
        int fieldNumber = 0;
        int rowCount = textLine.getNumRows();
        int row = rowCount - 1;
        int column = textLine.getNumCols(row);
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, row, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public void setCursorPosition(CursorPosition position) {
        this.decompilerPanel.setCursorPosition(((DecompilerCursorPosition)position).getFieldLocation());
    }

    public void highlightSearchResults(SearchLocation location) {
        this.decompilerPanel.setSearchResults(location);
    }

    public SearchLocation search(String text, CursorPosition position, boolean searchForward, boolean useRegex) {
        DecompilerCursorPosition decompilerCursorPosition = (DecompilerCursorPosition)position;
        FieldLocation startLocation = this.getNextSearchStartLocation(decompilerCursorPosition, searchForward);
        return useRegex ? this.decompilerPanel.searchTextRegex(text, startLocation, searchForward) : this.decompilerPanel.searchText(text, startLocation, searchForward);
    }

    private FieldLocation getNextSearchStartLocation(DecompilerCursorPosition decompilerCursorPosition, boolean searchForward) {
        FieldLocation startLocation = decompilerCursorPosition.getFieldLocation();
        FieldBasedSearchLocation currentSearchLocation = this.decompilerPanel.getSearchResults();
        if (currentSearchLocation == null) {
            return startLocation;
        }
        if (Objects.equals(startLocation, currentSearchLocation.getFieldLocation())) {
            if (searchForward) {
                ++startLocation.col;
            } else {
                int length = currentSearchLocation.getMatchLength();
                startLocation.col += length - 1;
            }
        }
        return startLocation;
    }
}

