/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class CommitParamsAction
extends AbstractDecompilerAction {
    public CommitParamsAction() {
        super("Commit Params/Return");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionCommitParams"));
        this.setPopupMenuData(new MenuData(new String[]{"Commit Params/Return"}, "Commit"));
        this.setKeyBindingData(new KeyBindingData(80, 0));
        this.setDescription("Save Parameters/Return definitions to Program, locking them into their current type definitions");
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        return context.getHighFunction() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        int transaction = program.startTransaction("Commit Params/Return");
        try {
            HighFunction hfunc = context.getHighFunction();
            SourceType source = SourceType.ANALYSIS;
            if (hfunc.getFunction().getSignatureSource() == SourceType.USER_DEFINED) {
                source = SourceType.USER_DEFINED;
            }
            HighFunctionDBUtil.commitReturnToDatabase((HighFunction)hfunc, (SourceType)source);
            HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunc, (boolean)true, (SourceType)source);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }
}

