/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GIcon;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.DecompilerMarginService;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerCallbackHandler;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerProgramListener;
import ghidra.app.decompiler.component.LocationClangHighlightController;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.nav.DecoratorPanel;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerClipboardProvider;
import ghidra.app.plugin.core.decompile.DecompilerLocationMemento;
import ghidra.app.plugin.core.decompile.actions.BackwardsSliceAction;
import ghidra.app.plugin.core.decompile.actions.BackwardsSliceToPCodeOpsAction;
import ghidra.app.plugin.core.decompile.actions.CloneDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.CommitLocalsAction;
import ghidra.app.plugin.core.decompile.actions.CommitParamsAction;
import ghidra.app.plugin.core.decompile.actions.ConvertBinaryAction;
import ghidra.app.plugin.core.decompile.actions.ConvertCharAction;
import ghidra.app.plugin.core.decompile.actions.ConvertDecAction;
import ghidra.app.plugin.core.decompile.actions.ConvertDoubleAction;
import ghidra.app.plugin.core.decompile.actions.ConvertFloatAction;
import ghidra.app.plugin.core.decompile.actions.ConvertHexAction;
import ghidra.app.plugin.core.decompile.actions.ConvertOctAction;
import ghidra.app.plugin.core.decompile.actions.CreatePointerRelative;
import ghidra.app.plugin.core.decompile.actions.DebugDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.DecompilerStructureVariableAction;
import ghidra.app.plugin.core.decompile.actions.DeletePrototypeOverrideAction;
import ghidra.app.plugin.core.decompile.actions.EditDataTypeAction;
import ghidra.app.plugin.core.decompile.actions.EditPropertiesAction;
import ghidra.app.plugin.core.decompile.actions.ExportToCAction;
import ghidra.app.plugin.core.decompile.actions.FindAction;
import ghidra.app.plugin.core.decompile.actions.FindReferencesToAddressAction;
import ghidra.app.plugin.core.decompile.actions.FindReferencesToDataTypeAction;
import ghidra.app.plugin.core.decompile.actions.FindReferencesToHighSymbolAction;
import ghidra.app.plugin.core.decompile.actions.ForceUnionAction;
import ghidra.app.plugin.core.decompile.actions.ForwardSliceAction;
import ghidra.app.plugin.core.decompile.actions.ForwardSliceToPCodeOpsAction;
import ghidra.app.plugin.core.decompile.actions.GoToNextBraceAction;
import ghidra.app.plugin.core.decompile.actions.GoToPreviousBraceAction;
import ghidra.app.plugin.core.decompile.actions.HighlightDefinedUseAction;
import ghidra.app.plugin.core.decompile.actions.IsolateVariableAction;
import ghidra.app.plugin.core.decompile.actions.ListingStructureVariableAction;
import ghidra.app.plugin.core.decompile.actions.OverridePrototypeAction;
import ghidra.app.plugin.core.decompile.actions.PCodeCfgAction;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgAction;
import ghidra.app.plugin.core.decompile.actions.RemoveAllSecondaryHighlightsAction;
import ghidra.app.plugin.core.decompile.actions.RemoveEquateAction;
import ghidra.app.plugin.core.decompile.actions.RemoveLabelAction;
import ghidra.app.plugin.core.decompile.actions.RemoveSecondaryHighlightAction;
import ghidra.app.plugin.core.decompile.actions.RenameFieldAction;
import ghidra.app.plugin.core.decompile.actions.RenameFunctionAction;
import ghidra.app.plugin.core.decompile.actions.RenameGlobalAction;
import ghidra.app.plugin.core.decompile.actions.RenameLabelAction;
import ghidra.app.plugin.core.decompile.actions.RenameLocalAction;
import ghidra.app.plugin.core.decompile.actions.RetypeFieldAction;
import ghidra.app.plugin.core.decompile.actions.RetypeGlobalAction;
import ghidra.app.plugin.core.decompile.actions.RetypeLocalAction;
import ghidra.app.plugin.core.decompile.actions.RetypeReturnAction;
import ghidra.app.plugin.core.decompile.actions.SelectAllAction;
import ghidra.app.plugin.core.decompile.actions.SetEquateAction;
import ghidra.app.plugin.core.decompile.actions.SetSecondaryHighlightAction;
import ghidra.app.plugin.core.decompile.actions.SetSecondaryHighlightColorChooserAction;
import ghidra.app.plugin.core.decompile.actions.SpecifyCPrototypeAction;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.QueryData;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.NavigatableComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import ghidra.util.task.SwingUpdateManager;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.Icons;
import resources.MultiIconBuilder;
import utility.function.Callback;

public class DecompilerProvider
extends NavigatableComponentProviderAdapter
implements OptionsChangeListener,
DecompilerCallbackHandler,
DecompilerHighlightService,
DecompilerMarginService {
    private static final String OPTIONS_TITLE = "Decompiler";
    private static final Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static final Icon C_SOURCE_ICON = new GIcon("icon.decompiler.action.provider");
    private static final Icon SLASH_ICON = new GIcon("icon.decompiler.action.slash");
    private static final Icon TOGGLE_UNREACHABLE_CODE_ICON = new GIcon("icon.decompiler.action.provider.unreachable");
    private static final Icon TOGGLE_UNREACHABLE_CODE_DISABLED_ICON = new MultiIconBuilder(TOGGLE_UNREACHABLE_CODE_ICON).addCenteredIcon(SLASH_ICON).build();
    private static final Icon TOGGLE_READ_ONLY_ICON = new GIcon("icon.decompiler.action.provider.readonly");
    private static final Icon TOGGLE_READ_ONLY_DISABLED_ICON = new MultiIconBuilder(TOGGLE_READ_ONLY_ICON).addCenteredIcon(SLASH_ICON).build();
    private DockingAction pcodeGraphAction;
    private DockingAction astGraphAction;
    private ToggleDockingAction displayUnreachableCodeToggle;
    private ToggleDockingAction respectReadOnlyFlags;
    private final DecompilePlugin plugin;
    private ClipboardService clipboardService;
    private DecompilerClipboardProvider clipboardProvider;
    private DecompileOptions decompilerOptions;
    private Program program;
    private ProgramLocation currentLocation;
    private ProgramSelection currentSelection;
    private DecompilerController controller;
    private DecoratorPanel decorationPanel;
    private ClangHighlightController highlightController;
    private ViewerPosition pendingViewerPosition;
    private SwingUpdateManager redecompileUpdater;
    private DecompilerProgramListener programListener;
    private SwingUpdateManager followUpWorkUpdater;
    private Queue<Callback> followUpWork = new ConcurrentLinkedQueue<Callback>();
    private ServiceListener serviceListener = new ServiceListener(){

        public void serviceRemoved(Class<?> interfaceClass, Object service) {
            if (interfaceClass.equals(GraphDisplayBroker.class)) {
                DecompilerProvider.this.graphServiceRemoved();
            }
        }

        public void serviceAdded(Class<?> interfaceClass, Object service) {
            if (interfaceClass.equals(GraphDisplayBroker.class)) {
                DecompilerProvider.this.graphServiceAdded();
            }
        }
    };

    public DecompilerProvider(DecompilePlugin plugin, boolean isConnected) {
        super(plugin.getTool(), OPTIONS_TITLE, plugin.getName(), DecompilerActionContext.class);
        this.plugin = plugin;
        this.clipboardProvider = new DecompilerClipboardProvider(plugin, this);
        this.registerAdjustableFontId("font.decompiler");
        this.setConnected(isConnected);
        this.decompilerOptions = new DecompileOptions();
        this.initializeDecompilerOptions();
        this.controller = new DecompilerController(this, this.decompilerOptions, this.clipboardProvider);
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        this.highlightController = new LocationClangHighlightController();
        decompilerPanel.setHighlightController(this.highlightController);
        this.decorationPanel = new DecoratorPanel((JComponent)decompilerPanel, isConnected);
        if (!isConnected) {
            this.setTransient();
        } else {
            this.addToToolbar();
            this.setKeyBinding(new KeyBindingData(69, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        }
        this.setIcon(C_SOURCE_ICON);
        this.setTitle("Decompile");
        this.setWindowMenuGroup("Decompile");
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.createActions(isConnected);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "DecompilerIntro"));
        this.addToTool();
        this.redecompileUpdater = new SwingUpdateManager(500, 5000, () -> this.doRefresh(false));
        this.followUpWorkUpdater = new SwingUpdateManager(() -> this.doFollowUpWork());
        plugin.getTool().addServiceListener(this.serviceListener);
        this.programListener = new DecompilerProgramListener(this.controller, this.redecompileUpdater);
    }

    public boolean isSnapshot() {
        return !this.isConnected();
    }

    public void closeComponent() {
        super.closeComponent();
        this.controller.clear();
        this.plugin.closeProvider(this);
    }

    public String getWindowGroup() {
        if (this.isConnected()) {
            return "";
        }
        return "disconnected";
    }

    public void componentShown() {
        if (this.program != null && this.currentLocation != null) {
            ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
            ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
            this.decompilerOptions.grabFromToolAndProgram(fieldOptions, opt, this.program);
            this.controller.setOptions(this.decompilerOptions);
            this.refreshToggleButtons();
            this.controller.display(this.program, this.currentLocation, null);
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        Function function = this.controller.getFunction();
        if (function == null) {
            return null;
        }
        if (!this.controller.hasDecompileResults()) {
            return null;
        }
        Address entryPoint = function.getEntryPoint();
        boolean isDecompiling = this.controller.isDecompiling();
        int lineNumber = event != null & !isDecompiling ? this.getDecompilerPanel().getLineNumber(event.getY()) : 0;
        return new DecompilerActionContext(this, entryPoint, isDecompiling, lineNumber);
    }

    public JComponent getComponent() {
        return this.decorationPanel;
    }

    public Program getProgram() {
        return this.program;
    }

    public ProgramLocation getLocation() {
        if (this.currentLocation instanceof DecompilerLocation) {
            return this.currentLocation;
        }
        return this.controller.getDecompilerPanel().getCurrentLocation();
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        ProgramManager programManagerService;
        if (!this.isConnected()) {
            if (this.program == null) {
                this.doSetProgram(gotoProgram);
            } else if (gotoProgram != this.program) {
                this.tool.setStatusInfo("Program location not applicable for this provider!");
                return false;
            }
        }
        if ((programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class)) != null) {
            programManagerService.setCurrentProgram(gotoProgram);
        }
        this.setLocation(location, null);
        this.pendingViewerPosition = null;
        this.plugin.locationChanged(this, location);
        return true;
    }

    public LocationMemento getMemento() {
        ViewerPosition vp = this.controller.getDecompilerPanel().getViewerPosition();
        return new DecompilerLocationMemento(this.program, this.currentLocation, vp);
    }

    public void setMemento(LocationMemento memento) {
        DecompilerLocationMemento decompMemento = (DecompilerLocationMemento)memento;
        this.pendingViewerPosition = decompMemento.getViewerPosition();
    }

    public void requestFocus() {
        this.controller.getDecompilerPanel().requestFocus();
        this.tool.toFront((ComponentProvider)this);
    }

    @Override
    public DecompilerHighlighter createHighlighter(CTokenHighlightMatcher tm) {
        return this.getDecompilerPanel().createHighlighter(tm);
    }

    @Override
    public DecompilerHighlighter createHighlighter(String id, CTokenHighlightMatcher tm) {
        return this.getDecompilerPanel().createHighlighter(id, tm);
    }

    private void doRefresh(boolean optionsChanged) {
        if (!this.isVisible()) {
            return;
        }
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        boolean decompilerEliminatesUnreachable = this.decompilerOptions.isEliminateUnreachable();
        boolean decompilerRespectsReadOnlyFlags = this.decompilerOptions.isRespectReadOnly();
        this.decompilerOptions.grabFromToolAndProgram(fieldOptions, opt, this.program);
        if (!optionsChanged) {
            this.decompilerOptions.setEliminateUnreachable(decompilerEliminatesUnreachable);
            this.decompilerOptions.setRespectReadOnly(decompilerRespectsReadOnlyFlags);
        } else {
            this.refreshToggleButtons();
        }
        this.controller.setOptions(this.decompilerOptions);
        if (this.currentLocation != null) {
            this.controller.refreshDisplay(this.program, this.currentLocation, null);
        }
    }

    private void refreshToggleButtons() {
        this.displayUnreachableCodeToggle.setSelected(!this.decompilerOptions.isEliminateUnreachable());
        this.respectReadOnlyFlags.setSelected(!this.decompilerOptions.isRespectReadOnly());
    }

    private void doFollowUpWork() {
        if (this.isBusy()) {
            this.followUpWorkUpdater.updateLater();
            return;
        }
        Callback work = this.followUpWork.poll();
        while (work != null) {
            work.call();
            work = this.followUpWork.poll();
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (!this.isVisible()) {
            return;
        }
        if (options.getName().equals(OPTIONS_TITLE) || options.getName().equals("Listing Fields")) {
            this.doRefresh(true);
        }
    }

    void setClipboardService(ClipboardService service) {
        this.clipboardService = service;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
    }

    public void dispose() {
        super.dispose();
        this.redecompileUpdater.dispose();
        this.followUpWorkUpdater.dispose();
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
        this.controller.dispose();
        this.program = null;
        this.currentLocation = null;
        this.currentSelection = null;
    }

    void doSetProgram(Program newProgram) {
        this.controller.clear();
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this.programListener);
        }
        this.program = newProgram;
        this.currentLocation = null;
        this.currentSelection = null;
        if (this.program != null) {
            this.program.addListener((DomainObjectListener)this.programListener);
            ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
            ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
            this.decompilerOptions.grabFromToolAndProgram(fieldOptions, opt, this.program);
        }
        this.clipboardProvider.setProgram(this.program);
    }

    public void setSelection(ProgramSelection selection) {
        this.currentSelection = selection;
        if (this.isVisible()) {
            this.contextChanged();
            this.controller.setSelection(selection);
        }
        this.clipboardProvider.setSelection(selection);
    }

    public void setHighlight(ProgramSelection highlight) {
    }

    public boolean supportsHighlight() {
        return false;
    }

    void setLocation(ProgramLocation loc, ViewerPosition viewerPosition) {
        Address newAddress;
        Address currentAddress = this.currentLocation != null ? this.currentLocation.getAddress() : null;
        this.currentLocation = loc;
        this.clipboardProvider.setLocation(this.currentLocation);
        Address address = newAddress = this.currentLocation != null ? this.currentLocation.getAddress() : null;
        if (viewerPosition == null) {
            viewerPosition = this.pendingViewerPosition;
        }
        if (this.isVisible() && newAddress != null && !newAddress.equals((Object)currentAddress)) {
            this.controller.display(this.program, loc, viewerPosition);
        }
        this.contextChanged();
        this.pendingViewerPosition = null;
    }

    void refresh() {
        this.controller.refreshDisplay(this.program, this.currentLocation, null);
    }

    void updateOptionsAndRefresh() {
        this.controller.setOptions(this.decompilerOptions);
        this.refresh();
    }

    public ProgramSelection getSelection() {
        return this.currentSelection;
    }

    public ProgramSelection getHighlight() {
        return null;
    }

    public String getTextSelection() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        return decompilerPanel.getSelectedText();
    }

    boolean isBusy() {
        return this.redecompileUpdater.isBusy() || this.controller.isDecompiling();
    }

    String currentTokenToString() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        FieldLocation cursor = decompilerPanel.getCursorPosition();
        List<ClangLine> lines = decompilerPanel.getLines();
        ClangLine line = lines.get(cursor.getRow());
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        List<ClangToken> tokens = Arrays.asList(tokenAtCursor);
        String string = line.toDebugString(tokens);
        return string;
    }

    void setCursorLocation(int lineNumber, int offset) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        int row = lineNumber - 1;
        BigInteger index = BigInteger.valueOf(row);
        FieldLocation location = new FieldLocation(index, 0, 0, offset);
        decompilerPanel.setCursorPosition(location);
    }

    public DecompilerController getController() {
        return this.controller;
    }

    @Override
    public void setStatusMessage(String message) {
        this.tool.setStatusInfo(message);
    }

    @Override
    public void decompileDataChanged(DecompileData decompileData) {
        this.updateTitle();
        this.contextChanged();
        this.controller.setSelection(this.currentSelection);
    }

    @Override
    public void locationChanged(ProgramLocation programLocation) {
        if (programLocation.equals((Object)this.currentLocation)) {
            return;
        }
        this.currentLocation = programLocation;
        this.contextChanged();
        this.plugin.locationChanged(this, programLocation);
    }

    @Override
    public void selectionChanged(ProgramSelection programSelection) {
        this.currentSelection = programSelection;
        this.contextChanged();
        this.plugin.selectionChanged(this, programSelection);
    }

    @Override
    public void annotationClicked(AnnotatedTextFieldElement annotation, boolean newWindow) {
        DecompilerProvider navigatable = this;
        if (newWindow) {
            DecompilerProvider newProvider;
            navigatable = newProvider = this.plugin.createNewDisconnectedProvider();
        }
        annotation.handleMouseClicked((Navigatable)navigatable, (ServiceProvider)this.tool);
    }

    @Override
    public void goToLabel(String symbolName, boolean newWindow) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service == null) {
            return;
        }
        SymbolIterator symbolIterator = this.program.getSymbolTable().getSymbols(symbolName);
        if (!symbolIterator.hasNext()) {
            this.tool.setStatusInfo(symbolName + " not found.");
            return;
        }
        DecompilerProvider navigatable = this;
        if (newWindow) {
            DecompilerProvider newProvider;
            navigatable = newProvider = this.plugin.createNewDisconnectedProvider();
        }
        QueryData queryData = new QueryData(symbolName, true);
        service.goToQuery((Navigatable)navigatable, null, queryData, null, null);
    }

    @Override
    public void goToScalar(long value, boolean newWindow) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service == null) {
            return;
        }
        try {
            AddressSpace space = this.controller.getFunction().getEntryPoint().getAddressSpace();
            this.goToAddress(space.getAddress(value), newWindow);
            return;
        }
        catch (AddressOutOfBoundsException space) {
            try {
                AddressSpace space2 = this.controller.getFunction().getEntryPoint().getAddressSpace();
                space2.getAddress(value);
                this.goToAddress(this.program.getAddressFactory().getDefaultAddressSpace().getAddress(value), newWindow);
            }
            catch (AddressOutOfBoundsException e) {
                this.tool.setStatusInfo("Invalid address: " + value);
            }
            return;
        }
    }

    @Override
    public void goToAddress(Address address, boolean newWindow) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service == null) {
            return;
        }
        DecompilerProvider navigatable = this;
        if (newWindow) {
            DecompilerProvider newProvider;
            navigatable = newProvider = this.plugin.createNewDisconnectedProvider();
        }
        service.goTo((Navigatable)navigatable, new ProgramLocation(this.program, address), this.program);
    }

    @Override
    public void goToFunction(Function function, boolean newWindow) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service == null) {
            return;
        }
        DecompilerProvider navigatable = this;
        if (newWindow) {
            DecompilerProvider newProvider;
            navigatable = newProvider = this.plugin.createNewDisconnectedProvider();
        }
        if (function.isExternal()) {
            Symbol symbol = function.getSymbol();
            ExternalManager externalManager = this.program.getExternalManager();
            ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
            service.goToExternalLocation((Navigatable)navigatable, externalLocation, true);
        } else {
            Address address = function.getEntryPoint();
            service.goTo((Navigatable)navigatable, new ProgramLocation(this.program, address), this.program);
        }
    }

    @Override
    public void doWhenNotBusy(Callback c) {
        this.followUpWork.offer(c);
        this.followUpWorkUpdater.update();
    }

    @Override
    public DecompilerPanel getDecompilerPanel() {
        return this.controller.getDecompilerPanel();
    }

    public void cloneWindow() {
        DecompilerProvider newProvider = this.plugin.createNewDisconnectedProvider();
        Swing.runLater(() -> {
            ViewerPosition myViewPosition = this.controller.getDecompilerPanel().getViewerPosition();
            newProvider.doSetProgram(this.program);
            DecompilerPanel myPanel = this.getDecompilerPanel();
            newProvider.setLocation(this.currentLocation, myPanel.getViewerPosition());
            DecompilerPanel newPanel = newProvider.getDecompilerPanel();
            newProvider.doWhenNotBusy(() -> {
                newPanel.setViewerPosition(myViewPosition);
                newPanel.cloneHighlights(myPanel);
            });
        });
    }

    @Override
    public void contextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private void updateTitle() {
        Function function = this.controller.getDecompileData().getFunction();
        String programName = this.program != null ? this.program.getDomainFile().getName() : "";
        Object title = OPTIONS_TITLE;
        Object subTitle = "";
        if (function != null) {
            title = "Decompile: " + function.getName();
            subTitle = " (" + programName + ")";
        }
        if (!this.isConnected()) {
            title = "[" + (String)title + "]";
        }
        this.setTitle((String)title);
        this.setSubTitle((String)subTitle);
    }

    private void initializeDecompilerOptions() {
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        HelpLocation helpLocation = new HelpLocation("DecompilePlugin", "GeneralOptions");
        opt.setOptionsHelpLocation(helpLocation);
        opt.getOptions("Analysis").setOptionsHelpLocation(new HelpLocation("DecompilePlugin", "AnalysisOptions"));
        opt.getOptions("Display").setOptionsHelpLocation(new HelpLocation("DecompilePlugin", "DisplayOptions"));
        this.decompilerOptions.registerOptions(fieldOptions, opt, this.program);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        ToolOptions codeBrowserOptions = this.tool.getOptions("Listing Fields");
        codeBrowserOptions.addOptionsChangeListener((OptionsChangeListener)this);
    }

    private void createActions(boolean isConnected) {
        String owner = this.plugin.getName();
        SelectAllAction selectAllAction = new SelectAllAction(owner, this.controller.getDecompilerPanel());
        DockingAction refreshAction = new DockingAction("Refresh", owner){

            public void actionPerformed(ActionContext context) {
                DecompilerProvider.this.refresh();
            }

            public boolean isEnabledForContext(ActionContext context) {
                DecompileData decompileData = DecompilerProvider.this.controller.getDecompileData();
                if (decompileData == null) {
                    return false;
                }
                return decompileData.hasDecompileResults();
            }
        };
        refreshAction.setToolBarData(new ToolBarData(REFRESH_ICON, "A"));
        refreshAction.setDescription("Push at any time to trigger a re-decompile");
        refreshAction.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarRedecompile"));
        this.displayUnreachableCodeToggle = new ToggleDockingAction("Toggle Unreachable Code", owner){

            public void actionPerformed(ActionContext context) {
                boolean isSelected = this.isSelected();
                DecompilerProvider.this.decompilerOptions.setEliminateUnreachable(!isSelected);
                DecompilerProvider.this.updateOptionsAndRefresh();
            }

            public void setSelected(boolean isSelected) {
                super.setSelected(isSelected);
                if (!isSelected) {
                    DecompilerProvider.this.displayUnreachableCodeToggle.setToolBarData(new ToolBarData(TOGGLE_UNREACHABLE_CODE_ICON, "A"));
                } else {
                    DecompilerProvider.this.displayUnreachableCodeToggle.setToolBarData(new ToolBarData(TOGGLE_UNREACHABLE_CODE_DISABLED_ICON, "A"));
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                DecompileData decompileData = DecompilerProvider.this.controller.getDecompileData();
                if (decompileData == null) {
                    return false;
                }
                return decompileData.hasDecompileResults();
            }
        };
        this.displayUnreachableCodeToggle.setDescription("Toggle off to eliminate unreachable code");
        this.displayUnreachableCodeToggle.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarEliminateUnreachableCode"));
        this.respectReadOnlyFlags = new ToggleDockingAction("Toggle Respecting Read-only Flags", owner){

            public void actionPerformed(ActionContext context) {
                boolean isSelected = this.isSelected();
                DecompilerProvider.this.decompilerOptions.setRespectReadOnly(!isSelected);
                DecompilerProvider.this.updateOptionsAndRefresh();
            }

            public void setSelected(boolean isSelected) {
                super.setSelected(isSelected);
                if (!isSelected) {
                    DecompilerProvider.this.respectReadOnlyFlags.setToolBarData(new ToolBarData(TOGGLE_READ_ONLY_ICON, "A"));
                } else {
                    DecompilerProvider.this.respectReadOnlyFlags.setToolBarData(new ToolBarData(TOGGLE_READ_ONLY_DISABLED_ICON, "A"));
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                DecompileData decompileData = DecompilerProvider.this.controller.getDecompileData();
                if (decompileData == null) {
                    return false;
                }
                return decompileData.hasDecompileResults();
            }
        };
        this.respectReadOnlyFlags.setDescription("Toggle off to respect readonly flags set on memory");
        this.respectReadOnlyFlags.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarRespectReadOnly"));
        this.refreshToggleButtons();
        String functionGroup = "1 - Function Group";
        int subGroupPosition = 0;
        SpecifyCPrototypeAction specifyCProtoAction = new SpecifyCPrototypeAction();
        this.setGroupInfo(specifyCProtoAction, functionGroup, subGroupPosition++);
        OverridePrototypeAction overrideSigAction = new OverridePrototypeAction();
        this.setGroupInfo(overrideSigAction, functionGroup, subGroupPosition++);
        DeletePrototypeOverrideAction deleteSigAction = new DeletePrototypeOverrideAction();
        this.setGroupInfo(deleteSigAction, functionGroup, subGroupPosition++);
        RenameFunctionAction renameFunctionAction = new RenameFunctionAction();
        this.setGroupInfo(renameFunctionAction, functionGroup, subGroupPosition++);
        RenameLabelAction renameLabelAction = new RenameLabelAction();
        this.setGroupInfo(renameLabelAction, functionGroup, subGroupPosition++);
        RemoveLabelAction removeLabelAction = new RemoveLabelAction();
        this.setGroupInfo(removeLabelAction, functionGroup, subGroupPosition++);
        String variableGroup = "2 - Variable Group";
        subGroupPosition = 0;
        RenameLocalAction renameLocalAction = new RenameLocalAction();
        this.setGroupInfo(renameLocalAction, variableGroup, subGroupPosition++);
        RenameGlobalAction renameGlobalAction = new RenameGlobalAction();
        this.setGroupInfo(renameGlobalAction, variableGroup, subGroupPosition++);
        RenameFieldAction renameFieldAction = new RenameFieldAction();
        this.setGroupInfo(renameFieldAction, variableGroup, subGroupPosition++);
        ForceUnionAction forceUnionAction = new ForceUnionAction();
        this.setGroupInfo(forceUnionAction, variableGroup, subGroupPosition++);
        RetypeLocalAction retypeLocalAction = new RetypeLocalAction();
        this.setGroupInfo(retypeLocalAction, variableGroup, subGroupPosition++);
        CreatePointerRelative createRelativeAction = new CreatePointerRelative();
        this.setGroupInfo(createRelativeAction, variableGroup, subGroupPosition++);
        RetypeGlobalAction retypeGlobalAction = new RetypeGlobalAction();
        this.setGroupInfo(retypeGlobalAction, variableGroup, subGroupPosition++);
        RetypeReturnAction retypeReturnAction = new RetypeReturnAction();
        this.setGroupInfo(retypeReturnAction, variableGroup, subGroupPosition++);
        RetypeFieldAction retypeFieldAction = new RetypeFieldAction();
        this.setGroupInfo(retypeFieldAction, variableGroup, subGroupPosition++);
        IsolateVariableAction isolateVarAction = new IsolateVariableAction();
        this.setGroupInfo(isolateVarAction, variableGroup, subGroupPosition++);
        DecompilerStructureVariableAction decompilerCreateStructureAction = new DecompilerStructureVariableAction(owner, this.tool, this.controller);
        this.setGroupInfo(decompilerCreateStructureAction, variableGroup, subGroupPosition++);
        EditDataTypeAction editDataTypeAction = new EditDataTypeAction();
        this.setGroupInfo(editDataTypeAction, variableGroup, subGroupPosition++);
        ListingStructureVariableAction listingCreateStructureAction = new ListingStructureVariableAction(owner, this.tool, this.controller);
        String commitGroup = "3 - Commit Group";
        subGroupPosition = 0;
        CommitParamsAction lockProtoAction = new CommitParamsAction();
        this.setGroupInfo(lockProtoAction, commitGroup, subGroupPosition++);
        CommitLocalsAction lockLocalAction = new CommitLocalsAction();
        this.setGroupInfo(lockLocalAction, commitGroup, subGroupPosition++);
        subGroupPosition = 0;
        String highlightGroup = "4a - Highlight Group";
        this.tool.setMenuGroup(new String[]{"Highlight"}, highlightGroup);
        HighlightDefinedUseAction defUseHighlightAction = new HighlightDefinedUseAction();
        this.setGroupInfo(defUseHighlightAction, highlightGroup, subGroupPosition++);
        ForwardSliceAction forwardSliceAction = new ForwardSliceAction();
        this.setGroupInfo(forwardSliceAction, highlightGroup, subGroupPosition++);
        BackwardsSliceAction backwardSliceAction = new BackwardsSliceAction();
        this.setGroupInfo(backwardSliceAction, highlightGroup, subGroupPosition++);
        ForwardSliceToPCodeOpsAction forwardSliceToOpsAction = new ForwardSliceToPCodeOpsAction();
        this.setGroupInfo(forwardSliceToOpsAction, highlightGroup, subGroupPosition++);
        BackwardsSliceToPCodeOpsAction backwardSliceToOpsAction = new BackwardsSliceToPCodeOpsAction();
        this.setGroupInfo(backwardSliceToOpsAction, highlightGroup, subGroupPosition++);
        this.tool.setMenuGroup(new String[]{"Secondary Highlight"}, highlightGroup);
        SetSecondaryHighlightAction setSecondaryHighlightAction = new SetSecondaryHighlightAction();
        this.setGroupInfo(setSecondaryHighlightAction, highlightGroup, subGroupPosition++);
        SetSecondaryHighlightColorChooserAction setSecondaryHighlightColorChooserAction = new SetSecondaryHighlightColorChooserAction();
        this.setGroupInfo(setSecondaryHighlightColorChooserAction, highlightGroup, subGroupPosition++);
        RemoveSecondaryHighlightAction removeSecondaryHighlightAction = new RemoveSecondaryHighlightAction();
        this.setGroupInfo(removeSecondaryHighlightAction, highlightGroup, subGroupPosition++);
        RemoveAllSecondaryHighlightsAction removeAllSecondadryHighlightsAction = new RemoveAllSecondaryHighlightsAction();
        this.setGroupInfo(removeAllSecondadryHighlightsAction, highlightGroup, subGroupPosition++);
        String convertGroup = "7 - Convert Group";
        subGroupPosition = 0;
        RemoveEquateAction removeEquateAction = new RemoveEquateAction();
        this.setGroupInfo(removeEquateAction, convertGroup, subGroupPosition++);
        SetEquateAction setEquateAction = new SetEquateAction(this.plugin);
        this.setGroupInfo(setEquateAction, convertGroup, subGroupPosition++);
        ConvertBinaryAction convertBinaryAction = new ConvertBinaryAction(this.plugin);
        this.setGroupInfo(convertBinaryAction, convertGroup, subGroupPosition++);
        ConvertDecAction convertDecAction = new ConvertDecAction(this.plugin);
        this.setGroupInfo(convertDecAction, convertGroup, subGroupPosition++);
        ConvertFloatAction convertFloatAction = new ConvertFloatAction(this.plugin);
        this.setGroupInfo(convertFloatAction, convertGroup, subGroupPosition++);
        ConvertDoubleAction convertDoubleAction = new ConvertDoubleAction(this.plugin);
        this.setGroupInfo(convertDoubleAction, convertGroup, subGroupPosition++);
        ConvertHexAction convertHexAction = new ConvertHexAction(this.plugin);
        this.setGroupInfo(convertHexAction, convertGroup, subGroupPosition++);
        ConvertOctAction convertOctAction = new ConvertOctAction(this.plugin);
        this.setGroupInfo(convertOctAction, convertGroup, subGroupPosition++);
        ConvertCharAction convertCharAction = new ConvertCharAction(this.plugin);
        this.setGroupInfo(convertCharAction, convertGroup, subGroupPosition++);
        String searchGroup = "comment2 - Search Group";
        subGroupPosition = 0;
        FindAction findAction = new FindAction();
        this.setGroupInfo(findAction, searchGroup, subGroupPosition++);
        String referencesParentGroup = searchGroup;
        FindReferencesToDataTypeAction findReferencesAction = new FindReferencesToDataTypeAction(owner, this.tool, this.controller);
        this.setGroupInfo((DockingAction)findReferencesAction, searchGroup, subGroupPosition++);
        findReferencesAction.getPopupMenuData().setParentMenuGroup(referencesParentGroup);
        FindReferencesToHighSymbolAction findReferencesToSymbolAction = new FindReferencesToHighSymbolAction();
        this.setGroupInfo(findReferencesToSymbolAction, searchGroup, subGroupPosition++);
        findReferencesToSymbolAction.getPopupMenuData().setParentMenuGroup(referencesParentGroup);
        this.addLocalAction((DockingActionIf)findReferencesToSymbolAction);
        FindReferencesToAddressAction findReferencesToAddressAction = new FindReferencesToAddressAction(this.tool, owner);
        this.setGroupInfo((DockingAction)findReferencesToAddressAction, searchGroup, subGroupPosition++);
        findReferencesToAddressAction.getPopupMenuData().setParentMenuGroup(referencesParentGroup);
        this.addLocalAction((DockingActionIf)findReferencesToAddressAction);
        String optionsGroup = "comment6 - Options Group";
        subGroupPosition = 0;
        EditPropertiesAction propertiesAction = new EditPropertiesAction(owner, this.tool);
        this.setGroupInfo(propertiesAction, optionsGroup, subGroupPosition++);
        DebugDecompilerAction debugFunctionAction = new DebugDecompilerAction(this.controller);
        ExportToCAction convertAction = new ExportToCAction();
        CloneDecompilerAction cloneDecompilerAction = new CloneDecompilerAction();
        GoToNextBraceAction goToNextBraceAction = new GoToNextBraceAction();
        GoToPreviousBraceAction goToPreviousBraceAction = new GoToPreviousBraceAction();
        this.addLocalAction((DockingActionIf)refreshAction);
        this.addLocalAction((DockingActionIf)this.displayUnreachableCodeToggle);
        this.addLocalAction((DockingActionIf)this.respectReadOnlyFlags);
        this.addLocalAction((DockingActionIf)selectAllAction);
        this.addLocalAction((DockingActionIf)defUseHighlightAction);
        this.addLocalAction((DockingActionIf)forwardSliceAction);
        this.addLocalAction((DockingActionIf)backwardSliceAction);
        this.addLocalAction((DockingActionIf)forwardSliceToOpsAction);
        this.addLocalAction((DockingActionIf)backwardSliceToOpsAction);
        this.addLocalAction((DockingActionIf)lockProtoAction);
        this.addLocalAction((DockingActionIf)lockLocalAction);
        this.addLocalAction((DockingActionIf)renameLocalAction);
        this.addLocalAction((DockingActionIf)renameGlobalAction);
        this.addLocalAction((DockingActionIf)renameFieldAction);
        this.addLocalAction((DockingActionIf)forceUnionAction);
        this.addLocalAction((DockingActionIf)setSecondaryHighlightAction);
        this.addLocalAction((DockingActionIf)setSecondaryHighlightColorChooserAction);
        this.addLocalAction((DockingActionIf)removeSecondaryHighlightAction);
        this.addLocalAction((DockingActionIf)removeAllSecondadryHighlightsAction);
        this.addLocalAction((DockingActionIf)convertBinaryAction);
        this.addLocalAction((DockingActionIf)convertDecAction);
        this.addLocalAction((DockingActionIf)convertFloatAction);
        this.addLocalAction((DockingActionIf)convertDoubleAction);
        this.addLocalAction((DockingActionIf)convertHexAction);
        this.addLocalAction((DockingActionIf)convertOctAction);
        this.addLocalAction((DockingActionIf)convertCharAction);
        this.addLocalAction((DockingActionIf)setEquateAction);
        this.addLocalAction((DockingActionIf)removeEquateAction);
        this.addLocalAction((DockingActionIf)retypeLocalAction);
        this.addLocalAction((DockingActionIf)createRelativeAction);
        this.addLocalAction((DockingActionIf)retypeGlobalAction);
        this.addLocalAction((DockingActionIf)retypeReturnAction);
        this.addLocalAction((DockingActionIf)retypeFieldAction);
        this.addLocalAction((DockingActionIf)isolateVarAction);
        this.addLocalAction((DockingActionIf)decompilerCreateStructureAction);
        this.tool.addAction((DockingActionIf)listingCreateStructureAction);
        this.addLocalAction((DockingActionIf)editDataTypeAction);
        this.addLocalAction((DockingActionIf)specifyCProtoAction);
        this.addLocalAction((DockingActionIf)overrideSigAction);
        this.addLocalAction((DockingActionIf)deleteSigAction);
        this.addLocalAction((DockingActionIf)renameFunctionAction);
        this.addLocalAction((DockingActionIf)renameLabelAction);
        this.addLocalAction((DockingActionIf)removeLabelAction);
        this.addLocalAction((DockingActionIf)debugFunctionAction);
        this.addLocalAction((DockingActionIf)convertAction);
        this.addLocalAction((DockingActionIf)findAction);
        this.addLocalAction((DockingActionIf)findReferencesAction);
        this.addLocalAction((DockingActionIf)propertiesAction);
        this.addLocalAction((DockingActionIf)cloneDecompilerAction);
        this.addLocalAction((DockingActionIf)goToNextBraceAction);
        this.addLocalAction((DockingActionIf)goToPreviousBraceAction);
        this.graphServiceAdded();
    }

    private void setGroupInfo(DockingAction action, String group, int subGroupPosition) {
        MenuData popupMenuData = action.getPopupMenuData();
        popupMenuData.setMenuGroup(group);
        popupMenuData.setMenuSubGroup(Integer.toString(subGroupPosition));
    }

    private void graphServiceRemoved() {
        if (this.pcodeGraphAction == null) {
            return;
        }
        if (this.tool.getService(GraphDisplayBroker.class) == null) {
            this.tool.removeAction((DockingActionIf)this.pcodeGraphAction);
            this.tool.removeAction((DockingActionIf)this.astGraphAction);
            this.astGraphAction.dispose();
            this.pcodeGraphAction.dispose();
            this.pcodeGraphAction = null;
            this.astGraphAction = null;
        }
    }

    private void graphServiceAdded() {
        GraphDisplayBroker service = (GraphDisplayBroker)this.tool.getService(GraphDisplayBroker.class);
        if (service != null && service.getDefaultGraphDisplayProvider() != null) {
            this.pcodeGraphAction = new PCodeCfgAction();
            this.addLocalAction((DockingActionIf)this.pcodeGraphAction);
            this.astGraphAction = new PCodeDfgAction();
            this.addLocalAction((DockingActionIf)this.astGraphAction);
        }
    }

    @Override
    public void exportLocation() {
        if (this.program != null && this.currentLocation != null) {
            this.plugin.exportLocation(this.program, this.currentLocation);
        }
    }

    public void writeDataState(SaveState saveState) {
        super.writeDataState(saveState);
        if (this.currentLocation != null) {
            this.currentLocation.saveState(saveState);
        }
        ViewerPosition vp = this.controller.getDecompilerPanel().getViewerPosition();
        saveState.putInt("INDEX", vp.getIndexAsInt());
        saveState.putInt("Y_OFFSET", vp.getYOffset());
    }

    public void readDataState(SaveState saveState) {
        super.readDataState(saveState);
        int index = saveState.getInt("INDEX", 0);
        int yOffset = saveState.getInt("Y_OFFSET", 0);
        ViewerPosition vp = new ViewerPosition(index, 0, yOffset);
        if (this.program != null && this.isVisible()) {
            this.currentLocation = ProgramLocation.getLocation((Program)this.program, (SaveState)saveState);
            if (this.currentLocation != null) {
                this.controller.display(this.program, this.currentLocation, vp);
            }
        }
    }

    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program p) {
    }

    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program p) {
    }

    public void programClosed(Program closedProgram) {
        this.controller.programClosed(closedProgram);
    }

    public void tokenRenamed(ClangToken tokenAtCursor, String newName) {
        this.plugin.handleTokenRenamed(tokenAtCursor, newName);
    }

    void handleTokenRenamed(ClangToken tokenAtCursor, String newName) {
        this.controller.getDecompilerPanel().tokenRenamed(tokenAtCursor, newName);
    }

    @Override
    public void addMarginProvider(DecompilerMarginProvider provider) {
        this.getDecompilerPanel().addMarginProvider(provider);
    }

    @Override
    public void removeMarginProvider(DecompilerMarginProvider provider) {
        this.getDecompilerPanel().removeMarginProvider(provider);
    }
}

