/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.Msg;

public class ClangVariableDecl
extends ClangTokenGroup {
    private DataType datatype = null;
    private HighSymbol symbol = null;

    public ClangVariableDecl(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public HighVariable getHighVariable() {
        if (this.symbol != null) {
            return this.symbol.getHighVariable();
        }
        return null;
    }

    public HighSymbol getHighSymbol() {
        return this.symbol;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        long symref = decoder.readUnsignedInteger(AttributeId.ATTRIB_SYMREF);
        super.decode(decoder, pfactory);
        this.symbol = pfactory.getSymbol(symref);
        if (this.symbol == null) {
            Msg.error((Object)this, (Object)("Invalid symbol reference: " + symref + " in " + this.Parent()));
            return;
        }
        this.datatype = this.symbol.getDataType();
    }
}

