/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.feature.vt.api.correlator.address.CodeCompareAddressCorrelation;
import ghidra.program.database.IntRangeMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.awt.Color;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

class DebugUtils {
    private static boolean ENABLED = false;
    private static Random RAND = new Random();

    DebugUtils() {
    }

    static void recordEOLComment(Map<CodeUnit, TreeSet<AddressRange>> map, Program fromProgram, Address startAddress, Address endAddress, Program toProgram, Address minAddress, Address maxAddress) {
        if (DebugUtils.isEnabled()) {
            Listing listing = fromProgram.getListing();
            AddressSet addrSet = new AddressSet(startAddress, endAddress);
            CodeUnitIterator codeUnits = listing.getCodeUnits((AddressSetView)addrSet, true);
            AddressRangeImpl range = new AddressRangeImpl(minAddress, maxAddress);
            while (codeUnits.hasNext()) {
                CodeUnit codeUnit = codeUnits.next();
                TreeSet<Object> set = map.get(codeUnit);
                if (set == null) {
                    set = new TreeSet();
                    map.put(codeUnit, set);
                }
                set.add((AddressRange)range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processMap(Map<CodeUnit, TreeSet<AddressRange>> map, Program program) {
        if (DebugUtils.isEnabled()) {
            int transactionID = -1;
            try {
                transactionID = program.startTransaction("Colorize CodeCompare");
                Set<Map.Entry<CodeUnit, TreeSet<AddressRange>>> entrySet = map.entrySet();
                for (Map.Entry<CodeUnit, TreeSet<AddressRange>> entry : entrySet) {
                    entry.getKey().setComment(0, entry.getValue().toString());
                }
            }
            finally {
                if (transactionID != -1) {
                    program.endTransaction(transactionID, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void colorize(Map<Address, CodeCompareAddressCorrelation.CorrelationContainer> map, Program sourceProgram, Program destinationProgram) {
        if (DebugUtils.isEnabled()) {
            int sourceTransactionID = -1;
            int destinationTransactionID = -1;
            try {
                Listing sourceListing = sourceProgram.getListing();
                Listing destinationListing = destinationProgram.getListing();
                sourceTransactionID = sourceProgram.startTransaction("Colorize CodeCompare");
                destinationTransactionID = destinationProgram.startTransaction("Colorize CodeCompare");
                Set<Map.Entry<Address, CodeCompareAddressCorrelation.CorrelationContainer>> entrySet = map.entrySet();
                for (Map.Entry<Address, CodeCompareAddressCorrelation.CorrelationContainer> entry : entrySet) {
                    Address sourceAddress = entry.getKey();
                    CodeCompareAddressCorrelation.CorrelationContainer container = entry.getValue();
                    Color color = DebugUtils.pickColor(container);
                    DebugUtils.colorCodeUnits(sourceProgram, color, DebugUtils.getCodeUnit(sourceListing, sourceAddress));
                    DebugUtils.colorCodeUnits(destinationProgram, color, DebugUtils.getCodeUnits(destinationListing, container.range));
                }
            }
            finally {
                if (sourceTransactionID != -1) {
                    sourceProgram.endTransaction(sourceTransactionID, true);
                }
                if (destinationTransactionID != -1) {
                    destinationProgram.endTransaction(destinationTransactionID, true);
                }
            }
        }
    }

    private static CodeUnit getCodeUnit(Listing listing, Address address) {
        return listing.getCodeUnitContaining(address);
    }

    private static CodeUnit[] getCodeUnits(Listing listing, AddressRange addressRange) {
        CodeUnit codeUnit;
        HashSet<CodeUnit> units = new HashSet<CodeUnit>();
        Address address = addressRange.getMinAddress();
        Address maxAddress = addressRange.getMaxAddress();
        while (!address.equals((Object)maxAddress)) {
            codeUnit = listing.getCodeUnitContaining(address);
            units.add(codeUnit);
            try {
                address = address.addNoWrap(1L);
            }
            catch (AddressOverflowException e) {
                Msg.debug(DebugUtils.class, (Object)"Woah...non-contiguous CodeBlock", (Throwable)e);
                break;
            }
        }
        codeUnit = listing.getCodeUnitContaining(maxAddress);
        units.add(codeUnit);
        return units.toArray(new CodeUnit[0]);
    }

    private static void colorCodeUnits(Program program, Color color, CodeUnit ... codeUnits) {
        for (CodeUnit codeUnit : codeUnits) {
            if (codeUnit == null) continue;
            DebugUtils.setBackgroundColor(program, codeUnit.getMinAddress(), codeUnit.getMaxAddress(), color);
        }
    }

    private static void setBackgroundColor(Program program, Address min, Address max, Color c) {
        IntRangeMap map = DebugUtils.getColorRangeMap(program, true);
        if (map != null) {
            map.setValue(min, max, c.getRGB());
        }
    }

    private static IntRangeMap getColorRangeMap(Program program, boolean create) {
        if (program == null) {
            return null;
        }
        IntRangeMap map = program.getIntRangeMap("LISTING_COLOR");
        if (map == null && create) {
            try {
                map = program.createIntRangeMap("LISTING_COLOR");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        return map;
    }

    private static Color pickColor(CodeCompareAddressCorrelation.CorrelationContainer container) {
        float saturation;
        float hue;
        return Color.getHSBColor(hue, saturation, switch (container.kind) {
            case CodeCompareAddressCorrelation.CorrelationKind.CODE_COMPARE -> {
                hue = CodeCompareAddressCorrelation.CorrelationContainer.USE_RANDOM_CC_COLORS ? RAND.nextFloat() : 0.33f;
                saturation = (float)(0.5 - (double)RAND.nextFloat() / 3.0);
                yield (float)(1.0 - (double)RAND.nextFloat() / 5.0);
            }
            case CodeCompareAddressCorrelation.CorrelationKind.LCS -> {
                hue = 0.9f;
                saturation = (float)(0.5 - (double)RAND.nextFloat() / 3.0);
                yield (float)(1.0 - (double)RAND.nextFloat() / 5.0);
            }
            case CodeCompareAddressCorrelation.CorrelationKind.PARAMETERS -> {
                hue = 0.2f;
                saturation = (float)(1.0 - (double)RAND.nextFloat() / 3.0);
                yield (float)(1.0 - (double)RAND.nextFloat() / 3.0);
            }
            default -> {
                hue = 0.1f;
                saturation = 1.0f;
                yield 1.0f;
            }
        });
    }

    public static void enable(boolean b) {
        ENABLED = b;
    }

    private static boolean isEnabled() {
        return ENABLED;
    }
}

