/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.feature.vt.api.correlator.address.CodeCompareAddressCorrelation;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.DiscoverableAddressCorrelator;

public class CodeCompareAddressCorrelator
implements DiscoverableAddressCorrelator {
    private static final String OPTIONS_NAME = "CodeCompareAddressCorrelator";
    private ToolOptions options = new ToolOptions("CodeCompareAddressCorrelator");

    public synchronized AddressCorrelation correlate(Function sourceFunction, Function destinationFunction) {
        Program p1 = sourceFunction.getProgram();
        Program p2 = destinationFunction.getProgram();
        Language l1 = p1.getLanguage();
        Language l2 = p2.getLanguage();
        if (l1.getLanguageID().equals((Object)l2.getLanguageID())) {
            return null;
        }
        return new CodeCompareAddressCorrelation(sourceFunction, destinationFunction);
    }

    public AddressCorrelation correlate(Data sourceData, Data destinationData) {
        return null;
    }

    public ToolOptions getOptions() {
        return this.options;
    }

    public void setOptions(ToolOptions options) {
        options = options.copy();
    }

    public Options getDefaultOptions() {
        return new ToolOptions(OPTIONS_NAME);
    }
}

